/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.stringconverters;

import java.lang.reflect.Field;
import java.util.Map;
import org.eclipse.e4.tm.stringconverter.AbstractStringConverter;
import org.eclipse.e4.tm.stringconverters.ClassStringConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StaticFieldsStringConverter
extends AbstractStringConverter {
    private String prefix;
    private Class fieldsClass;
    private Class valueClass;
    private static int modifiers = 25;

    protected StaticFieldsStringConverter(Class fieldsClass, Class valueClass, String prefix) {
        this.trim = true;
        this.fieldsClass = fieldsClass;
        this.valueClass = valueClass;
        this.prefix = prefix;
    }

    protected void fillValueMap(Map map) {
        Field[] fields = this.fieldsClass.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            if (StaticFieldsStringConverter.testField(field, this.valueClass)) {
                String name = field.getName();
                if (this.prefix == null || name.startsWith(this.prefix)) {
                    try {
                        Object o = field.get(null);
                        map.put(name, o);
                        if (this.prefix != null) {
                            map.put(name.substring(this.prefix.length()), o);
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
            }
            ++i;
        }
    }

    private static <T> boolean testField(Field field, T valueClass) {
        return field != null && valueClass != null && valueClass.equals(field.getType()) && (field.getModifiers() & modifiers) == modifiers;
    }

    @Override
    public Object convert(String source) {
        return StaticFieldsStringConverter.convert(this.fieldsClass, this.valueClass, this.prefix, source, null);
    }

    public static <T> T convert(Class fieldsClass, Class<T> valueClass, String prefix, String source, T def) {
        Field field = null;
        try {
            field = fieldsClass.getField(source);
        }
        catch (Exception exception) {}
        if (field == null && prefix != null) {
            try {
                field = fieldsClass.getField(String.valueOf(prefix) + source);
            }
            catch (Exception exception) {}
        }
        Object result = null;
        if (StaticFieldsStringConverter.testField(field, valueClass) || StaticFieldsStringConverter.testField(field, ClassStringConverter.getPrimitiveType(valueClass))) {
            try {
                result = field.get(null);
            }
            catch (Exception exception) {}
        }
        return (T)(result != null ? result : def);
    }
}

