/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.xwt.ui.XWTUIPlugin;
import org.eclipse.e4.xwt.ui.utils.ProjectUtil;
import org.eclipse.e4.xwt.ui.wizards.NewPresentationWizardPage;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public class NewPresentationWizard
extends NewElementWizard {
    private NewPresentationWizardPage fPage;

    public NewPresentationWizard() {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle("New Data Presentation in XWT");
    }

    public NewPresentationWizard(IType contextType) {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle("New Data Presentation in XWT");
    }

    public void addPages() {
        Object element = this.getSelection().getFirstElement();
        if (!(element instanceof ICompilationUnit) && !(element instanceof IType)) {
            this.getShell().setAlpha(0);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Please select a Java class.");
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    NewPresentationWizard.this.getShell().close();
                }
            });
            return;
        }
        this.fPage = new NewPresentationWizardPage();
        this.fPage.init(this.getSelection());
        this.addPage((IWizardPage)this.fPage);
    }

    public boolean performFinish() {
        this.warnAboutTypeCommentDeprecation();
        boolean res = super.performFinish();
        if (res) {
            this.tryToOpenResource();
            ProjectUtil.updateXWTDataBindingDependencies(this.getCreatedElement().getResource().getProject());
        }
        XWTUIPlugin.getDefault().openXWTPerspective();
        return res;
    }

    private void tryToOpenResource() {
        IResource guiResource;
        IResource resource = this.fPage.getModifiedResource();
        if (resource != null) {
            this.selectAndReveal(resource);
        }
        if ((guiResource = this.fPage.getGuiResource()) != null) {
            this.selectAndReveal(guiResource);
            this.openResource((IFile)guiResource);
        } else {
            this.openResource((IFile)resource);
        }
    }

    public IJavaElement getCreatedElement() {
        return this.fPage.getCreatedType();
    }

    protected boolean canRunForked() {
        return !this.fPage.isEnclosingTypeSelected();
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fPage.createType(monitor);
    }
}

