/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.javascript.ui;

import org.eclipse.e4.emf.ecore.javascript.JavascriptSupport;
import org.eclipse.e4.emf.javascript.ui.AbstractSelectionView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;

public class ScriptScrapbookView
extends AbstractSelectionView {
    private Text scriptTextControl;
    private Text evalResultControl;
    private IAction evalScriptAction = new Action("Eval"){

        public void run() {
            ScriptScrapbookView.this.evalScript(ScriptScrapbookView.this.getScriptControlText(true), false);
        }
    };
    private IAction executeScriptAsCommandAction = new Action("Execute"){

        public void run() {
            ScriptScrapbookView.this.evalScript(ScriptScrapbookView.this.getScriptControlText(true), true);
        }
    };

    public void dispose() {
        this.disposeTextControl(this.scriptTextControl);
        this.disposeTextControl(this.evalResultControl);
        super.dispose();
    }

    private String getScriptControlText(boolean preferSelection) {
        int end;
        int start;
        String script = this.scriptTextControl.getText();
        if (preferSelection && (start = this.scriptTextControl.getSelection().x) < (end = this.scriptTextControl.getSelection().y)) {
            script = script.substring(start, end);
        }
        return script.trim();
    }

    protected void updateView() {
        this.executeScriptAsCommandAction.setEnabled(this.editingDomainProvider != null);
    }

    private void evalScript(String script, boolean evalAsCommand) {
        JavascriptSupport javascriptSupport = (JavascriptSupport)this.getAdapter(JavascriptSupport.class);
        if (javascriptSupport == null) {
            this.setEvalExceptionText("No javascript support");
            return;
        }
        if (this.selection == null) {
            this.setEvalExceptionText("No selection");
            return;
        }
        try {
            NativeObject scope = javascriptSupport.createScope("ScriptScrapBookView");
            scope.setParentScope(javascriptSupport.getScope(this.selection));
            scope.setPrototype((Scriptable)javascriptSupport.wrap(this.selection));
            script = this.getFunctionSource(script);
            this.evalResultControl.setToolTipText("Result of evaluating and calling:\n" + script);
            Object result = javascriptSupport.evaluate(script, (Object)scope, true);
            result = javascriptSupport.callMethod((Object)scope, "ScriptScrapBookView", null, true);
            this.setEvalResultText(result);
        }
        catch (Exception e) {
            this.setEvalResultText(e);
            e.printStackTrace();
        }
    }

    private String getFunctionSource(String script) {
        String[] lines = script.trim().split("[\n\r]");
        script = "function ScriptScrapBookView() { ";
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            if (i == lines.length - 1 && !line.startsWith("return")) {
                line = "return " + line;
            }
            script = String.valueOf(script) + line;
            ++i;
        }
        script = String.valueOf(script) + ";}";
        return script;
    }

    private void setEvalExceptionText(String message) {
        this.setEvalResultText(new IllegalStateException(message));
    }

    private void setEvalResultText(Object result) {
        this.evalResultControl.setBackground(result instanceof Throwable ? this.evalResultControl.getDisplay().getSystemColor(3) : this.scriptTextControl.getBackground());
        this.evalResultControl.setText(String.valueOf(result));
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        SashForm sash = new SashForm(parent, 512);
        this.scriptTextControl = this.createTextControl((Composite)sash, 578);
        this.evalResultControl = this.createTextControl((Composite)sash, 578);
        this.evalResultControl.setEditable(false);
        this.evalResultControl.setBackground(this.scriptTextControl.getBackground());
        sash.setWeights(new int[]{70, 30});
        this.scriptTextControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 && e.stateMask == SWT.MOD1) {
                    ScriptScrapbookView.this.evalScript(ScriptScrapbookView.this.getScriptControlText(true), false);
                }
            }
        });
    }

    public void setFocus() {
        this.scriptTextControl.setFocus();
    }

    protected void createMenu(IMenuManager mgr) {
        super.createMenu(mgr);
        mgr.add(this.evalScriptAction);
    }

    protected void createToolbar(IToolBarManager mgr) {
        super.createToolbar(mgr);
        mgr.add(this.evalScriptAction);
    }
}

