/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.deeplink;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.deeplink.Activator;
import org.eclipse.e4.core.deeplink.DeepLinkBundleList;
import org.eclipse.e4.core.deeplink.DeepLinkResult;
import org.eclipse.e4.core.deeplink.DeepLinkResultException;
import org.eclipse.e4.core.deeplink.DeepLinkURLException;
import org.eclipse.e4.core.deeplink.internal.DeepLinkProperties;
import org.eclipse.e4.core.deeplink.internal.DeepLinkProxy;
import org.eclipse.e4.core.deeplink.internal.DeeplinkPortAssigner;
import org.eclipse.e4.core.deeplink.internal.InstallationLauncher;
import org.eclipse.e4.core.deeplink.internal.ParsedDeepLinkURL;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class DeepLinkManager {
    private static final String DEEPLINK_PROPERTIES_FILE_NAME = "/deeplink4.properties";
    private static final String PROP_FILE_HEADER = "Deep Link 4.0 Configuration";
    private static DeepLinkManager deepLinkManager = null;
    private static final String DEFAULT_SERVER_PATH = "C:\\Program Files\\Deeplink";
    private final String SERVER_CONFIG_PATH;
    private final String SERVER_ROOT_PATH;
    private final String APPLICATION_PROPS;
    private ILog logger;
    private DeepLinkProperties properties;
    private DeeplinkPortAssigner portAssigner;
    private DeepLinkProxy deepLinkProxy;
    private static final int ONE_SECOND = 1000;
    private final String COMMANDLINE_KEY = "application.args";

    public static DeepLinkManager getDefault() {
        return deepLinkManager;
    }

    public DeepLinkManager(boolean regeneratePortNumbersOnClash, ILog logger, String rootPath, String configPath) {
        this.SERVER_ROOT_PATH = rootPath;
        this.SERVER_CONFIG_PATH = configPath;
        this.APPLICATION_PROPS = String.valueOf(this.SERVER_CONFIG_PATH) + DEEPLINK_PROPERTIES_FILE_NAME;
        this.init(regeneratePortNumbersOnClash, logger);
    }

    public DeepLinkManager(boolean regeneratePortNumbersOnClash, ILog logger) {
        this.SERVER_CONFIG_PATH = DEFAULT_SERVER_PATH;
        this.SERVER_ROOT_PATH = DEFAULT_SERVER_PATH;
        this.APPLICATION_PROPS = String.valueOf(this.SERVER_CONFIG_PATH) + DEEPLINK_PROPERTIES_FILE_NAME;
        this.init(regeneratePortNumbersOnClash, logger);
    }

    private void init(boolean regeneratePortNumbersOnClash, ILog logger) {
        deepLinkManager = this;
        this.logger = logger;
        this.properties = this.getDeepLinkProperties();
        this.portAssigner = new DeeplinkPortAssigner(this.properties, regeneratePortNumbersOnClash);
        InstallationLauncher installationLauncher = new InstallationLauncher(this.SERVER_ROOT_PATH, this.properties);
        this.deepLinkProxy = new DeepLinkProxy(installationLauncher);
    }

    public String getInstallationIDFromPath(URL url) {
        int endOfPrefix;
        String fileURL = url.toString();
        String path = fileURL.replace("file:/", "");
        if (path.lastIndexOf(47) == path.length() - 1) {
            path = path.substring(0, path.length() - 1);
        }
        if ((endOfPrefix = path.lastIndexOf(47)) > 0) {
            path = path.substring(endOfPrefix + 1);
        }
        return path;
    }

    public int getPortNumberForInstallation(String installation) {
        int result = this.portAssigner.getPortNumberForInstallation(installation);
        try {
            this.properties.store(this.propsOutputStream(), PROP_FILE_HEADER);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return result;
    }

    public DeepLinkResult processDeepLink(String deepLinkURL) {
        try {
            ParsedDeepLinkURL deepLink = new ParsedDeepLinkURL(deepLinkURL);
            int portNumber = this.portAssigner.getPortNumberForInstallation(deepLink.installation);
            URL httpLink = new URL("http", "localhost", portNumber, "/deeplink" + deepLink.restOfURL);
            DeepLinkResult result = this.deepLinkProxy.execute(deepLink.installation, httpLink, deepLinkURL);
            this.logInfo("INVOKED: " + deepLink.installation + deepLink.restOfURL + "\" loaded=\"" + result.loaded + "\" callbackRan=\"" + result.callbackRan + "\" exception=\"" + result.exception + "\"");
            return result;
        }
        catch (DeepLinkURLException e) {
            this.logFailure("Unable to open URL: " + deepLinkURL, e);
            throw e;
        }
        catch (MalformedURLException e) {
            this.logFailure("Malformed deep link URL (" + e.getMessage() + "): " + deepLinkURL, e);
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IOException e) {
            this.logFailure("Unable to contact deep link handler for: " + deepLinkURL, e);
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (DeepLinkResultException e) {
            this.logFailure("Unable to parse result XML: " + e.getMessage(), e);
            throw e;
        }
    }

    private DeepLinkProperties getDeepLinkProperties() {
        DeepLinkProperties result = new DeepLinkProperties();
        try {
            result.load(this.propsInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return result;
    }

    private OutputStream propsOutputStream() {
        try {
            return new FileOutputStream(new File(this.APPLICATION_PROPS));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private InputStream propsInputStream() {
        try {
            return new FileInputStream(new File(this.APPLICATION_PROPS));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void logInfo(String message) {
        Status status = new Status(1, "org.eclipse.e4.core.deeplink", message);
        this.logger.log((IStatus)status);
    }

    private void logFailure(String message, Throwable t) {
        Status status = new Status(4, "org.eclipse.e4.core.deeplink", message, t);
        this.logger.log((IStatus)status);
    }

    public void startServer() throws BundleException {
        String installation = this.getInstallationIDFromPath(Platform.getInstallLocation().getURL());
        int serverPort = this.getPortNumberForInstallation(installation);
        System.getProperties().setProperty("org.osgi.service.http.port", Integer.toString(serverPort));
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        new DeepLinkBundleList(bundleContext).startupBundlesForHttpServlets();
    }

    public void processCommandLineArguments(IApplicationContext context) {
        final String[] args = (String[])context.getArguments().get("application.args");
        Job deepLinkJob = new Job("Deep Link Launcher"){

            protected IStatus run(IProgressMonitor monitor) {
                String[] stringArray = args;
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    String arg = stringArray[n2];
                    if (arg.startsWith("deeplink://")) {
                        deepLinkManager.processDeepLink(arg);
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        deepLinkJob.schedule(1000L);
    }
}

