/*******************************************************************************
 * Copyright (c) 2011 BestSolution.at and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Tom Schindl <tom.schindl@bestsolution.at> - initial API and implementation
 ******************************************************************************/
package org.eclipse.e4.tools.services.impl;

import java.lang.reflect.ParameterizedType;

import java.lang.reflect.Type;
import java.util.Locale;

import org.eclipse.e4.core.internal.contexts.ContextObjectSupplier;

import org.eclipse.e4.core.internal.di.Requestor;
import org.eclipse.e4.core.services.translation.TranslationService;

import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;

import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.tools.services.IMessageFactoryService;

public class TranslationObjectSupplier extends ExtendedObjectSupplier {

	@Override
	public Object get(IObjectDescriptor descriptor, IRequestor requestor,
			boolean track, boolean group) {
		Class<?> descriptorsClass = getDesiredClass(descriptor.getDesiredType());

		Requestor req = (Requestor) requestor;
		ContextObjectSupplier sub = (ContextObjectSupplier) req
				.getPrimarySupplier();
		
		String locale = (String) sub.getContext().get(TranslationService.LOCALE);
		locale = locale == null ? Locale.getDefault().toString() : locale;
		IMessageFactoryService factoryService = sub.getContext().get(IMessageFactoryService.class); 
		
		try {
			return factoryService.createInstance(locale,descriptorsClass);
		} catch (InstantiationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}

	private Class<?> getDesiredClass(Type desiredType) {
		if (desiredType instanceof Class<?>)
			return (Class<?>) desiredType;
		if (desiredType instanceof ParameterizedType) {
			Type rawType = ((ParameterizedType) desiredType).getRawType();
			if (rawType instanceof Class<?>)
				return (Class<?>) rawType;
		}
		return null;
	}

}