/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.nebula.helpers;

import org.eclipse.e4.ui.css.nebula.gallery.DefaultGalleryItemRendererDelegate;
import org.eclipse.e4.ui.css.nebula.gallery.IGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.swt.graphics.Color;

public class GalleryHelpers {
    private static final String ITEM_RENDERER_KEY = "org.eclipse.e4.ui.css.nebula.helpers.ITEM_RENDERER_KEY";

    public static AbstractGalleryItemRenderer getItemRenderer(GalleryItem galleryItem) {
        return GalleryHelpers.getItemRenderer(galleryItem.getParent());
    }

    public static AbstractGalleryItemRenderer getItemRenderer(Gallery gallery) {
        return gallery.getItemRenderer();
    }

    public static Color getSelectionBackgroundColor(Gallery gallery) {
        IGalleryItemRenderer itemRenderer = GalleryHelpers.getGalleryItemRenderer(gallery);
        if (itemRenderer != null) {
            return itemRenderer.getSelectionBackgroundColor();
        }
        return null;
    }

    public static void setSelectionBackgroundColor(Gallery gallery, Color color) {
        IGalleryItemRenderer itemRenderer = GalleryHelpers.getGalleryItemRenderer(gallery);
        if (itemRenderer != null) {
            itemRenderer.setSelectionBackgroundColor(color);
        }
    }

    public static Color getSelectionForegroundColor(Gallery gallery) {
        IGalleryItemRenderer itemRenderer = GalleryHelpers.getGalleryItemRenderer(gallery);
        if (itemRenderer != null) {
            return itemRenderer.getSelectionForegroundColor();
        }
        return null;
    }

    public static void setSelectionForegroundColor(Gallery gallery, Color color) {
        IGalleryItemRenderer itemRenderer = GalleryHelpers.getGalleryItemRenderer(gallery);
        if (itemRenderer != null) {
            itemRenderer.setSelectionForegroundColor(color);
        }
    }

    public static IGalleryItemRenderer getGalleryItemRenderer(Gallery gallery) {
        AbstractGalleryItemRenderer itemRenderer = gallery.getItemRenderer();
        if (itemRenderer instanceof IGalleryItemRenderer) {
            return (IGalleryItemRenderer)itemRenderer;
        }
        IGalleryItemRenderer galleryItemRenderer = (IGalleryItemRenderer)gallery.getData(ITEM_RENDERER_KEY);
        if (galleryItemRenderer != null) {
            return galleryItemRenderer;
        }
        if (itemRenderer instanceof DefaultGalleryItemRenderer) {
            galleryItemRenderer = new DefaultGalleryItemRendererDelegate((DefaultGalleryItemRenderer)itemRenderer);
        }
        if (itemRenderer instanceof DefaultGalleryItemRenderer) {
            galleryItemRenderer = new DefaultGalleryItemRendererDelegate((DefaultGalleryItemRenderer)itemRenderer);
        }
        if (galleryItemRenderer != null) {
            gallery.setData(ITEM_RENDERER_KEY, (Object)galleryItemRenderer);
        }
        return galleryItemRenderer;
    }
}

