/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.databinding;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.jface.databinding.swt.IWidgetValueProperty;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUtil {
    private static Map<String, IWidgetValueProperty> SWT_PROPERTIES;
    private static Map<String, IProperty> JFACE_PROPERTIES;
    private static ViewerPropertiesCollector viewerCollector;
    private static WidgetPropertiesCollector widgetCollector;
    private static BeanPropertiesCollector beanCollector;

    private PropertyUtil() {
    }

    public static synchronized Map<String, Class<?>> getProperties(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Widget) {
            if (widgetCollector == null) {
                widgetCollector = new WidgetPropertiesCollector();
            }
            return widgetCollector.getProperties(object);
        }
        if (object instanceof Viewer) {
            if (viewerCollector == null) {
                viewerCollector = new ViewerPropertiesCollector();
            }
            return viewerCollector.getProperties(object);
        }
        if (beanCollector == null) {
            beanCollector = new BeanPropertiesCollector();
        }
        return beanCollector.getProperties(object);
    }

    public static synchronized Map<String, IProperty> getJfaceProperties() {
        if (JFACE_PROPERTIES == null) {
            Method[] declaredMethods;
            JFACE_PROPERTIES = new HashMap<String, IProperty>();
            Method[] methodArray = declaredMethods = ViewerProperties.class.getDeclaredMethods();
            int n = declaredMethods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                try {
                    IProperty property = (IProperty)method.invoke(null, new Object[0]);
                    JFACE_PROPERTIES.put(method.getName(), property);
                }
                catch (Exception exception) {
                    JFACE_PROPERTIES.put(method.getName(), null);
                }
                ++n2;
            }
        }
        return JFACE_PROPERTIES;
    }

    public static synchronized Map<String, IWidgetValueProperty> getSwtProperties() {
        if (SWT_PROPERTIES == null) {
            Method[] declaredMethods;
            SWT_PROPERTIES = new HashMap<String, IWidgetValueProperty>();
            Method[] methodArray = declaredMethods = WidgetProperties.class.getDeclaredMethods();
            int n = declaredMethods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                try {
                    IWidgetValueProperty property = (IWidgetValueProperty)method.invoke(null, new Object[0]);
                    SWT_PROPERTIES.put(method.getName(), property);
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
        return SWT_PROPERTIES;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BeanPropertiesCollector
    extends PropertiesCollector {
        BeanPropertiesCollector() {
        }

        @Override
        protected Map<String, Class<?>> createProperties(Object object) {
            if (object == null) {
                return null;
            }
            Class<?> type = object instanceof Class ? (Class<?>)object : object.getClass();
            HashMap result = new HashMap();
            try {
                String propertyName;
                BeanInfo beanInfo = Introspector.getBeanInfo(type);
                PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
                Object[] objectArray = propertyDescriptors;
                int n = propertyDescriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    PropertyDescriptor pd = objectArray[n2];
                    propertyName = pd.getName();
                    if (!"class".equals(propertyName) && !result.containsKey(propertyName) && pd.getPropertyType() != null) {
                        result.put(propertyName, pd.getPropertyType());
                    }
                    ++n2;
                }
                objectArray = type.getDeclaredFields();
                n = objectArray.length;
                n2 = 0;
                while (n2 < n) {
                    Object f = objectArray[n2];
                    propertyName = ((Field)f).getName().toLowerCase();
                    if (!"class".equals(propertyName) && !result.containsKey(propertyName) && !Modifier.isFinal(((Field)f).getModifiers()) && Modifier.isPublic(((Field)f).getModifiers()) && ((Field)f).getType() != null) {
                        result.put(propertyName, ((Field)f).getType());
                    }
                    ++n2;
                }
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class PropertiesCollector {
        private Map<Object, Map<String, Class<?>>> cache = new HashMap();

        PropertiesCollector() {
        }

        Map<String, Class<?>> getProperties(Object object) {
            Map<String, Class<?>> properties = this.cache.get(object);
            if (properties == null) {
                properties = this.createProperties(object);
            }
            return properties;
        }

        abstract Map<String, Class<?>> createProperties(Object var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ViewerPropertiesCollector
    extends PropertiesCollector {
        ViewerPropertiesCollector() {
        }

        @Override
        protected Map<String, Class<?>> createProperties(Object object) {
            IMetaclass metaclass = XWT.getMetaclass((Object)object);
            if (metaclass == null) {
                return null;
            }
            HashMap results = new HashMap();
            Map<String, IProperty> jfaceProperties = PropertyUtil.getJfaceProperties();
            Set<Map.Entry<String, IProperty>> entrySet = jfaceProperties.entrySet();
            for (Map.Entry<String, IProperty> entry : entrySet) {
                String propertyName = entry.getKey();
                IProperty host = entry.getValue();
                Class type = null;
                type = host instanceof ISetProperty ? Set.class : (host instanceof IListProperty ? List.class : Object.class);
                results.put(propertyName, type);
            }
            return results;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WidgetPropertiesCollector
    extends PropertiesCollector {
        WidgetPropertiesCollector() {
        }

        private boolean supportWidget(String name, Class<?> propertyType) {
            IWidgetValueProperty property = PropertyUtil.getSwtProperties().get(name);
            if (property == null) {
                return false;
            }
            Class definedType = (Class)property.getValueType();
            if (propertyType == null || definedType == null) {
                return false;
            }
            boolean support = propertyType.isAssignableFrom(definedType);
            if (support) {
                return true;
            }
            if (propertyType.isPrimitive()) {
                try {
                    Field typeField = definedType.getDeclaredField("TYPE");
                    return propertyType == typeField.get(null);
                }
                catch (Exception exception) {}
            } else if (definedType.isPrimitive()) {
                try {
                    Field typeField = propertyType.getDeclaredField("TYPE");
                    return definedType == typeField.get(null);
                }
                catch (Exception exception) {}
            }
            return false;
        }

        @Override
        protected Map<String, Class<?>> createProperties(Object object) {
            org.eclipse.e4.xwt.metadata.IProperty[] properties;
            IMetaclass metaclass = XWT.getMetaclass((Object)object);
            if (metaclass == null) {
                return null;
            }
            HashMap results = new HashMap();
            org.eclipse.e4.xwt.metadata.IProperty[] iPropertyArray = properties = metaclass.getProperties();
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                Class valueType;
                org.eclipse.e4.xwt.metadata.IProperty iProperty = iPropertyArray[n2];
                String propertyName = iProperty.getName();
                if (this.supportWidget(propertyName, valueType = iProperty.getType())) {
                    results.put(propertyName, valueType);
                }
                ++n2;
            }
            return results;
        }
    }
}

