/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.core.editor.commandstack;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.commandstack.CommandWrap4EMF;
import org.eclipse.e4.xwt.tools.ui.designer.core.editor.commandstack.CommandWrap4GEF;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.gef.commands.CommandStack;

public class CombinedCommandStack
extends BasicCommandStack {
    private boolean stopped;
    private final List<Object> stackListeners;
    private GEFCommandStack gefCommandStack = new GEFCommandStack();

    public CombinedCommandStack() {
        this.stackListeners = new ArrayList<Object>();
    }

    public CommandStack getCommandStack4GEF() {
        return this.gefCommandStack;
    }

    public void addCommandStackListener(CommandStackListener listener) {
        this.stackListeners.add(listener);
    }

    public void removeCommandStackListener(CommandStackListener listener) {
        this.stackListeners.remove(listener);
    }

    protected void notifyListeners() {
        for (Object listener : this.stackListeners) {
            if (listener instanceof org.eclipse.gef.commands.CommandStackListener) {
                ((org.eclipse.gef.commands.CommandStackListener)listener).commandStackChanged(new EventObject((Object)this.gefCommandStack));
                continue;
            }
            if (!(listener instanceof CommandStackListener)) continue;
            ((CommandStackListener)listener).commandStackChanged(new EventObject((Object)this));
        }
    }

    public void execute(Command command) {
        if (this.stopped) {
            if (command != null && command.canExecute()) {
                command.execute();
            }
        } else {
            super.execute(command);
        }
    }

    protected void handleError(Exception exception) {
        if (exception != null) {
            System.out.println("Execute command error:");
            exception.printStackTrace();
        }
        super.handleError(exception);
    }

    public void stop() {
        this.stopped = true;
    }

    public void start() {
        this.stopped = false;
    }

    private class GEFCommandStack
    extends CommandStack {
        private GEFCommandStack() {
        }

        public void addCommandStackListener(org.eclipse.gef.commands.CommandStackListener listener) {
            CombinedCommandStack.this.stackListeners.add(listener);
        }

        public void removeCommandStackListener(org.eclipse.gef.commands.CommandStackListener listener) {
            CombinedCommandStack.this.stackListeners.remove(listener);
        }

        public boolean canRedo() {
            return CombinedCommandStack.this.canRedo();
        }

        public boolean canUndo() {
            return CombinedCommandStack.this.canUndo();
        }

        public void execute(org.eclipse.gef.commands.Command command) {
            if (command != null) {
                Object emfCommand = null;
                emfCommand = command instanceof CommandWrap4EMF ? ((CommandWrap4EMF)command).unwrap() : new CommandWrap4GEF(command);
                CombinedCommandStack.this.execute((Command)emfCommand);
            }
        }

        public void flush() {
            CombinedCommandStack.this.flush();
        }

        public org.eclipse.gef.commands.Command getRedoCommand() {
            Command command = CombinedCommandStack.this.getRedoCommand();
            Object gefCommand = null;
            if (command != null) {
                gefCommand = command instanceof CommandWrap4GEF ? ((CommandWrap4GEF)command).unwrap() : new CommandWrap4EMF(command);
            }
            return gefCommand;
        }

        public org.eclipse.gef.commands.Command getUndoCommand() {
            Command command = CombinedCommandStack.this.getUndoCommand();
            Object gefCommand = null;
            if (command != null) {
                gefCommand = command instanceof CommandWrap4GEF ? ((CommandWrap4GEF)command).unwrap() : new CommandWrap4EMF(command);
            }
            return gefCommand;
        }

        public void redo() {
            CombinedCommandStack.this.redo();
        }

        public void undo() {
            CombinedCommandStack.this.undo();
        }
    }
}

