/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.spi;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class SemanticRevisionStorage
implements IStorage {
    private final IPath myPath;
    private final String myName;
    private byte[] myContents = new byte[0];
    private boolean inputSet = false;

    public SemanticRevisionStorage(ISemanticFileStore store) {
        this.myPath = store.getPath();
        this.myName = store.getName();
    }

    public void setContents(InputStream contents, IProgressMonitor monitor) throws CoreException {
        int currSize = 0;
        try {
            try {
                int available = contents.available();
                while (available > 0) {
                    byte[] buffer = new byte[available];
                    contents.read(buffer);
                    byte[] lastContent = this.myContents;
                    this.myContents = new byte[currSize += available];
                    System.arraycopy(lastContent, 0, this.myContents, 0, lastContent.length);
                    System.arraycopy(buffer, 0, this.myContents, lastContent.length, buffer.length);
                    available = contents.available();
                }
                this.inputSet = true;
            }
            catch (IOException ioe) {
                throw new SemanticResourceException(SemanticResourceStatusCode.CACHED_CONTENT_NOT_FOUND, this.myPath, ioe.getMessage());
            }
        }
        finally {
            Util.safeClose(contents);
        }
    }

    public InputStream getContents() throws CoreException {
        if (!this.inputSet) {
            throw new IllegalStateException("Contents was not set on before calling getContents()");
        }
        return new ByteArrayInputStream(this.myContents);
    }

    public IPath getFullPath() {
        return this.myPath;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isReadOnly() {
        return true;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

