/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.properties;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.tools.services.impl.AbstractTranslationProvider;

public abstract class ProjectOSGiTranslationProvider
extends AbstractTranslationProvider {
    private IProject project;
    private List<String> observedFiles = new ArrayList<String>();
    private IResourceChangeListener listener;
    private String basename;

    public ProjectOSGiTranslationProvider(IProject project) {
        this.project = project;
        this.listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() == 1) {
                    try {
                        event.getDelta().accept(new IResourceDeltaVisitor(){

                            public boolean visit(IResourceDelta delta) throws CoreException {
                                return ProjectOSGiTranslationProvider.this.visit(delta);
                            }
                        });
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.project.getWorkspace().addResourceChangeListener(this.listener);
        IFile f = this.project.getFile("META-INF/MANIFEST.MF");
        if (f.exists()) {
            this.handleManifestChange(f);
        } else {
            this.basename = "OSGI-INF/l10n/bundle";
        }
    }

    boolean visit(IResourceDelta delta) throws CoreException {
        if (delta.getResource() instanceof IWorkspaceRoot) {
            return true;
        }
        if (delta.getResource().equals((Object)this.project)) {
            return true;
        }
        if (delta.getResource().getProjectRelativePath().toString().equals("META-INF")) {
            return true;
        }
        if (delta.getResource().getProjectRelativePath().toString().equals("META-INF/MANIFEST.MF")) {
            this.handleManifestChange((IFile)delta.getResource());
            return false;
        }
        for (String o : this.observedFiles) {
            if (delta.getResource().getProjectRelativePath().toString().equals(o)) {
                this.clearCache();
                return false;
            }
            String[] p = o.split("/");
            int i = 0;
            String path = "";
            do {
                path = String.valueOf(path) + p[i];
                if (delta.getResource().getProjectRelativePath().toString().equals(path)) {
                    return true;
                }
                path = String.valueOf(path) + "/";
            } while (++i < p.length);
        }
        return false;
    }

    private void handleManifestChange(IFile file) {
        try {
            String newValue = ProjectOSGiTranslationProvider.extractBasenameFromManifest(file);
            if (!newValue.equals(this.basename)) {
                if (this.basename != null) {
                    this.basename = newValue;
                    this.clearCache();
                } else {
                    this.basename = newValue;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String extractBasenameFromManifest(IFile file) throws CoreException, IOException {
        String line;
        InputStream in = file.getContents();
        BufferedReader r = new BufferedReader(new InputStreamReader(in));
        String newValue = "OSGI-INF/l10n/bundle";
        while ((line = r.readLine()) != null) {
            if (!line.startsWith("Bundle-Localization:")) continue;
            newValue = line.substring("Bundle-Localization:".length()).trim();
            break;
        }
        r.close();
        return newValue;
    }

    protected InputStream getResourceAsStream(String name) {
        IFile f = this.project.getFile(name);
        this.observedFiles.add(name);
        try {
            if (f.exists()) {
                return f.getContents();
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected void clearCache() {
        super.clearCache();
        this.observedFiles.clear();
    }

    protected String getBasename() {
        return this.basename;
    }

    public void dispose() {
    }
}

