/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.test.unit.internal;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.platform.discovery.runtime.api.IConflict;
import org.eclipse.platform.discovery.runtime.api.ISearchSubdestination;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.AbstractExtensionPointParser;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.SearchSubdestinationExtensionParser;
import org.eclipse.platform.discovery.testutils.utils.registry.ExtensionRegistryBuilder;
import org.eclipse.platform.discovery.testutils.utils.testcases.AbstractExtensionPointParserTest;
import org.junit.Assert;

public class SearchSubdestinationExtensionParserTest
extends AbstractExtensionPointParserTest<ISearchSubdestination> {
    private static final String CATEGORY_ID_DEFAULT_SELECTED = "mycategory";
    private static final String DISPLAY_NAME_DEFAULT_SELECTED = "My Subdestination";
    private static final String ID_DEFAULT_SELECTED = "mysubdestination";
    private static final String OBJECT_ID_DEFAULT_SELECTED = "myobject";
    private static final String CATEGORY_ID_DEFAULT_NOT_SELECTED = "mycategory_notselected";
    private static final String DISPLAY_NAME_DEFAULT_NOT_SELECTED = "My Subdestination _notselected";
    private static final String ID_DEFAULT_NOT_SELECTED = "mysubdestination_notselected";
    private static final String OBJECT_ID_DEFAULT_NOT_SELECTED = "myobject_notselected";
    private static final String CATEGORY_ID_DEFAULT_NULL_SELECTED = "mycategory_nullselected";
    private static final String DISPLAY_NAME_DEFAULT_NULL_SELECTED = "My Subdestination _nullselected";
    private static final String ID_DEFAULT_NULL_SELECTED = "mysubdestination_nullselected";
    private static final String OBJECT_ID_DEFAULT_NULL_SELECTED = "myobject_nullselected";
    private static final Set<String> EXPECTED_CONFLICTS = new HashSet<String>();

    static {
        EXPECTED_CONFLICTS.add("foo");
        EXPECTED_CONFLICTS.add("bar");
        EXPECTED_CONFLICTS.add("baz");
    }

    protected AbstractExtensionPointParser<ISearchSubdestination> createParser(IExtensionRegistry registry) {
        return new SearchSubdestinationExtensionParser(registry);
    }

    protected void setupRegistry(ExtensionRegistryBuilder registryBuilder) {
        registryBuilder.addSearchSubdestination(ID_DEFAULT_SELECTED, DISPLAY_NAME_DEFAULT_SELECTED, CATEGORY_ID_DEFAULT_SELECTED, OBJECT_ID_DEFAULT_SELECTED, "true", new String[]{"foo", "bar", "baz"});
        registryBuilder.addSearchSubdestination(ID_DEFAULT_NOT_SELECTED, DISPLAY_NAME_DEFAULT_NOT_SELECTED, CATEGORY_ID_DEFAULT_NOT_SELECTED, OBJECT_ID_DEFAULT_NOT_SELECTED, "false", new String[]{"foo", "bar", "baz"});
        registryBuilder.addSearchSubdestination(ID_DEFAULT_NULL_SELECTED, DISPLAY_NAME_DEFAULT_NULL_SELECTED, CATEGORY_ID_DEFAULT_NULL_SELECTED, OBJECT_ID_DEFAULT_NULL_SELECTED, null, new String[]{"foo", "bar", "baz"});
    }

    protected void verifyContributions(List<ISearchSubdestination> contributions) {
        Assert.assertEquals((String)"Three contributions expected", (long)3L, (long)contributions.size());
        this.verifySearchSubdestination(contributions.get(0), ID_DEFAULT_SELECTED, DISPLAY_NAME_DEFAULT_SELECTED, CATEGORY_ID_DEFAULT_SELECTED, OBJECT_ID_DEFAULT_SELECTED, true, EXPECTED_CONFLICTS);
        this.verifySearchSubdestination(contributions.get(1), ID_DEFAULT_NOT_SELECTED, DISPLAY_NAME_DEFAULT_NOT_SELECTED, CATEGORY_ID_DEFAULT_NOT_SELECTED, OBJECT_ID_DEFAULT_NOT_SELECTED, false, EXPECTED_CONFLICTS);
        this.verifySearchSubdestination(contributions.get(2), ID_DEFAULT_NULL_SELECTED, DISPLAY_NAME_DEFAULT_NULL_SELECTED, CATEGORY_ID_DEFAULT_NULL_SELECTED, OBJECT_ID_DEFAULT_NULL_SELECTED, true, EXPECTED_CONFLICTS);
    }

    private void verifySearchSubdestination(ISearchSubdestination subdestination, String expectedId, String expectedDisplayName, String expectedCategoryId, String expectedObjectId, boolean isDefaultSelected, Set<String> expectedConflictIds) {
        Assert.assertEquals((String)"wrong id", (Object)expectedId, (Object)subdestination.getId());
        Assert.assertEquals((String)"wrong name", (Object)expectedDisplayName, (Object)subdestination.getDisplayName());
        Assert.assertEquals((String)"wrong category", (Object)expectedCategoryId, (Object)subdestination.getDestinationCategoryId());
        Assert.assertEquals((String)"wrong object type", (Object)expectedObjectId, (Object)subdestination.getObjectTypeId());
        Assert.assertEquals((String)"wrong isDefaultSelected", (Object)isDefaultSelected, (Object)subdestination.isDefaultSelected());
        this.checkConflicts(subdestination, expectedConflictIds);
    }

    private void checkConflicts(ISearchSubdestination subdest, Set<String> expectedConflictIds) {
        HashSet<String> conflictingsubd = new HashSet<String>();
        for (IConflict conf : subdest.getConflictingSubd()) {
            Assert.assertTrue((String)"Duplicate conflict ids not expected", (boolean)conflictingsubd.add(conf.getconflictingSubdID()));
        }
        Assert.assertEquals((String)"unexpected set of conflicts", expectedConflictIds, conflictingsubd);
    }
}

