/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts;

import java.util.Set;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.internal.contexts.Computation;
import org.eclipse.e4.core.internal.contexts.ContextChangeEvent;
import org.eclipse.e4.core.internal.contexts.EclipseContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueComputation
extends Computation {
    private static final Object NotAValue = new Object();
    private final IContextFunction function;
    private final EclipseContext originatingContext;
    private final String name;
    private Object cachedValue = NotAValue;
    private boolean computing;

    public ValueComputation(String name, IEclipseContext originatingContext, IContextFunction computedValue) {
        this.originatingContext = (EclipseContext)originatingContext;
        this.function = computedValue;
        this.name = name;
        this.init();
    }

    @Override
    public void handleInvalid(ContextChangeEvent event, Set<EclipseContext.Scheduled> scheduled) {
        if (this.cachedValue == NotAValue) {
            return;
        }
        this.cachedValue = NotAValue;
        this.originatingContext.invalidate(this.name, 6, event.getOldValue(), IInjector.NOT_A_VALUE, scheduled);
    }

    public boolean shouldRemove(ContextChangeEvent event) {
        boolean definitionChanged;
        int eventType = event.getEventType();
        boolean containerDisposed = eventType == 3 && event.getContext() == this.originatingContext;
        boolean bl = definitionChanged = eventType != 6 && this.name.equals(event.getName());
        return containerDisposed || definitionChanged;
    }

    public Object get() {
        if (this.cachedValue != NotAValue) {
            return this.cachedValue;
        }
        if (this.computing) {
            throw new RuntimeException("Cycle while computing value" + this.toString());
        }
        this.originatingContext.pushComputation(this);
        this.computing = true;
        try {
            this.cachedValue = this.function.compute(this.originatingContext);
        }
        finally {
            this.computing = false;
            this.originatingContext.popComputation(this);
        }
        return this.cachedValue;
    }

    public String toString() {
        if (this.function == null) {
            return super.toString();
        }
        return this.function.toString();
    }

    @Override
    protected int calcHashCode() {
        int result = 1;
        result = 31 * result + (this.function == null ? 0 : this.function.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.originatingContext == null ? 0 : this.originatingContext.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueComputation other = (ValueComputation)obj;
        if (this.function == null ? other.function != null : !this.function.equals(other.function)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.originatingContext == null ? other.originatingContext != null : !this.originatingContext.equals(other.originatingContext));
    }
}

