/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples.wizard;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.ISemanticResource;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.resources.semantic.examples.Messages;
import org.eclipse.core.resources.semantic.examples.SemanticResourcesPluginExamples;
import org.eclipse.core.resources.semantic.examples.providers.SampleWebDAVContentProvider;
import org.eclipse.core.resources.semantic.examples.wizard.AddWebDAVResourceCheckURLPage;
import org.eclipse.core.resources.semantic.examples.wizard.AddWebDAVResourceNameAndURLPage;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class AddWebDAVResourceWizard
extends Wizard
implements INewWizard {
    AddWebDAVResourceNameAndURLPage nameAndUrlPage = new AddWebDAVResourceNameAndURLPage();
    AddWebDAVResourceCheckURLPage checkPage = new AddWebDAVResourceCheckURLPage();

    public AddWebDAVResourceWizard() {
        this.setWindowTitle(Messages.AddWebDAVResourceWizard_WizardTitle_XGRP);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object testObject = selection.getFirstElement();
        if (testObject instanceof IContainer) {
            this.nameAndUrlPage.setResourceContainer((IContainer)testObject);
        } else {
            this.nameAndUrlPage.setResourceContainer(null);
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.nameAndUrlPage);
        this.addPage((IWizardPage)this.checkPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.nameAndUrlPage) {
            this.checkPage.setUrl(this.nameAndUrlPage.getUrl());
        }
        return super.getNextPage(page);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor outerMonitor) throws InvocationTargetException, InterruptedException {
                    URI uri;
                    final ISemanticFolder parentResource = (ISemanticFolder)AddWebDAVResourceWizard.this.nameAndUrlPage.getResourceContainer().getAdapter(ISemanticFolder.class);
                    final boolean asFolder = AddWebDAVResourceWizard.this.checkPage.isFolder();
                    final boolean shouldRetrieveContent = AddWebDAVResourceWizard.this.checkPage.shouldRetrieveContent();
                    String fileOrFolder = asFolder ? "folder" : "file";
                    final boolean forceMode = AddWebDAVResourceWizard.this.nameAndUrlPage.getForceOverwrite();
                    try {
                        if (parentResource != null) {
                            uri = new URI(AddWebDAVResourceWizard.this.nameAndUrlPage.getUrl());
                        } else {
                            IPath newPath = AddWebDAVResourceWizard.this.nameAndUrlPage.getResourceContainer().getFullPath().append(AddWebDAVResourceWizard.this.nameAndUrlPage.getChildName());
                            uri = new URI("semanticfs", null, newPath.toString(), "type=" + fileOrFolder + ";create=true;provider=" + SampleWebDAVContentProvider.class.getName() + ";uri=" + AddWebDAVResourceWizard.this.nameAndUrlPage.getUrl(), null);
                        }
                    }
                    catch (URISyntaxException e1) {
                        throw new InvocationTargetException(e1);
                    }
                    if (outerMonitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    try {
                        IWorkspaceRunnable wsr = new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                if (parentResource != null) {
                                    ISemanticResource resource;
                                    if (parentResource.hasResource((this).AddWebDAVResourceWizard.this.nameAndUrlPage.getChildName())) {
                                        if (!forceMode) {
                                            throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.examples", Messages.AddWebDAVResourceWizard_AlreadyExistsMessaage_XMSG));
                                        }
                                        parentResource.getResource((this).AddWebDAVResourceWizard.this.nameAndUrlPage.getChildName()).remove(2, monitor);
                                    }
                                    if (asFolder) {
                                        ISemanticFolder sFolder = parentResource.addFolder((this).AddWebDAVResourceWizard.this.nameAndUrlPage.getChildName(), SampleWebDAVContentProvider.class.getName(), null, 0, monitor);
                                        sFolder.setRemoteURI(uri, 0, monitor);
                                    } else {
                                        ISemanticFile sFile = parentResource.addFile((this).AddWebDAVResourceWizard.this.nameAndUrlPage.getChildName(), SampleWebDAVContentProvider.class.getName(), null, 0, monitor);
                                        sFile.setRemoteURI(uri, 0, monitor);
                                    }
                                    if (shouldRetrieveContent && (resource = parentResource.getResource((this).AddWebDAVResourceWizard.this.nameAndUrlPage.getChildName())) != null) {
                                        WorkspaceJob job = new WorkspaceJob(Messages.AddWebDAVResourceWizard_RetrieveWebDAVContent_XMSG){

                                            public IStatus runInWorkspace(IProgressMonitor monitor1) throws CoreException {
                                                resource.synchronizeContentWithRemote(SyncDirection.INCOMING, 0, monitor1);
                                                return Status.OK_STATUS;
                                            }
                                        };
                                        job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().refreshRule(resource.getAdaptedResource()));
                                        job.schedule();
                                    }
                                } else {
                                    ISemanticResource sResource;
                                    IFolder resource;
                                    Path childPath;
                                    IContainer container = (this).AddWebDAVResourceWizard.this.nameAndUrlPage.getResourceContainer();
                                    if (container.exists((IPath)(childPath = new Path((this).AddWebDAVResourceWizard.this.nameAndUrlPage.getChildName())))) {
                                        if (!forceMode) {
                                            throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.examples", Messages.AddWebDAVResourceWizard_AlreadyExistsMessaage_XMSG));
                                        }
                                        IResource child = container.findMember((this).AddWebDAVResourceWizard.this.nameAndUrlPage.getChildName());
                                        if (child != null && child.isLinked()) {
                                            IFileStore store;
                                            URI oldURI = child.getLocationURI();
                                            child.delete(true, monitor);
                                            if (oldURI != null && oldURI.getScheme().equals("semanticfs") && (store = EFS.getStore((URI)oldURI)) != null && store instanceof ISemanticFileStore) {
                                                store.delete(0, monitor);
                                            }
                                        } else {
                                            IFile childFile;
                                            IFolder childFolder = container.getFolder((IPath)childPath);
                                            if (childFolder.exists()) {
                                                childFolder.delete(false, monitor);
                                            }
                                            if ((childFile = container.getFile((IPath)childPath)).exists()) {
                                                childFile.delete(false, monitor);
                                            }
                                        }
                                    }
                                    if (asFolder) {
                                        IFolder folder;
                                        resource = folder = container.getFolder((IPath)childPath);
                                        folder.createLink(uri, 0, monitor);
                                    } else {
                                        IFile file = container.getFile((IPath)childPath);
                                        resource = file;
                                        file.createLink(uri, 16, monitor);
                                    }
                                    if (shouldRetrieveContent && (sResource = (ISemanticResource)resource.getAdapter(ISemanticResource.class)) != null) {
                                        WorkspaceJob job = new WorkspaceJob(Messages.AddWebDAVResourceWizard_RetrieveWebDAVContent_XMSG){

                                            public IStatus runInWorkspace(IProgressMonitor monitor1) throws CoreException {
                                                sResource.synchronizeContentWithRemote(SyncDirection.INCOMING, 0, monitor1);
                                                return Status.OK_STATUS;
                                            }
                                        };
                                        job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().refreshRule((IResource)resource));
                                        job.schedule();
                                    }
                                }
                            }
                        };
                        ResourcesPlugin.getWorkspace().run(wsr, outerMonitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            SemanticResourcesPluginExamples.handleError(Messages.AddWebDAVResourceWizard_CreationFailedMessage_XMSG, e.getCause(), true);
            return false;
        }
        catch (InterruptedException e) {
            SemanticResourcesPluginExamples.handleError(Messages.AddWebDAVResourceWizard_ActionAbortedMessage_XMSG, e, true);
            return false;
        }
        return true;
    }
}

