/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.menu.tests;

import java.util.List;
import junit.framework.TestCase;
import org.eclipse.e4.core.commands.CommandServiceAddon;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.bindings.BindingServiceAddon;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.menu.tests.TestUtil;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MCoreExpression;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MExpression;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.impl.UiFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.services.ContextServiceAddon;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.e4.ui.workbench.renderers.swt.ContributionRecord;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.menus.MenuPersistence;

public class MMenuItemTest
extends TestCase {
    static final String PDE_SEARCH_AS_ID = "org.eclipse.pde.ui.SearchActionSet";
    static final String SEARCH_AS_ID = "org.eclipse.search.searchActionSet";
    protected IEclipseContext appContext;
    protected E4Workbench wb;

    private MMenuContribution createContribution(boolean withVisibleWhen) {
        MMenuContribution mmc = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        mmc.setElementId("test.contrib1");
        mmc.setParentId("file");
        mmc.setPositionInParent("after=additions");
        MDirectMenuItem item1 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item1.setElementId("mmc.item1");
        item1.setLabel("mmc.item1");
        mmc.getChildren().add(item1);
        if (withVisibleWhen) {
            MCoreExpression exp = UiFactoryImpl.eINSTANCE.createCoreExpression();
            exp.setCoreExpressionId("org.eclipse.e4.ui.tests.withMmc1");
            mmc.setVisibleWhen((MExpression)exp);
        }
        return mmc;
    }

    private void createMenuContribution(MApplication application) {
        MMenuContribution mmc = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        mmc.setElementId("test.contrib2");
        mmc.setParentId("org.eclipse.ui.main.menu");
        mmc.setPositionInParent("after=additions");
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        menu.setElementId("vanish");
        menu.setLabel("Vanish");
        mmc.getChildren().add(menu);
        MCoreExpression exp = UiFactoryImpl.eINSTANCE.createCoreExpression();
        exp.setCoreExpressionId("org.eclipse.e4.ui.tests.withMmc1");
        mmc.setVisibleWhen((MExpression)exp);
        application.getMenuContributions().add(mmc);
        mmc = MenuFactoryImpl.eINSTANCE.createMenuContribution();
        mmc.setElementId("test.contrib3");
        mmc.setParentId("vanish");
        mmc.setPositionInParent("after=additions");
        MDirectMenuItem item1 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item1.setElementId("mmc.item2");
        item1.setLabel("mmc.item2");
        mmc.getChildren().add(item1);
        application.getMenuContributions().add(mmc);
    }

    private MenuManagerRenderer getRenderer(IEclipseContext context, MUIElement element) {
        IRendererFactory rendererFactory = (IRendererFactory)context.get(IRendererFactory.class);
        AbstractPartRenderer renderer = rendererFactory.getRenderer(element, null);
        MMenuItemTest.assertEquals(MenuManagerRenderer.class, renderer.getClass());
        return (MenuManagerRenderer)renderer;
    }

    protected void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        ContextInjectionFactory.make(CommandServiceAddon.class, (IEclipseContext)this.appContext);
        ContextInjectionFactory.make(ContextServiceAddon.class, (IEclipseContext)this.appContext);
        ContextInjectionFactory.make(BindingServiceAddon.class, (IEclipseContext)this.appContext);
        this.appContext.set("presentationURI", (Object)"bundleclass://org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
    }

    protected void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        this.appContext.dispose();
    }

    public void testContributionRecordMerging() throws Exception {
        MApplication application = TestUtil.setupRenderer(this.appContext);
        MenuManagerRenderer renderer = (MenuManagerRenderer)this.appContext.get(MenuManagerRenderer.class);
        MMenu menuBar = ((MWindow)application.getChildren().get(0)).getMainMenu();
        MenuPersistence mp = new MenuPersistence(application, this.appContext, "org.eclipse.e4.ui.menu.tests.p1");
        mp.reRead();
        List menuContributions = application.getMenuContributions();
        MMenuItemTest.assertEquals((int)6, (int)menuContributions.size());
        ContributionRecord twoMenus = new ContributionRecord(menuBar, (MMenuContribution)menuContributions.get(0), renderer);
        MMenuItemTest.assertTrue((boolean)twoMenus.mergeIntoModel());
        MMenuItemTest.assertEquals((int)2, (int)menuBar.getChildren().size());
        MMenu withHandlers = (MMenu)menuBar.getChildren().get(1);
        MMenuItemTest.assertEquals((int)0, (int)withHandlers.getChildren().size());
        ContributionRecord handlers = new ContributionRecord(withHandlers, (MMenuContribution)menuContributions.get(2), renderer);
        MMenuItemTest.assertTrue((boolean)handlers.mergeIntoModel());
        MMenuItemTest.assertEquals((int)4, (int)withHandlers.getChildren().size());
    }

    public void testMenuContribution() throws Exception {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MMenu menuBar = MenuFactoryImpl.eINSTANCE.createMenu();
        menuBar.setElementId("org.eclipse.ui.main.menu");
        window.setMainMenu(menuBar);
        MMenu fileMenu = MenuFactoryImpl.eINSTANCE.createMenu();
        fileMenu.setElementId("file");
        fileMenu.setLabel("File");
        menuBar.getChildren().add(fileMenu);
        MDirectMenuItem item1 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item1.setElementId("item1");
        item1.setLabel("item1");
        fileMenu.getChildren().add(item1);
        MMenuSeparator sep = MenuFactoryImpl.eINSTANCE.createMenuSeparator();
        sep.setElementId("group1");
        fileMenu.getChildren().add(sep);
        MDirectMenuItem item2 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item2.setElementId("item2");
        item2.setLabel("item2");
        fileMenu.getChildren().add(item2);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        application.getMenuContributions().add(this.createContribution(false));
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MenuManagerRenderer renderer = this.getRenderer(this.appContext, (MUIElement)menuBar);
        MenuManager fileManager = renderer.getManager(fileMenu);
        MMenuItemTest.assertNotNull((String)"No file menu?", (Object)fileManager);
        MMenuItemTest.assertEquals((int)4, (int)fileManager.getSize());
        MMenuItemTest.assertEquals((String)"mmc.item1", (String)fileManager.getItems()[3].getId());
    }

    public void testMenuContributionGeneration() throws Exception {
        MApplication application = TestUtil.setupRenderer(this.appContext);
        MenuManagerRenderer renderer = (MenuManagerRenderer)this.appContext.get(MenuManagerRenderer.class);
        MMenu menuBar = ((MWindow)application.getChildren().get(0)).getMainMenu();
        MenuPersistence mp = new MenuPersistence(application, this.appContext, "org.eclipse.e4.ui.menu.tests.p1");
        mp.reRead();
        Shell shell = new Shell();
        Menu menu = (Menu)renderer.createWidget((MUIElement)menuBar, (Object)shell);
        MMenuItemTest.assertNotNull((Object)menu);
        MMenu obj = menuBar;
        renderer.processContents((MElementContainer)obj);
        MenuManager manager = renderer.getManager(menuBar);
        MMenuItemTest.assertNotNull((Object)manager);
        MMenuItemTest.assertEquals((int)2, (int)manager.getSize());
        MenuManager withGroup = (MenuManager)manager.getItems()[0];
        MMenuItemTest.assertEquals((String)"WithGroup", (String)withGroup.getId());
        MMenuItemTest.assertEquals((int)4, (int)withGroup.getSize());
        IContributionItem[] withGroupItems = withGroup.getItems();
        MMenuItemTest.assertEquals((String)"group1", (String)withGroupItems[0].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.commandOne", (String)withGroupItems[1].getId());
        MMenuItemTest.assertEquals((String)"group2", (String)withGroupItems[2].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.commandTwo", (String)withGroupItems[3].getId());
        MenuManager withHandlers = (MenuManager)manager.getItems()[1];
        MMenuItemTest.assertEquals((String)"WithHandlers", (String)withHandlers.getId());
        MMenuItemTest.assertEquals((int)5, (int)withHandlers.getSize());
        IContributionItem[] withHandlerItems = withHandlers.getItems();
        MMenuItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.commandOne", (String)withHandlerItems[0].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.commandTwo", (String)withHandlerItems[1].getId());
        MMenuItemTest.assertEquals((String)"group1", (String)withHandlerItems[2].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.commandFour", (String)withHandlerItems[3].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.commandThree", (String)withHandlerItems[4].getId());
    }

    public void testMenuContributionVisibility() throws Exception {
        MApplication application = TestUtil.setupRenderer(this.appContext);
        MenuManagerRenderer renderer = (MenuManagerRenderer)this.appContext.get(MenuManagerRenderer.class);
        MMenu menuBar = ((MWindow)application.getChildren().get(0)).getMainMenu();
        MenuPersistence mp = new MenuPersistence(application, this.appContext, "org.eclipse.e4.ui.menu.tests.p4");
        mp.reRead();
        Shell shell = new Shell();
        Menu menu = (Menu)renderer.createWidget((MUIElement)menuBar, (Object)shell);
        MMenuItemTest.assertNotNull((Object)menu);
        MMenu obj = menuBar;
        renderer.processContents((MElementContainer)obj);
        MenuManager manager = renderer.getManager(menuBar);
        MMenuItemTest.assertNotNull((Object)manager);
        MMenuItemTest.assertEquals((int)2, (int)manager.getSize());
        MenuManager withGroup = (MenuManager)manager.getItems()[0];
        MMenuItemTest.assertEquals((String)"WithGroup", (String)withGroup.getId());
        MMenuItemTest.assertEquals((int)5, (int)withGroup.getSize());
        IContributionItem[] withGroupItems = withGroup.getItems();
        MMenuItemTest.assertEquals((String)"group1", (String)withGroupItems[0].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.commandOne", (String)withGroupItems[1].getId());
        IContributionItem p4InvOne = withGroupItems[2];
        MMenuItemTest.assertEquals((String)"p4.invisible.commandOne", (String)p4InvOne.getId());
        MMenuItemTest.assertEquals((String)"group2", (String)withGroupItems[3].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.commandTwo", (String)withGroupItems[4].getId());
        MMenuItemTest.assertTrue((boolean)p4InvOne.isVisible());
        Menu withGroupMenu = withGroup.getMenu();
        MMenuItemTest.assertNotNull((Object)withGroupMenu);
        Event show = new Event();
        show.widget = withGroupMenu;
        show.type = 22;
        withGroupMenu.notifyListeners(22, show);
        Event hide = new Event();
        hide.widget = withGroupMenu;
        hide.type = 23;
        withGroupMenu.notifyListeners(23, hide);
        MMenuItemTest.assertFalse((boolean)p4InvOne.isVisible());
        MWindow window = (MWindow)application.getChildren().get(0);
        IEclipseContext context = window.getContext();
        context.set("selection", (Object)new StructuredSelection((Object)"show.p4.invisible.commandOne"));
        withGroupMenu.notifyListeners(22, show);
        withGroupMenu.notifyListeners(23, hide);
        MMenuItemTest.assertTrue((boolean)p4InvOne.isVisible());
        context.set("selection", (Object)new StructuredSelection(new Object[]{"show.p4.invisible.commandOne", "show.p4.invisible.commandOne"}));
        withGroupMenu.notifyListeners(22, show);
        withGroupMenu.notifyListeners(23, hide);
        MMenuItemTest.assertFalse((boolean)p4InvOne.isVisible());
        context.set("selection", (Object)new StructuredSelection((Object)"show.p4.invisible.commandOne"));
        withGroupMenu.notifyListeners(22, show);
        withGroupMenu.notifyListeners(23, hide);
        MMenuItemTest.assertTrue((boolean)p4InvOne.isVisible());
        context.set("selection", (Object)new StructuredSelection((Object)"hide.p4.invisible.commandOne"));
        withGroupMenu.notifyListeners(22, show);
        withGroupMenu.notifyListeners(23, hide);
        MMenuItemTest.assertFalse((boolean)p4InvOne.isVisible());
        context.set("selection", (Object)new StructuredSelection((Object)"show.p4.invisible.commandOne"));
        withGroupMenu.notifyListeners(22, show);
        withGroupMenu.notifyListeners(23, hide);
        MMenuItemTest.assertTrue((boolean)p4InvOne.isVisible());
        context.remove("selection");
        withGroupMenu.notifyListeners(22, show);
        withGroupMenu.notifyListeners(23, hide);
        MMenuItemTest.assertFalse((boolean)p4InvOne.isVisible());
        MenuManager withHandlers = (MenuManager)manager.getItems()[1];
        MMenuItemTest.assertEquals((String)"WithHandlers", (String)withHandlers.getId());
        MMenuItemTest.assertEquals((int)5, (int)withHandlers.getSize());
        IContributionItem[] withHandlerItems = withHandlers.getItems();
        MMenuItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.commandOne", (String)withHandlerItems[0].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.commandTwo", (String)withHandlerItems[1].getId());
        MMenuItemTest.assertEquals((String)"group1", (String)withHandlerItems[2].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.commandFour", (String)withHandlerItems[3].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.commandThree", (String)withHandlerItems[4].getId());
    }

    public void testMHandledMenuItem_Check_Bug316752() {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        MHandledMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createHandledMenuItem();
        MCommand command = CommandsFactoryImpl.eINSTANCE.createCommand();
        command.setElementId("commandId");
        menuItem.setCommand(command);
        menuItem.setType(ItemType.CHECK);
        menuItem.setSelected(true);
        menu.getChildren().add(menuItem);
        window.setMainMenu(menu);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MenuManager barManager = (MenuManager)((Menu)menu.getWidget()).getData();
        barManager.updateAll(true);
        Object widget1 = menuItem.getWidget();
        MMenuItemTest.assertNotNull((Object)widget1);
        MMenuItemTest.assertTrue((boolean)(widget1 instanceof MenuItem));
        MenuItem menuItemWidget = (MenuItem)widget1;
        MMenuItemTest.assertTrue((boolean)menuItemWidget.getSelection());
    }

    public void testMMenuItem_RadioItems() {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        MDirectMenuItem menuItem1 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        MDirectMenuItem menuItem2 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        menuItem1.setType(ItemType.RADIO);
        menuItem2.setType(ItemType.RADIO);
        menu.getChildren().add(menuItem1);
        menu.getChildren().add(menuItem2);
        window.setMainMenu(menu);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        ((MenuManager)((Widget)menu.getWidget()).getData()).updateAll(true);
        Object widget1 = menuItem1.getWidget();
        MMenuItemTest.assertNotNull((Object)widget1);
        MMenuItemTest.assertTrue((boolean)(widget1 instanceof MenuItem));
        Object widget2 = menuItem2.getWidget();
        MMenuItemTest.assertNotNull((Object)widget2);
        MMenuItemTest.assertTrue((boolean)(widget2 instanceof MenuItem));
        MenuItem menuItemWidget1 = (MenuItem)widget1;
        MenuItem menuItemWidget2 = (MenuItem)widget2;
        menuItemWidget1.setSelection(false);
        menuItemWidget2.setSelection(true);
        menuItemWidget1.notifyListeners(13, new Event());
        menuItemWidget2.notifyListeners(13, new Event());
        MMenuItemTest.assertFalse((boolean)menuItem1.isSelected());
        MMenuItemTest.assertTrue((boolean)menuItem2.isSelected());
        menuItemWidget2.setSelection(false);
        menuItemWidget1.setSelection(true);
        menuItemWidget2.notifyListeners(13, new Event());
        menuItemWidget1.notifyListeners(13, new Event());
        MMenuItemTest.assertTrue((boolean)menuItem1.isSelected());
        MMenuItemTest.assertFalse((boolean)menuItem2.isSelected());
        menuItem1.setSelected(false);
        MMenuItemTest.assertFalse((boolean)menuItemWidget1.getSelection());
        menuItem2.setSelected(true);
        MMenuItemTest.assertTrue((boolean)menuItemWidget2.getSelection());
    }

    private void testMMenuItem_Text(String before, String beforeExpected, String after, String afterExpected) {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        MDirectMenuItem menuItem = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        menuItem.setLabel(before);
        window.setMainMenu(menu);
        menu.getChildren().add(menuItem);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        ((MenuManager)((Widget)menu.getWidget()).getData()).updateAll(true);
        Object widget = menuItem.getWidget();
        MMenuItemTest.assertNotNull((Object)widget);
        MMenuItemTest.assertTrue((boolean)(widget instanceof MenuItem));
        MenuItem menuItemWidget = (MenuItem)widget;
        MMenuItemTest.assertEquals((String)beforeExpected, (String)menuItemWidget.getText());
        menuItem.setLabel(after);
        MMenuItemTest.assertEquals((String)afterExpected, (String)menuItemWidget.getText());
    }

    public void testMMenuItem_Text_EmptyEmpty() {
        this.testMMenuItem_Text("", "", "", "");
    }

    public void testMMenuItem_Text_EmptyNull() {
        this.testMMenuItem_Text("", "", null, "");
    }

    public void testMMenuItem_Text_EmptyString() {
        this.testMMenuItem_Text("", "", "label", "label");
    }

    public void testMMenuItem_Text_NullEmpty() {
        this.testMMenuItem_Text(null, "", "", "");
    }

    public void testMMenuItem_Text_NullNull() {
        this.testMMenuItem_Text(null, "", null, "");
    }

    public void testMMenuItem_Text_NullString() {
        this.testMMenuItem_Text(null, "", "label", "label");
    }

    public void testMMenuItem_Text_StringEmpty() {
        this.testMMenuItem_Text("label", "label", "", "");
    }

    public void testMMenuItem_Text_StringNull() {
        this.testMMenuItem_Text("label", "label", null, "");
    }

    public void testMMenuItem_Text_StringStringChanged() {
        this.testMMenuItem_Text("label", "label", "label2", "label2");
    }

    public void testMMenuItem_Text_StringStringUnchanged() {
        this.testMMenuItem_Text("label", "label", "label", "label");
    }

    public void testSubMenuCreation() throws Exception {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MMenu menuBar = MenuFactoryImpl.eINSTANCE.createMenu();
        menuBar.setElementId("org.eclipse.ui.main.menu");
        window.setMainMenu(menuBar);
        MMenu fileMenu = MenuFactoryImpl.eINSTANCE.createMenu();
        fileMenu.setElementId("file");
        fileMenu.setLabel("File");
        menuBar.getChildren().add(fileMenu);
        MDirectMenuItem item1 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item1.setElementId("item1");
        item1.setLabel("item1");
        fileMenu.getChildren().add(item1);
        MMenuSeparator sep = MenuFactoryImpl.eINSTANCE.createMenuSeparator();
        sep.setElementId("group1");
        fileMenu.getChildren().add(sep);
        MDirectMenuItem item2 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item2.setElementId("item2");
        item2.setLabel("item2");
        fileMenu.getChildren().add(item2);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MenuManagerRenderer renderer = this.getRenderer(this.appContext, (MUIElement)menuBar);
        MenuManager manager = renderer.getManager(menuBar);
        MMenuItemTest.assertNotNull((String)"failed to create menu bar manager", (Object)manager);
        MMenuItemTest.assertEquals((int)1, (int)manager.getSize());
        MenuManager fileManager = (MenuManager)manager.getItems()[0];
        MenuManager fileR = renderer.getManager(fileMenu);
        MMenuItemTest.assertEquals((Object)fileManager, (Object)fileR);
        MMenuItemTest.assertEquals((int)3, (int)fileManager.getSize());
    }

    public void testTbrItem() throws Exception {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MMenu menuBar = MenuFactoryImpl.eINSTANCE.createMenu();
        menuBar.setElementId("org.eclipse.ui.main.menu");
        window.setMainMenu(menuBar);
        MMenu fileMenu = MenuFactoryImpl.eINSTANCE.createMenu();
        fileMenu.setElementId("file");
        fileMenu.setLabel("File");
        menuBar.getChildren().add(fileMenu);
        MDirectMenuItem item1 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item1.setElementId("item1");
        item1.setLabel("item1");
        fileMenu.getChildren().add(item1);
        MMenuSeparator sep = MenuFactoryImpl.eINSTANCE.createMenuSeparator();
        sep.setElementId("group1");
        fileMenu.getChildren().add(sep);
        MDirectMenuItem item2 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item2.setElementId("item2");
        item2.setLabel("item2");
        fileMenu.getChildren().add(item2);
        item2.setToBeRendered(false);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MenuManagerRenderer renderer = this.getRenderer(this.appContext, (MUIElement)menuBar);
        MenuManager manager = renderer.getManager(menuBar);
        MMenuItemTest.assertNotNull((String)"failed to create menu bar manager", (Object)manager);
        MMenuItemTest.assertEquals((int)1, (int)manager.getSize());
        MenuManager fileManager = (MenuManager)manager.getItems()[0];
        MenuManager fileR = renderer.getManager(fileMenu);
        MMenuItemTest.assertEquals((Object)fileManager, (Object)fileR);
        MMenuItemTest.assertEquals((int)2, (int)fileManager.getSize());
    }

    public void TODOtestWithVisible() throws Exception {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MMenu menuBar = MenuFactoryImpl.eINSTANCE.createMenu();
        menuBar.setElementId("org.eclipse.ui.main.menu");
        window.setMainMenu(menuBar);
        MMenu fileMenu = MenuFactoryImpl.eINSTANCE.createMenu();
        fileMenu.setElementId("file");
        fileMenu.setLabel("File");
        menuBar.getChildren().add(fileMenu);
        MDirectMenuItem item1 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item1.setElementId("item1");
        item1.setLabel("item1");
        fileMenu.getChildren().add(item1);
        MMenuSeparator sep = MenuFactoryImpl.eINSTANCE.createMenuSeparator();
        sep.setElementId("group1");
        fileMenu.getChildren().add(sep);
        MDirectMenuItem item2 = MenuFactoryImpl.eINSTANCE.createDirectMenuItem();
        item2.setElementId("item2");
        item2.setLabel("item2");
        fileMenu.getChildren().add(item2);
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        application.getMenuContributions().add(this.createContribution(true));
        this.wb = new E4Workbench((MApplicationElement)window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MenuManagerRenderer renderer = this.getRenderer(this.appContext, (MUIElement)menuBar);
        MenuManager fileManager = renderer.getManager(fileMenu);
        MMenuItemTest.assertNotNull((String)"No file menu?", (Object)fileManager);
        MMenuItemTest.assertEquals((int)4, (int)fileManager.getSize());
        IContributionItem mmcItem = fileManager.getItems()[3];
        MMenuItemTest.assertEquals((String)"mmc.item1", (String)mmcItem.getId());
        MMenuItemTest.assertEquals((String)"before the first show, we have no context to evaluate", (boolean)true, (boolean)mmcItem.isVisible());
        MenuManager manager = renderer.getManager(menuBar);
        manager.updateAll(true);
        Menu fileWidget = fileManager.getMenu();
        MMenuItemTest.assertNotNull((Object)fileWidget);
        Event show = new Event();
        show.widget = fileWidget;
        show.type = 22;
        fileWidget.notifyListeners(22, show);
        Event hide = new Event();
        hide.widget = fileWidget;
        hide.type = 23;
        fileWidget.notifyListeners(23, hide);
        MMenuItemTest.assertEquals((String)"after the first show, it should not be visible", (boolean)false, (boolean)mmcItem.isVisible());
        this.appContext.set("mmc1", (Object)Boolean.TRUE);
        MMenuItemTest.assertEquals((String)"Change should not show up until next show", (boolean)false, (boolean)mmcItem.isVisible());
        fileWidget.notifyListeners(22, show);
        fileWidget.notifyListeners(23, hide);
        MMenuItemTest.assertEquals((boolean)true, (boolean)mmcItem.isVisible());
        this.appContext.remove("mmc1");
        fileWidget.notifyListeners(22, show);
        MMenuItemTest.assertEquals((boolean)false, (boolean)mmcItem.isVisible());
        fileWidget.notifyListeners(23, hide);
    }

    public void XXXXtestActionSetGeneration() throws Exception {
        MApplication application = TestUtil.setupRenderer(this.appContext);
        MenuManagerRenderer renderer = (MenuManagerRenderer)this.appContext.get(MenuManagerRenderer.class);
        MMenu menuBar = ((MWindow)application.getChildren().get(0)).getMainMenu();
        TestUtil.setupActionBuilderStructure(menuBar);
        MenuPersistence mp = new MenuPersistence(application, this.appContext, "org.eclipse.e4.ui.menu.tests.p2");
        mp.reRead();
        Shell shell = new Shell();
        Menu menu = (Menu)renderer.createWidget((MUIElement)menuBar, (Object)shell);
        MMenuItemTest.assertNotNull((Object)menu);
        MMenu obj = menuBar;
        renderer.processContents((MElementContainer)obj);
        MenuManager manager = renderer.getManager(menuBar);
        MMenuItemTest.assertNotNull((Object)manager);
        MMenuItemTest.assertEquals((int)5, (int)manager.getSize());
        MenuManager editManager = (MenuManager)manager.getItems()[1];
        MMenuItemTest.assertEquals((int)5, (int)editManager.getSize());
        IContributionItem[] editItems = editManager.getItems();
        MMenuItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.p2.action4", (String)editItems[4].getId());
        MenuManager actionManager = (MenuManager)manager.getItems()[3];
        MMenuItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.p2.menu1", (String)actionManager.getId());
        MMenuItemTest.assertEquals((int)5, (int)actionManager.getSize());
        IContributionItem[] actionItems = actionManager.getItems();
        MMenuItemTest.assertEquals((String)"group1", (String)actionItems[0].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.p2.action2", (String)actionItems[1].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.p2.action1", (String)actionItems[2].getId());
        MMenuItemTest.assertEquals((String)"group2", (String)actionItems[3].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.e4.ui.menu.tests.p2.action3", (String)actionItems[4].getId());
    }

    public void XXXXtestActionSetSharedBothActive() throws Exception {
        MApplication application = TestUtil.setupRenderer(this.appContext);
        MenuManagerRenderer renderer = (MenuManagerRenderer)this.appContext.get(MenuManagerRenderer.class);
        MWindow window = (MWindow)application.getChildren().get(0);
        MMenu menuBar = window.getMainMenu();
        TestUtil.setupActionBuilderStructure(menuBar);
        MenuPersistence mp = new MenuPersistence(application, this.appContext, "org.eclipse.e4.ui.menu.tests.p3");
        mp.reRead();
        Shell shell = new Shell();
        Menu menu = (Menu)renderer.createWidget((MUIElement)menuBar, (Object)shell);
        MMenuItemTest.assertNotNull((Object)menu);
        MMenu obj = menuBar;
        renderer.processContents((MElementContainer)obj);
        MenuManager manager = renderer.getManager(menuBar);
        MMenuItemTest.assertNotNull((Object)manager);
        MMenuItemTest.assertEquals((int)6, (int)manager.getSize());
        MenuManager editManager = (MenuManager)manager.getItems()[1];
        MMenuItemTest.assertEquals((int)4, (int)editManager.getSize());
        MenuManager searchManager = (MenuManager)manager.getItems()[4];
        MMenuItemTest.assertEquals((String)"org.eclipse.search.menu", (String)searchManager.getId());
        MMenuItemTest.assertFalse((boolean)searchManager.isVisible());
        IEclipseContext windowContext = window.getContext();
        EContextService ecs = (EContextService)windowContext.get(EContextService.class);
        ecs.activateContext(SEARCH_AS_ID);
        ecs.activateContext(PDE_SEARCH_AS_ID);
        MMenuItemTest.assertTrue((boolean)searchManager.isVisible());
        MMenuItemTest.assertEquals((int)10, (int)searchManager.getSize());
        IContributionItem[] searchItems = searchManager.getItems();
        MMenuItemTest.assertEquals((String)"internalDialogGroup", (String)searchItems[0].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.search.OpenSearchDialog", (String)searchItems[1].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.search.OpenFileSearchPage", (String)searchItems[2].getId());
        MMenuItemTest.assertEquals((String)"dialogGroup", (String)searchItems[3].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.pde.ui.actions.OpenPluginSearchPage", (String)searchItems[4].getId());
        MMenuItemTest.assertEquals((String)"fileSearchContextMenuActionsGroup", (String)searchItems[5].getId());
        MMenuItemTest.assertEquals((String)"textSearchSubMenu", (String)searchItems[6].getId());
        MMenuItemTest.assertEquals((String)"contextMenuActionsGroup", (String)searchItems[7].getId());
        MMenuItemTest.assertEquals((String)"occurencesActionsGroup", (String)searchItems[8].getId());
        MMenuItemTest.assertEquals((String)"extraSearchGroup", (String)searchItems[9].getId());
    }

    public void XXXXtestActionSetSharedMenuGeneration() throws Exception {
        MApplication application = TestUtil.setupRenderer(this.appContext);
        MenuManagerRenderer renderer = (MenuManagerRenderer)this.appContext.get(MenuManagerRenderer.class);
        MWindow window = (MWindow)application.getChildren().get(0);
        MMenu menuBar = window.getMainMenu();
        TestUtil.setupActionBuilderStructure(menuBar);
        MenuPersistence mp = new MenuPersistence(application, this.appContext, "org.eclipse.e4.ui.menu.tests.p3");
        mp.reRead();
        Shell shell = new Shell();
        Menu menu = (Menu)renderer.createWidget((MUIElement)menuBar, (Object)shell);
        MMenuItemTest.assertNotNull((Object)menu);
        MMenu obj = menuBar;
        renderer.processContents((MElementContainer)obj);
        MenuManager manager = renderer.getManager(menuBar);
        MMenuItemTest.assertNotNull((Object)manager);
        MMenuItemTest.assertEquals((int)6, (int)manager.getSize());
        MenuManager editManager = (MenuManager)manager.getItems()[1];
        MMenuItemTest.assertEquals((int)4, (int)editManager.getSize());
        MenuManager searchManager = (MenuManager)manager.getItems()[4];
        MMenuItemTest.assertEquals((String)"org.eclipse.search.menu", (String)searchManager.getId());
        MMenuItemTest.assertFalse((boolean)searchManager.isVisible());
        MMenuItemTest.assertEquals((int)10, (int)searchManager.getSize());
        IContributionItem[] searchItems = searchManager.getItems();
        MMenuItemTest.assertEquals((String)"internalDialogGroup", (String)searchItems[0].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.search.OpenSearchDialog", (String)searchItems[1].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.search.OpenFileSearchPage", (String)searchItems[2].getId());
        MMenuItemTest.assertEquals((String)"dialogGroup", (String)searchItems[3].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.pde.ui.actions.OpenPluginSearchPage", (String)searchItems[4].getId());
        MMenuItemTest.assertEquals((String)"fileSearchContextMenuActionsGroup", (String)searchItems[5].getId());
        MMenuItemTest.assertEquals((String)"textSearchSubMenu", (String)searchItems[6].getId());
        MMenuItemTest.assertEquals((String)"contextMenuActionsGroup", (String)searchItems[7].getId());
        MMenuItemTest.assertEquals((String)"occurencesActionsGroup", (String)searchItems[8].getId());
        MMenuItemTest.assertEquals((String)"extraSearchGroup", (String)searchItems[9].getId());
    }

    public void XXXXtestActionSetSharedPDEActive() throws Exception {
        MApplication application = TestUtil.setupRenderer(this.appContext);
        MenuManagerRenderer renderer = (MenuManagerRenderer)this.appContext.get(MenuManagerRenderer.class);
        MWindow window = (MWindow)application.getChildren().get(0);
        MMenu menuBar = window.getMainMenu();
        TestUtil.setupActionBuilderStructure(menuBar);
        MenuPersistence mp = new MenuPersistence(application, this.appContext, "org.eclipse.e4.ui.menu.tests.p3");
        mp.reRead();
        Shell shell = new Shell();
        Menu menu = (Menu)renderer.createWidget((MUIElement)menuBar, (Object)shell);
        MMenuItemTest.assertNotNull((Object)menu);
        MMenu obj = menuBar;
        renderer.processContents((MElementContainer)obj);
        MenuManager manager = renderer.getManager(menuBar);
        MMenuItemTest.assertNotNull((Object)manager);
        MMenuItemTest.assertEquals((int)6, (int)manager.getSize());
        MenuManager editManager = (MenuManager)manager.getItems()[1];
        MMenuItemTest.assertEquals((int)4, (int)editManager.getSize());
        MenuManager searchManager = (MenuManager)manager.getItems()[4];
        MMenuItemTest.assertEquals((String)"org.eclipse.search.menu", (String)searchManager.getId());
        MMenuItemTest.assertFalse((boolean)searchManager.isVisible());
        IEclipseContext windowContext = window.getContext();
        EContextService ecs = (EContextService)windowContext.get(EContextService.class);
        ecs.activateContext(PDE_SEARCH_AS_ID);
        MMenuItemTest.assertTrue((boolean)searchManager.isVisible());
        MMenuItemTest.assertEquals((int)10, (int)searchManager.getSize());
        IContributionItem[] searchItems = searchManager.getItems();
        MMenuItemTest.assertEquals((String)"internalDialogGroup", (String)searchItems[0].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.search.OpenSearchDialog", (String)searchItems[1].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.search.OpenFileSearchPage", (String)searchItems[2].getId());
        MMenuItemTest.assertEquals((String)"dialogGroup", (String)searchItems[3].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.pde.ui.actions.OpenPluginSearchPage", (String)searchItems[4].getId());
        MMenuItemTest.assertEquals((String)"fileSearchContextMenuActionsGroup", (String)searchItems[5].getId());
        MMenuItemTest.assertEquals((String)"textSearchSubMenu", (String)searchItems[6].getId());
        MMenuItemTest.assertEquals((String)"contextMenuActionsGroup", (String)searchItems[7].getId());
        MMenuItemTest.assertEquals((String)"occurencesActionsGroup", (String)searchItems[8].getId());
        MMenuItemTest.assertEquals((String)"extraSearchGroup", (String)searchItems[9].getId());
    }

    public void XXXXtestActionSetSharedSearchActive() throws Exception {
        MApplication application = TestUtil.setupRenderer(this.appContext);
        MenuManagerRenderer renderer = (MenuManagerRenderer)this.appContext.get(MenuManagerRenderer.class);
        MWindow window = (MWindow)application.getChildren().get(0);
        MMenu menuBar = window.getMainMenu();
        TestUtil.setupActionBuilderStructure(menuBar);
        MenuPersistence mp = new MenuPersistence(application, this.appContext, "org.eclipse.e4.ui.menu.tests.p3");
        mp.reRead();
        Shell shell = new Shell();
        Menu menu = (Menu)renderer.createWidget((MUIElement)menuBar, (Object)shell);
        MMenuItemTest.assertNotNull((Object)menu);
        MMenu obj = menuBar;
        renderer.processContents((MElementContainer)obj);
        MenuManager manager = renderer.getManager(menuBar);
        MMenuItemTest.assertNotNull((Object)manager);
        MMenuItemTest.assertEquals((int)6, (int)manager.getSize());
        MenuManager editManager = (MenuManager)manager.getItems()[1];
        MMenuItemTest.assertEquals((int)4, (int)editManager.getSize());
        MenuManager searchManager = (MenuManager)manager.getItems()[4];
        MMenuItemTest.assertEquals((String)"org.eclipse.search.menu", (String)searchManager.getId());
        MMenuItemTest.assertFalse((boolean)searchManager.isVisible());
        IEclipseContext windowContext = window.getContext();
        EContextService ecs = (EContextService)windowContext.get(EContextService.class);
        ecs.activateContext(SEARCH_AS_ID);
        MMenuItemTest.assertTrue((boolean)searchManager.isVisible());
        MMenuItemTest.assertEquals((int)10, (int)searchManager.getSize());
        IContributionItem[] searchItems = searchManager.getItems();
        MMenuItemTest.assertEquals((String)"internalDialogGroup", (String)searchItems[0].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.search.OpenSearchDialog", (String)searchItems[1].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.search.OpenFileSearchPage", (String)searchItems[2].getId());
        MMenuItemTest.assertEquals((String)"dialogGroup", (String)searchItems[3].getId());
        MMenuItemTest.assertEquals((String)"org.eclipse.pde.ui.actions.OpenPluginSearchPage", (String)searchItems[4].getId());
        MMenuItemTest.assertEquals((String)"fileSearchContextMenuActionsGroup", (String)searchItems[5].getId());
        MMenuItemTest.assertEquals((String)"textSearchSubMenu", (String)searchItems[6].getId());
        MMenuItemTest.assertEquals((String)"contextMenuActionsGroup", (String)searchItems[7].getId());
        MMenuItemTest.assertEquals((String)"occurencesActionsGroup", (String)searchItems[8].getId());
        MMenuItemTest.assertEquals((String)"extraSearchGroup", (String)searchItems[9].getId());
    }
}

