/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.widgets.Display;

public class PUtil {
    public static Iterator NULL_ITERATOR = Collections.EMPTY_LIST.iterator();
    public static Enumeration NULL_ENUMERATION = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    };
    public static long DEFAULT_ACTIVITY_STEP_RATE = 20L;
    public static int ACTIVITY_SCHEDULER_FRAME_DELAY = 10;
    public static OutputStream NULL_OUTPUT_STREAM = new OutputStream(){

        public void close() {
        }

        public void flush() {
        }

        public void write(byte[] b) {
        }

        public void write(byte[] b, int off, int len) {
        }

        public void write(int b) {
        }
    };
    private static final int PATH_IS_DONE = -1;

    public static void writeStroke(LineAttributes aStroke, ObjectOutputStream out) throws IOException {
        if (aStroke instanceof Serializable) {
            out.writeBoolean(true);
            out.writeObject(aStroke);
        } else {
            out.writeBoolean(false);
            float[] dash = aStroke.dash;
            if (dash == null) {
                out.write(0);
            } else {
                out.write(dash.length);
                int i = 0;
                while (i < dash.length) {
                    out.writeFloat(dash[i]);
                    ++i;
                }
            }
            out.writeFloat(aStroke.width);
            out.writeInt(aStroke.cap);
            out.writeInt(aStroke.join);
            out.writeInt(aStroke.style);
            out.writeFloat(aStroke.miterLimit);
            out.writeFloat(aStroke.dashOffset);
        }
    }

    public static LineAttributes readStroke(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean serializedStroke = in.readBoolean();
        if (serializedStroke) {
            return (LineAttributes)in.readObject();
        }
        float[] dash = null;
        int dashLength = in.read();
        if (dashLength != 0) {
            dash = new float[dashLength];
            int i = 0;
            while (i < dashLength) {
                dash[i] = in.readFloat();
                ++i;
            }
        }
        float lineWidth = in.readFloat();
        int endCap = in.readInt();
        int lineJoin = in.readInt();
        int style = in.readInt();
        float miterLimit = in.readFloat();
        float dashPhase = in.readFloat();
        return new LineAttributes(lineWidth, endCap, lineJoin, style, dash, dashPhase, miterLimit);
    }

    public static Path readPath(ObjectInputStream in) throws IOException, ClassNotFoundException {
        PathData pathData = new PathData();
        pathData.types = new byte[in.readInt()];
        int i = 0;
        while (i < pathData.types.length) {
            pathData.types[i] = in.readByte();
            ++i;
        }
        pathData.points = new float[in.readInt()];
        i = 0;
        while (i < pathData.points.length) {
            pathData.points[i] = in.readFloat();
            ++i;
        }
        return new Path((Device)Display.getCurrent());
    }

    public static void writePath(Path path, ObjectOutputStream out) throws IOException {
        PathData pathData = path.getPathData();
        out.writeInt(pathData.types.length);
        int i = 0;
        while (i < pathData.types.length) {
            out.writeByte(pathData.types[i]);
            ++i;
        }
        out.writeInt(pathData.points.length);
        i = 0;
        while (i < pathData.points.length) {
            out.writeFloat(pathData.points[i]);
            ++i;
        }
    }
}

