/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.ui;

import org.eclipse.e4.tm.builder.AbstractBuilder;
import org.eclipse.e4.tm.builder.swt.SwtBuilder;
import org.eclipse.e4.tm.ui.ModelContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ModelPartContent
implements ModelContext.Listener {
    private Composite modelComposite;
    private ModelContext modelContext;
    private AbstractBuilder builder;

    public ModelPartContent(Composite modelComposite) {
        this.modelComposite = modelComposite;
    }

    public Composite getModelComposite() {
        return this.modelComposite;
    }

    public void setModelContext(ModelContext modelContext) {
        if (this.modelContext != null) {
            this.modelContext.removeModelContextListener(this);
        }
        this.modelContext = modelContext;
        if (this.modelContext != null) {
            this.modelContext.addModelContextListener(this);
        }
        this.updatePartContent();
    }

    private void updatePartContent() {
        EObject model = this.modelContext.getModel();
        if (model != null) {
            this.updateModel(model, this.modelComposite);
        }
    }

    public void contextChanged(ModelContext context) {
        this.updatePartContent();
    }

    public AbstractBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = new SwtBuilder();
        }
        return this.builder;
    }

    private void updateModel(EObject model, Object parent) {
        this.dispose();
        if (model == null) {
            return;
        }
        this.buildModel(model);
        this.modelComposite.layout();
    }

    protected void buildModel(EObject model) {
        this.getBuilder().build(model, (Object)this.modelComposite);
    }

    public void dispose() {
        if (this.builder != null) {
            this.builder.dispose();
        }
        this.disposeModelControls();
    }

    private void disposeModelControls() {
        if (!this.modelComposite.isDisposed()) {
            Control[] children = this.modelComposite.getChildren();
            int i = 0;
            while (i < children.length) {
                if (!children[i].isDisposed()) {
                    children[i].dispose();
                }
                ++i;
            }
        }
    }
}

