/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.e4.ui.css.core.dom.ElementAdapter;
import org.eclipse.e4.ui.css.core.dom.IElementProvider;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.engine.CSSEngineImpl;
import org.eclipse.e4.ui.tests.css.core.util.TestElement;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CSSEngineTest
extends TestCase {
    public void testBug363053() {
        TestCSSEngine engine = new TestCSSEngine();
        engine.setWidgetProvider(AbstractCollection.class, new IElementProvider(){

            public Element getElement(Object element, CSSEngine engine) {
                return new CollectionElement((Collection)element, engine);
            }
        });
        engine.setWidgetProvider(AbstractSet.class, new IElementProvider(){

            public Element getElement(Object element, CSSEngine engine) {
                return new SetElement((Set)element, engine);
            }
        });
        Element element = engine.getElement(new ArrayList());
        CSSEngineTest.assertTrue((boolean)(element instanceof CollectionElement));
        element = engine.getElement(new HashSet());
        CSSEngineTest.assertTrue((boolean)(element instanceof SetElement));
    }

    public void testSelectorMatch() throws Exception {
        TestCSSEngine engine = new TestCSSEngine();
        SelectorList list = engine.parseSelectors("Date");
        engine.setElementProvider(new IElementProvider(){

            public Element getElement(Object element, CSSEngine engine) {
                return new TestElement(element.getClass().getSimpleName(), engine);
            }
        });
        CSSEngineTest.assertFalse((boolean)engine.matches(list.item(0), new Object(), null));
        CSSEngineTest.assertTrue((boolean)engine.matches(list.item(0), new Date(), null));
    }

    public static abstract class BaseElement
    extends ElementAdapter {
        public BaseElement(Object object, CSSEngine engine) {
            super(object, engine);
        }

        public Node getParentNode() {
            return null;
        }

        public NodeList getChildNodes() {
            return null;
        }

        public String getNamespaceURI() {
            return null;
        }

        public String getCSSId() {
            return null;
        }

        public String getCSSClass() {
            return null;
        }

        public String getCSSStyle() {
            return null;
        }

        public String getLocalName() {
            return null;
        }

        public String getAttribute(String arg0) {
            return null;
        }
    }

    public static class CollectionElement
    extends BaseElement {
        public CollectionElement(Collection control, CSSEngine engine) {
            super(control, engine);
        }
    }

    public static class SetElement
    extends BaseElement {
        public SetElement(Set object, CSSEngine engine) {
            super(object, engine);
        }
    }

    private static class TestCSSEngine
    extends CSSEngineImpl {
        private TestCSSEngine() {
        }

        public void setWidgetProvider(Class clazz, IElementProvider provider) {
            this.widgetsMap.put(clazz.getName(), provider);
        }

        public void reapply() {
        }
    }
}

