/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ObservableSetContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableSetTreeContentProvider;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewerSupport {
    public static <E> void bind(StructuredViewer viewer, IObservableList<E> input, IValueProperty<? super E, ?> labelProperty) {
        ArrayList singletonList = new ArrayList();
        singletonList.add(labelProperty);
        ViewerSupport.bind(viewer, input, singletonList);
    }

    public static <E> void bind(StructuredViewer viewer, IObservableList<?> input, IValueProperty[] labelProperties) {
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        if (viewer.getInput() != null) {
            viewer.setInput(null);
        }
        viewer.setContentProvider(contentProvider);
        viewer.setLabelProvider(new ObservableMapLabelProvider(Properties.observeEach(contentProvider.getKnownElements(), (IValueProperty[])labelProperties)));
        if (input != null) {
            viewer.setInput(input);
        }
    }

    public static <E> void bind(StructuredViewer viewer, IObservableList<E> input, List<IValueProperty<? super E, ?>> labelProperties) {
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        if (viewer.getInput() != null) {
            viewer.setInput(null);
        }
        viewer.setContentProvider(contentProvider);
        viewer.setLabelProvider(new ObservableMapLabelProvider(Properties.observeEach(contentProvider.getKnownElements(), labelProperties)));
        if (input != null) {
            viewer.setInput(input);
        }
    }

    public static <E> void bind(StructuredViewer viewer, IObservableSet<E> input, IValueProperty<? super E, ?> labelProperty) {
        ArrayList singletonList = new ArrayList();
        singletonList.add(labelProperty);
        ViewerSupport.bind(viewer, input, singletonList);
    }

    public static <E> void bind(StructuredViewer viewer, IObservableSet<E> input, IValueProperty[] labelProperties) {
        ObservableSetContentProvider contentProvider = new ObservableSetContentProvider();
        if (viewer.getInput() != null) {
            viewer.setInput(null);
        }
        viewer.setContentProvider(contentProvider);
        viewer.setLabelProvider(new ObservableMapLabelProvider(Properties.observeEach(contentProvider.getKnownElements(), (IValueProperty[])labelProperties)));
        if (input != null) {
            viewer.setInput(input);
        }
    }

    public static <E> void bind(StructuredViewer viewer, IObservableSet<E> input, List<IValueProperty<? super E, ?>> labelProperties) {
        ObservableSetContentProvider contentProvider = new ObservableSetContentProvider();
        if (viewer.getInput() != null) {
            viewer.setInput(null);
        }
        viewer.setContentProvider(contentProvider);
        viewer.setLabelProvider(new ObservableMapLabelProvider(Properties.observeEach(contentProvider.getKnownElements(), labelProperties)));
        if (input != null) {
            viewer.setInput(input);
        }
    }

    public static <E> void bind(AbstractTreeViewer viewer, Object input, IListProperty<?, E> childrenProperty, IValueProperty<? super E, ?> labelProperty) {
        ArrayList singletonList = new ArrayList();
        singletonList.add(labelProperty);
        ViewerSupport.bind(viewer, input, childrenProperty, singletonList);
    }

    public static <E> void bind(AbstractTreeViewer viewer, Object input, IListProperty<?, E> childrenProperty, IValueProperty[] labelProperties) {
        Realm realm = SWTObservables.getRealm(viewer.getControl().getDisplay());
        IObservableFactory listFactory = childrenProperty.listFactory(realm);
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider(listFactory, null);
        if (viewer.getInput() != null) {
            viewer.setInput(null);
        }
        viewer.setContentProvider(contentProvider);
        viewer.setLabelProvider(new ObservableMapLabelProvider(Properties.observeEach(contentProvider.getKnownElements(), (IValueProperty[])labelProperties)));
        if (input != null) {
            viewer.setInput(input);
        }
    }

    public static <E> void bind(AbstractTreeViewer viewer, Object input, IListProperty<?, E> childrenProperty, List<IValueProperty<? super E, ?>> labelProperties) {
        Realm realm = SWTObservables.getRealm(viewer.getControl().getDisplay());
        IObservableFactory listFactory = childrenProperty.listFactory(realm);
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider(listFactory, null);
        if (viewer.getInput() != null) {
            viewer.setInput(null);
        }
        viewer.setContentProvider(contentProvider);
        viewer.setLabelProvider(new ObservableMapLabelProvider(Properties.observeEach(contentProvider.getKnownElements(), labelProperties)));
        if (input != null) {
            viewer.setInput(input);
        }
    }

    public static <E> void bind(AbstractTreeViewer viewer, Object input, ISetProperty<?, E> childrenProperty, IValueProperty<? super E, ?> labelProperty) {
        ArrayList singletonList = new ArrayList();
        singletonList.add(labelProperty);
        ViewerSupport.bind(viewer, input, childrenProperty, singletonList);
    }

    public static <E> void bind(AbstractTreeViewer viewer, Object input, ISetProperty<?, E> childrenProperty, IValueProperty[] labelProperties) {
        Realm realm = SWTObservables.getRealm(viewer.getControl().getDisplay());
        IObservableFactory setFactory = childrenProperty.setFactory(realm);
        ObservableSetTreeContentProvider contentProvider = new ObservableSetTreeContentProvider(setFactory, null);
        if (viewer.getInput() != null) {
            viewer.setInput(null);
        }
        viewer.setContentProvider(contentProvider);
        viewer.setLabelProvider(new ObservableMapLabelProvider(Properties.observeEach(contentProvider.getKnownElements(), (IValueProperty[])labelProperties)));
        if (input != null) {
            viewer.setInput(input);
        }
    }

    public static <E> void bind(AbstractTreeViewer viewer, Object input, ISetProperty<?, E> childrenProperty, List<IValueProperty<? super E, ?>> labelProperties) {
        Realm realm = SWTObservables.getRealm(viewer.getControl().getDisplay());
        IObservableFactory setFactory = childrenProperty.setFactory(realm);
        ObservableSetTreeContentProvider contentProvider = new ObservableSetTreeContentProvider(setFactory, null);
        if (viewer.getInput() != null) {
            viewer.setInput(null);
        }
        viewer.setContentProvider(contentProvider);
        viewer.setLabelProvider(new ObservableMapLabelProvider(Properties.observeEach(contentProvider.getKnownElements(), labelProperties)));
        if (input != null) {
            viewer.setInput(input);
        }
    }
}

