/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.common;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;

public class ContributionURIValidator
implements IValidator {
    private static final String PLUGIN_ID = "org.eclipse.e4.tools.emf.ui";

    public IStatus validate(Object value) {
        if (value == null) {
            return new Status(4, PLUGIN_ID, "The URI must not be empty!");
        }
        if (!value.toString().startsWith("bundleclass:")) {
            return new Status(4, PLUGIN_ID, "The URI has to start with 'platform:/plugin'");
        }
        try {
            URI uri = URI.createURI((String)value.toString());
            if (uri.authority() == null || uri.authority().length() == 0 || uri.segmentCount() != 1) {
                return new Status(4, PLUGIN_ID, "The uri has to have the format 'bundleclass://$$bundleId$$/$$className$$'");
            }
        }
        catch (Exception e) {
            return new Status(4, PLUGIN_ID, e.getMessage());
        }
        return Status.OK_STATUS;
    }
}

