/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class BundleImageCache {
    private Display display;
    private ClassLoader classloader;
    ArrayList<Image> images;
    private static Image imgPlaceholder;
    private IEclipseContext context;

    public BundleImageCache(Display display, ClassLoader classloader) {
        this(display, classloader, null);
    }

    public BundleImageCache(Display display, ClassLoader classloader, IEclipseContext context) {
        this.display = display;
        this.classloader = classloader;
        this.context = context;
        this.images = new ArrayList();
    }

    public Image create(String path) {
        Image img;
        try {
            img = new Image((Device)this.display, this.classloader.getResourceAsStream(path));
            this.images.add(img);
        }
        catch (Exception e) {
            e.printStackTrace();
            img = this.getPlaceholder();
        }
        return img;
    }

    public Image loadFromKey(String key) {
        Image ret = null;
        try {
            ret = ((IResourcePool)this.context.get(IResourcePool.class)).getImageUnchecked(key);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (ret == null) {
            ret = this.getPlaceholder();
        }
        return ret;
    }

    protected Image getPlaceholder() {
        if (imgPlaceholder == null) {
            imgPlaceholder = new Image((Device)Display.getDefault(), this.classloader.getResourceAsStream("/icons/full/obj16/missing_image_placeholder.png"));
        }
        return imgPlaceholder;
    }

    protected void finalize() throws Throwable {
        if (imgPlaceholder != null && !imgPlaceholder.isDisposed()) {
            imgPlaceholder.dispose();
        }
    }

    public void dispose() {
        Iterator<Image> it = this.images.iterator();
        while (it.hasNext()) {
            Image image = it.next();
            if (!image.isDisposed()) {
                image.dispose();
            }
            it.remove();
        }
    }

    public Image create(String bundleId, String path) {
        Image img;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        try {
            img = new Image((Device)this.display, new URL("platform:/plugin/" + bundleId + path).openStream());
            this.images.add(img);
        }
        catch (Exception e) {
            e.printStackTrace();
            img = this.getPlaceholder();
        }
        return img;
    }
}

