/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import java.util.Comparator;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class MethodsSourcePositionComparator
implements Comparator {
    private final ITypeBinding fTypeBinding;

    public MethodsSourcePositionComparator(ITypeBinding typeBinding) {
        if (typeBinding == null) {
            throw new IllegalArgumentException();
        }
        this.fTypeBinding = typeBinding;
    }

    public int compare(Object o1, Object o2) {
        ITypeBinding secondMethodType;
        if (!(o1 instanceof IMethodBinding)) {
            return 0;
        }
        if (!(o2 instanceof IMethodBinding)) {
            return 0;
        }
        IMethodBinding firstMethodBinding = (IMethodBinding)o1;
        IMethodBinding secondMethodBinding = (IMethodBinding)o2;
        ITypeBinding firstMethodType = firstMethodBinding.getDeclaringClass();
        if (firstMethodType.equals((Object)(secondMethodType = secondMethodBinding.getDeclaringClass()))) {
            return this.compareInTheSameType(firstMethodBinding, secondMethodBinding);
        }
        if (firstMethodType.equals((Object)this.fTypeBinding)) {
            return 1;
        }
        if (secondMethodType.equals((Object)this.fTypeBinding)) {
            return -1;
        }
        ITypeBinding type = this.fTypeBinding;
        int count = 0;
        int firstCount = -1;
        int secondCount = -1;
        while ((type = type.getSuperclass()) != null) {
            if (firstMethodType.equals((Object)type)) {
                firstCount = count;
            }
            if (secondMethodType.equals((Object)type)) {
                secondCount = count;
            }
            ++count;
        }
        if (firstCount != -1 && secondCount != -1) {
            return firstCount - secondCount;
        }
        if (firstCount != -1 && secondCount == -1) {
            return 1;
        }
        if (firstCount == -1 && secondCount != -1) {
            return -1;
        }
        ITypeBinding[] interfaces = this.fTypeBinding.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (firstMethodType.equals((Object)interfaces[i])) {
                return 1;
            }
            if (secondMethodType.equals((Object)interfaces[i])) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    private int compareInTheSameType(IMethodBinding firstMethodBinding, IMethodBinding secondMethodBinding) {
        IMethod secondMethod;
        IMethod firstMethod;
        block4: {
            try {
                firstMethod = (IMethod)firstMethodBinding.getJavaElement();
                secondMethod = (IMethod)secondMethodBinding.getJavaElement();
                if (firstMethod != null && secondMethod != null) break block4;
                return 0;
            }
            catch (JavaModelException javaModelException) {
                return 0;
            }
        }
        ISourceRange firstSourceRange = firstMethod.getSourceRange();
        ISourceRange secondSourceRange = secondMethod.getSourceRange();
        if (!SourceRange.isAvailable((ISourceRange)firstSourceRange) || !SourceRange.isAvailable((ISourceRange)secondSourceRange)) {
            return firstMethod.getElementName().compareTo(secondMethod.getElementName());
        }
        return firstSourceRange.getOffset() - secondSourceRange.getOffset();
    }
}

