/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class LineComparator
implements IRangeComparator {
    private final IDocument fDocument;
    private final ArrayList fHashes;

    public LineComparator(IDocument document) {
        this.fDocument = document;
        Object[] nulls = new Object[this.fDocument.getNumberOfLines()];
        this.fHashes = new ArrayList<Object>(Arrays.asList(nulls));
    }

    public int getRangeCount() {
        return this.fDocument.getNumberOfLines();
    }

    public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
        try {
            return this.getHash(thisIndex).equals(((LineComparator)other).getHash(otherIndex));
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
            return false;
        }
    }

    public boolean skipRangeComparison(int length, int maxLength, IRangeComparator other) {
        return false;
    }

    private Integer getHash(int line) throws BadLocationException {
        Integer hash = (Integer)this.fHashes.get(line);
        if (hash == null) {
            IRegion lineRegion = this.fDocument.getLineInformation(line);
            String lineContents = this.fDocument.get(lineRegion.getOffset(), lineRegion.getLength());
            hash = new Integer(this.computeDJBHash(lineContents));
            this.fHashes.set(line, hash);
        }
        return hash;
    }

    private int computeDJBHash(String string) {
        int hash = 5381;
        int len = string.length();
        int i = 0;
        while (i < len) {
            char ch = string.charAt(i);
            hash = (hash << 5) + hash + ch;
            ++i;
        }
        return hash;
    }
}

