/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TableDragSourceEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDragSourceEffect;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.EventRecord;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DragSourceEffect dragEffect;
    static final String DEFAULT_DRAG_SOURCE_EFFECT = "DEFAULT_DRAG_SOURCE_EFFECT";
    static Callback DragSendDataProc;
    static /* synthetic */ Class class$0;

    static {
        int dragSendDataProcAddress;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((dragSendDataProcAddress = (DragSendDataProc = new Callback(clazz, "DragSendDataProc", 4)).getAddress()) == 0) {
            SWT.error(3);
        }
    }

    public DragSource(Control control, int style) {
        super(control, DragSource.checkStyle(style));
        this.control = control;
        if (control.getData("DragSource") != null) {
            DND.error(2000);
        }
        control.setData("DragSource", this);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 12 && !DragSource.this.isDisposed()) {
                    DragSource.this.dispose();
                }
                if (event.type == 29 && !DragSource.this.isDisposed()) {
                    DragSource.this.drag(event);
                }
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                DragSource.this.onDispose();
            }
        });
        Object effect = control.getData(DEFAULT_DRAG_SOURCE_EFFECT);
        if (effect instanceof DragSourceEffect) {
            this.dragEffect = (DragSourceEffect)effect;
        } else if (control instanceof Tree) {
            this.dragEffect = new TreeDragSourceEffect((Tree)control);
        } else if (control instanceof Table) {
            this.dragEffect = new TableDragSourceEffect((Table)control);
        }
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    static int DragSendDataProc(int theType, int dragSendRefCon, int theItemRef, int theDrag) {
        DragSource source = DragSource.FindDragSource(dragSendRefCon, theDrag);
        if (source == null) {
            return -1854;
        }
        return source.dragSendDataProc(theType, dragSendRefCon, theItemRef, theDrag);
    }

    static DragSource FindDragSource(int dragSendRefCon, int theDrag) {
        if (dragSendRefCon == 0) {
            return null;
        }
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(dragSendRefCon);
        if (widget == null) {
            return null;
        }
        return (DragSource)widget.getData("DragSource");
    }

    public void addDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        typedListener.dndWidget = this;
        this.addListener(2008, typedListener);
        this.addListener(2001, typedListener);
        this.addListener(2000, typedListener);
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            DND.error(43);
        }
    }

    void drag(Event dragEvent) {
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.x = dragEvent.x;
        event.y = dragEvent.y;
        event.time = dragEvent.time;
        event.doit = true;
        this.notifyListeners(2008, event);
        if (!event.doit || this.transferAgents == null || this.transferAgents.length == 0) {
            return;
        }
        int[] theDrag = new int[1];
        if (OS.NewDrag(theDrag) != 0) {
            event = new DNDEvent();
            event.widget = this;
            event.time = (int)System.currentTimeMillis();
            event.doit = false;
            event.detail = 0;
            this.notifyListeners(2000, event);
            return;
        }
        Point pt = new Point();
        OS.GetGlobalMouse(pt);
        int i = 0;
        while (i < this.transferAgents.length) {
            Transfer transfer = this.transferAgents[i];
            if (transfer != null) {
                int[] types = transfer.getTypeIds();
                int j = 0;
                while (j < types.length) {
                    OS.AddDragItemFlavor(theDrag[0], 1, types[j], null, 0, 0);
                    ++j;
                }
            }
            ++i;
        }
        OS.SetDragSendProc(theDrag[0], DragSendDataProc.getAddress(), this.control.handle);
        int theRegion = 0;
        Resource newImage = null;
        try {
            theRegion = OS.NewRgn();
            OS.SetRectRgn(theRegion, pt.h, pt.v, (short)(pt.h + 20), (short)(pt.v + 20));
            int operations = this.opToOsOp(this.getStyle());
            OS.SetDragAllowableActions(theDrag[0], operations, true);
            OS.SetDragAllowableActions(theDrag[0], operations, false);
            Resource image = event.image;
            if (image != null) {
                CGPoint imageOffsetPt = new CGPoint();
                imageOffsetPt.x = 0.0f;
                imageOffsetPt.y = 0.0f;
                if (OS.CGImageGetAlphaInfo(image.handle) == 6) {
                    ImageData data = image.getImageData();
                    data.alpha = 255;
                    newImage = new Image(image.getDevice(), data);
                    image = newImage;
                }
                OS.SetDragImageWithCGImage(theDrag[0], image.handle, imageOffsetPt, 0);
            }
            EventRecord theEvent = new EventRecord();
            theEvent.message = 5;
            theEvent.modifiers = (short)OS.GetCurrentEventKeyModifiers();
            theEvent.what = (short)15;
            theEvent.where_h = pt.h;
            theEvent.where_v = pt.v;
            int result = OS.TrackDrag(theDrag[0], theEvent, theRegion);
            int operation = 0;
            if (result == 0) {
                int[] outAction = new int[1];
                OS.GetDragDropAction(theDrag[0], outAction);
                operation = this.osOpToOp(outAction[0]);
            }
            event = new DNDEvent();
            event.widget = this;
            event.time = (int)System.currentTimeMillis();
            event.doit = result == 0;
            event.detail = operation;
            this.notifyListeners(2000, event);
        }
        finally {
            if (theRegion != 0) {
                OS.DisposeRgn(theRegion);
            }
            if (newImage != null) {
                newImage.dispose();
            }
        }
        OS.DisposeDrag(theDrag[0]);
    }

    int dragSendDataProc(int theType, int dragSendRefCon, int theItemRef, int theDrag) {
        if (theType == 0) {
            return -1852;
        }
        TransferData transferData = new TransferData();
        transferData.type = theType;
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = (int)System.currentTimeMillis();
        event.dataType = transferData;
        this.notifyListeners(2001, event);
        if (!event.doit) {
            return -1857;
        }
        Transfer transfer = null;
        int i = 0;
        while (i < this.transferAgents.length) {
            Transfer transferAgent = this.transferAgents[i];
            if (transferAgent != null && transferAgent.isSupportedType(transferData)) {
                transfer = transferAgent;
                break;
            }
            ++i;
        }
        if (transfer == null) {
            return -1852;
        }
        transfer.javaToNative(event.data, transferData);
        if (transferData.result != 0) {
            return transferData.result;
        }
        byte[] datum = transferData.data[0];
        if (datum == null) {
            return -1854;
        }
        int rc = OS.SetDragItemFlavorData(theDrag, theItemRef, theType, datum, datum.length, 0);
        if (rc == 0 && transfer instanceof FileTransfer) {
            int i2 = 1;
            while (i2 < transferData.data.length) {
                datum = transferData.data[i2];
                if (datum == null) {
                    return -1854;
                }
                rc = OS.AddDragItemFlavor(theDrag, 1 + i2, theType, datum, datum.length, 0);
                if (rc != 0) break;
                ++i2;
            }
        }
        return rc;
    }

    public Control getControl() {
        return this.control;
    }

    public DragSourceListener[] getDragListeners() {
        Listener[] listeners = this.getListeners(2008);
        int length = listeners.length;
        DragSourceListener[] dragListeners = new DragSourceListener[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            Listener listener = listeners[i];
            if (listener instanceof DNDListener) {
                dragListeners[count] = (DragSourceListener)((DNDListener)listener).getEventListener();
                ++count;
            }
            ++i;
        }
        if (count == length) {
            return dragListeners;
        }
        DragSourceListener[] result = new DragSourceListener[count];
        System.arraycopy(dragListeners, 0, result, 0, count);
        return result;
    }

    public DragSourceEffect getDragSourceEffect() {
        return this.dragEffect;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DragSource", null);
        this.control = null;
        this.transferAgents = null;
    }

    int opToOsOp(int operation) {
        int osOperation = 0;
        if ((operation & 1) != 0) {
            osOperation |= 1;
        }
        if ((operation & 4) != 0) {
            osOperation |= 2;
        }
        if ((operation & 2) != 0) {
            osOperation |= 0x10;
        }
        if ((operation & 8) != 0) {
            osOperation |= 0x20;
        }
        return osOperation;
    }

    int osOpToOp(int osOperation) {
        int operation = 0;
        if ((osOperation & 1) != 0) {
            operation |= 1;
        }
        if ((osOperation & 2) != 0) {
            operation |= 4;
        }
        if ((osOperation & 0x20) != 0) {
            operation |= 8;
        }
        if ((osOperation & 0x10) != 0) {
            operation |= 2;
        }
        if (osOperation == -1) {
            operation = 7;
        }
        return operation;
    }

    public void removeDragListener(DragSourceListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeListener(2008, listener);
        this.removeListener(2001, listener);
        this.removeListener(2000, listener);
    }

    public void setDragSourceEffect(DragSourceEffect effect) {
        this.dragEffect = effect;
    }

    public void setTransfer(Transfer[] transferAgents) {
        this.transferAgents = transferAgents;
    }
}

