/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Link
extends Control {
    String text;
    TextLayout layout;
    Color linkColor;
    Color disabledColor;
    Point[] offsets;
    Point selection;
    String[] ids;
    int[] mnemonics;
    int focusIndex;
    static final RGB LINK_FOREGROUND = new RGB(0, 51, 153);
    static final RGB LINK_DISABLED_FOREGROUND = new RGB(172, 168, 153);
    static final String[] AX_ATTRIBUTES = new String[]{"AXTitle"};

    public Link(Composite parent, int style) {
        super(parent, style);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callFocusEventHandler(int nextHandler, int theEvent) {
        return 0;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int height;
        int width;
        Rectangle rect;
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int layoutWidth = this.layout.getWidth();
        if (wHint == 0) {
            this.layout.setWidth(1);
            rect = this.layout.getBounds();
            width = 0;
            height = rect.height;
        } else {
            this.layout.setWidth(wHint);
            rect = this.layout.getBounds();
            width = rect.width;
            height = rect.height;
        }
        this.layout.setWidth(layoutWidth);
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    void createHandle() {
        this.state |= 0x820;
        int features = 4;
        int[] outControl = new int[1];
        int window = OS.GetControlOwner(this.parent.handle);
        OS.CreateUserPaneControl(window, null, features, outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
        this.layout = new TextLayout(this.display);
        this.linkColor = new Color(this.display, LINK_FOREGROUND);
        this.disabledColor = new Color(this.display, LINK_DISABLED_FOREGROUND);
        this.offsets = new Point[0];
        this.ids = new String[0];
        this.mnemonics = new int[0];
        this.selection = new Point(-1, -1);
        this.focusIndex = -1;
    }

    void createWidget() {
        super.createWidget();
        this.layout.setFont(this.getFont());
        this.text = "";
    }

    void drawBackground(int control, int context) {
        this.fillBackground(control, context, null);
        if (!this.hasFocus() || this.focusIndex == -1) {
            return;
        }
        int[] outMetric = new int[1];
        OS.GetThemeMetric(7, outMetric);
        outMetric[0] = outMetric[0] - 1;
        Rect r = new Rect();
        Rectangle[] rects = this.getRectangles(this.focusIndex);
        int i = 0;
        while (i < rects.length) {
            Rectangle rect = rects[i];
            r.left = (short)(rect.x + outMetric[0]);
            r.top = (short)(rect.y + outMetric[0]);
            r.right = (short)(r.left + rect.width - outMetric[0] * 2);
            r.bottom = (short)(r.top + rect.height - outMetric[0] * 2);
            OS.DrawThemeFocusRect(r, true);
            ++i;
        }
    }

    void drawWidget(int control, int context, int damageRgn, int visibleRgn, int theEvent) {
        GCData data = new GCData();
        data.paintEvent = theEvent;
        data.visibleRgn = visibleRgn;
        GC gc = GC.carbon_new(this, data);
        int selStart = this.selection.x;
        int selEnd = this.selection.y;
        if (selStart > selEnd) {
            selStart = this.selection.y;
            selEnd = this.selection.x;
        }
        selEnd = -1;
        selStart = -1;
        if ((this.state & 8) != 0) {
            gc.setForeground(this.disabledColor);
        }
        this.layout.draw(gc, 0, 0, selStart, selEnd, null, null);
        gc.dispose();
        super.drawWidget(control, context, damageRgn, visibleRgn, theEvent);
    }

    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        TextStyle linkStyle = new TextStyle(null, enabled ? this.linkColor : this.disabledColor, null);
        linkStyle.underline = true;
        int i = 0;
        while (i < this.offsets.length) {
            Point point = this.offsets[i];
            this.layout.setStyle(linkStyle, point.x, point.y);
            ++i;
        }
        this.redraw();
    }

    String[] getAxAttributes() {
        return AX_ATTRIBUTES;
    }

    String getNameText() {
        return this.getText();
    }

    Rectangle[] getRectangles(int linkIndex) {
        int lineCount = this.layout.getLineCount();
        Rectangle[] rects = new Rectangle[lineCount];
        int[] lineOffsets = this.layout.getLineOffsets();
        Point point = this.offsets[linkIndex];
        int lineStart = 1;
        while (point.x > lineOffsets[lineStart]) {
            ++lineStart;
        }
        int lineEnd = 1;
        while (point.y > lineOffsets[lineEnd]) {
            ++lineEnd;
        }
        int index = 0;
        if (lineStart == lineEnd) {
            rects[index++] = this.layout.getBounds(point.x, point.y);
        } else {
            rects[index++] = this.layout.getBounds(point.x, lineOffsets[lineStart] - 1);
            rects[index++] = this.layout.getBounds(lineOffsets[lineEnd - 1], point.y);
            if (lineEnd - lineStart > 1) {
                int i = lineStart;
                while (i < lineEnd - 1) {
                    rects[index++] = this.layout.getLineBounds(i);
                    ++i;
                }
            }
        }
        if (rects.length != index) {
            Rectangle[] tmp = new Rectangle[index];
            System.arraycopy(rects, 0, tmp, 0, index);
            rects = tmp;
        }
        return rects;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    int kEventAccessibleGetNamedAttribute(int nextHandler, int theEvent, int userData) {
        String text;
        int code = -9874;
        int[] stringRef = new int[1];
        OS.GetEventParameter(theEvent, 1635020397, 1667658612, null, 4, null, stringRef);
        int length = 0;
        if (stringRef[0] != 0) {
            length = OS.CFStringGetLength(stringRef[0]);
        }
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(stringRef[0], range, buffer);
        String attributeName = new String(buffer);
        if (attributeName.equals("AXRole") || attributeName.equals("AXRoleDescription")) {
            String roleText = "AXLink";
            buffer = new char[roleText.length()];
            roleText.getChars(0, buffer.length, buffer, 0);
            stringRef[0] = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
            if (stringRef[0] != 0) {
                if (attributeName.equals("AXRole")) {
                    OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, stringRef);
                } else {
                    int stringRef2 = OS.HICopyAccessibilityRoleDescription(stringRef[0], 0);
                    OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, new int[]{stringRef2});
                    OS.CFRelease(stringRef2);
                }
                OS.CFRelease(stringRef[0]);
                code = 0;
            }
        } else if ((attributeName.equals("AXTitle") || attributeName.equals("AXDescription")) && (text = this.parse(this.getText())) != null) {
            buffer = new char[text.length()];
            text.getChars(0, buffer.length, buffer, 0);
            stringRef[0] = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
            if (stringRef[0] != 0) {
                OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, stringRef);
                OS.CFRelease(stringRef[0]);
                code = 0;
            }
        }
        if (this.accessible != null) {
            code = this.accessible.internal_kEventAccessibleGetNamedAttribute(nextHandler, theEvent, code);
        }
        return code;
    }

    int kEventControlGetFocusPart(int nextHandler, int theEvent, int userData) {
        return 0;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlSetFocusPart(nextHandler, theEvent, userData);
        if (result == 0) {
            this.redraw();
        }
        return result;
    }

    int kEventMouseMoved(int nextHandler, int theEvent, int userData) {
        int result = super.kEventMouseMoved(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        CGPoint pt = new CGPoint();
        OS.GetEventParameter(theEvent, 2003660661, 1751740532, null, 8, null, pt);
        OS.HIViewConvertPoint(pt, 0, this.handle);
        int x = (int)pt.x;
        int y = (int)pt.y;
        int j = 0;
        while (j < this.offsets.length) {
            Rectangle[] rects = this.getRectangles(j);
            int i = 0;
            while (i < rects.length) {
                Rectangle rectangle = rects[i];
                if (rectangle.contains(x, y)) {
                    this.setCursor(this.display.getSystemCursor(21));
                    return result;
                }
                ++i;
            }
            ++j;
        }
        this.setCursor(null);
        return result;
    }

    int kEventUnicodeKeyPressed(int nextHandler, int theEvent, int userData) {
        int result = super.kEventUnicodeKeyPressed(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if (this.focusIndex == -1) {
            return result;
        }
        int[] keyboardEvent = new int[1];
        OS.GetEventParameter(theEvent, 1953721189, 1702261350, null, keyboardEvent.length * 4, null, keyboardEvent);
        int[] keyCode = new int[1];
        OS.GetEventParameter(keyboardEvent[0], 1801678692, 1835100014, null, keyCode.length * 4, null, keyCode);
        switch (keyCode[0]) {
            case 36: 
            case 49: 
            case 76: {
                Event event = new Event();
                event.text = this.ids[this.focusIndex];
                this.sendSelectionEvent(13, event, true);
                break;
            }
            case 48: {
                boolean next;
                int[] modifiers = new int[1];
                OS.GetEventParameter(keyboardEvent[0], 1802334052, 1835100014, null, 4, null, modifiers);
                boolean bl = next = (modifiers[0] & 0x200) == 0;
                if (next) {
                    if (this.focusIndex >= this.offsets.length - 1) break;
                    ++this.focusIndex;
                    this.redraw();
                    break;
                }
                if (this.focusIndex <= 0) break;
                --this.focusIndex;
                this.redraw();
            }
        }
        return result;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.layout != null) {
            this.layout.dispose();
        }
        this.layout = null;
        if (this.linkColor != null) {
            this.linkColor.dispose();
        }
        this.linkColor = null;
        if (this.disabledColor != null) {
            this.disabledColor.dispose();
        }
        this.disabledColor = null;
        this.offsets = null;
        this.ids = null;
        this.mnemonics = null;
        this.text = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    String parse(String string) {
        int length = string.length();
        this.offsets = new Point[length / 4];
        this.ids = new String[length / 4];
        this.mnemonics = new int[length / 4 + 1];
        StringBuffer result = new StringBuffer();
        char[] buffer = new char[length];
        string.getChars(0, string.length(), buffer, 0);
        int index = 0;
        int state = 0;
        int linkIndex = 0;
        int start = 0;
        int tagStart = 0;
        int linkStart = 0;
        int endtagStart = 0;
        int refStart = 0;
        while (index < length) {
            char c = Character.toLowerCase(buffer[index]);
            block0 : switch (state) {
                case 0: {
                    if (c != '<') break;
                    tagStart = index;
                    ++state;
                    break;
                }
                case 1: {
                    if (c != 'a') break;
                    ++state;
                    break;
                }
                case 2: {
                    switch (c) {
                        case 'h': {
                            state = 7;
                            break block0;
                        }
                        case '>': {
                            linkStart = index + 1;
                            ++state;
                            break block0;
                        }
                    }
                    if (Character.isWhitespace(c)) break;
                    state = 13;
                    break;
                }
                case 3: {
                    if (c != '<') break;
                    endtagStart = index;
                    ++state;
                    break;
                }
                case 4: {
                    state = c == '/' ? state + 1 : 3;
                    break;
                }
                case 5: {
                    state = c == 'a' ? state + 1 : 3;
                    break;
                }
                case 6: {
                    if (c == '>') {
                        this.mnemonics[linkIndex] = this.parseMnemonics(buffer, start, tagStart, result);
                        int offset = result.length();
                        this.parseMnemonics(buffer, linkStart, endtagStart, result);
                        this.offsets[linkIndex] = new Point(offset, result.length() - 1);
                        if (this.ids[linkIndex] == null) {
                            this.ids[linkIndex] = new String(buffer, linkStart, endtagStart - linkStart);
                        }
                        ++linkIndex;
                        endtagStart = refStart = index + 1;
                        linkStart = refStart;
                        tagStart = refStart;
                        start = refStart;
                        state = 0;
                        break;
                    }
                    state = 3;
                    break;
                }
                case 7: {
                    state = c == 'r' ? state + 1 : 0;
                    break;
                }
                case 8: {
                    state = c == 'e' ? state + 1 : 0;
                    break;
                }
                case 9: {
                    state = c == 'f' ? state + 1 : 0;
                    break;
                }
                case 10: {
                    state = c == '=' ? state + 1 : 0;
                    break;
                }
                case 11: {
                    if (c == '\"') {
                        ++state;
                        refStart = index + 1;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 12: {
                    if (c != '\"') break;
                    this.ids[linkIndex] = new String(buffer, refStart, index - refStart);
                    state = 2;
                    break;
                }
                case 13: {
                    if (Character.isWhitespace(c)) {
                        state = 0;
                        break;
                    }
                    if (c != '=') break;
                    ++state;
                    break;
                }
                case 14: {
                    state = c == '\"' ? state + 1 : 0;
                    break;
                }
                case 15: {
                    if (c != '\"') break;
                    state = 2;
                    break;
                }
                default: {
                    state = 0;
                }
            }
            ++index;
        }
        if (start < length) {
            int tmp = this.parseMnemonics(buffer, start, tagStart, result);
            int mnemonic = this.parseMnemonics(buffer, Math.max(tagStart, linkStart), length, result);
            if (mnemonic == -1) {
                mnemonic = tmp;
            }
            this.mnemonics[linkIndex] = mnemonic;
        } else {
            this.mnemonics[linkIndex] = -1;
        }
        if (this.offsets.length != linkIndex) {
            Point[] newOffsets = new Point[linkIndex];
            System.arraycopy(this.offsets, 0, newOffsets, 0, linkIndex);
            this.offsets = newOffsets;
            String[] newIDs = new String[linkIndex];
            System.arraycopy(this.ids, 0, newIDs, 0, linkIndex);
            this.ids = newIDs;
            int[] newMnemonics = new int[linkIndex + 1];
            System.arraycopy(this.mnemonics, 0, newMnemonics, 0, linkIndex + 1);
            this.mnemonics = newMnemonics;
        }
        return result.toString();
    }

    int parseMnemonics(char[] buffer, int start, int end, StringBuffer result) {
        int mnemonic = -1;
        int index = start;
        while (index < end) {
            if (buffer[index] == '&') {
                if (index + 1 < end && buffer[index + 1] == '&') {
                    result.append(buffer[index]);
                    ++index;
                } else {
                    mnemonic = result.length();
                }
            } else {
                result.append(buffer[index]);
            }
            ++index;
        }
        return mnemonic;
    }

    boolean sendMouseEvent(int type, short button, int count, int detail, boolean send, int chord, short x, short y, int modifiers) {
        boolean result = super.sendMouseEvent(type, button, count, detail, send, chord, x, y, modifiers);
        switch (type) {
            case 3: {
                if (button != 1 || count != 1) break;
                int offset = this.layout.getOffset(x, y, null);
                int oldSelectionX = this.selection.x;
                int oldSelectionY = this.selection.y;
                this.selection.x = offset;
                this.selection.y = -1;
                if (oldSelectionX != -1 && oldSelectionY != -1) {
                    if (oldSelectionX > oldSelectionY) {
                        int temp = oldSelectionX;
                        oldSelectionX = oldSelectionY;
                        oldSelectionY = temp;
                    }
                    Rectangle rectangle = this.layout.getBounds(oldSelectionX, oldSelectionY);
                    this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
                }
                int j = 0;
                while (j < this.offsets.length) {
                    Rectangle[] rects = this.getRectangles(j);
                    int i = 0;
                    while (i < rects.length) {
                        Rectangle rectangle = rects[i];
                        if (rectangle.contains(x, y)) {
                            this.focusIndex = j;
                            this.redraw();
                            this.setFocus();
                            return result;
                        }
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            case 5: {
                if ((chord & 1) == 0) break;
                int oldSelection = this.selection.y;
                this.selection.y = this.layout.getOffset(x, y, null);
                if (this.selection.y == oldSelection) break;
                int newSelection = this.selection.y;
                if (oldSelection > newSelection) {
                    int temp = oldSelection;
                    oldSelection = newSelection;
                    newSelection = temp;
                }
                Rectangle rectangle = this.layout.getBounds(oldSelection, newSelection);
                this.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, false);
                break;
            }
            case 4: {
                if (this.focusIndex == -1 || button != 1) break;
                Rectangle[] rects = this.getRectangles(this.focusIndex);
                int i = 0;
                while (i < rects.length) {
                    Rectangle rectangle = rects[i];
                    if (rectangle.contains(x, y)) {
                        Event event = new Event();
                        event.text = this.ids[this.focusIndex];
                        this.sendSelectionEvent(13, event, true);
                        return result;
                    }
                    ++i;
                }
                break;
            }
        }
        return result;
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int result = super.setBounds(x, y, width, height, move, resize, events);
        if ((result & 0x80) != 0) {
            this.layout.setWidth(width > 0 ? width : -1);
        }
        return result;
    }

    void setFontStyle(Font font) {
        super.setFontStyle(font);
        this.layout.setFont(this.getFont());
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        this.layout.setText(this.parse(string));
        this.focusIndex = this.offsets.length > 0 ? 0 : -1;
        this.selection.y = -1;
        this.selection.x = -1;
        boolean enabled = (this.state & 8) == 0;
        TextStyle linkStyle = new TextStyle(null, enabled ? this.linkColor : this.disabledColor, null);
        linkStyle.underline = true;
        int i = 0;
        while (i < this.offsets.length) {
            Point point = this.offsets[i];
            this.layout.setStyle(linkStyle, point.x, point.y);
            ++i;
        }
        this.redraw();
    }

    int traversalCode(int key, int theEvent) {
        if (this.offsets.length == 0) {
            return 0;
        }
        int bits = super.traversalCode(key, theEvent);
        if (key == 48 && theEvent != 0) {
            boolean next;
            int[] modifiers = new int[1];
            OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
            boolean bl = next = (modifiers[0] & 0x200) == 0;
            if (next && this.focusIndex < this.offsets.length - 1) {
                return bits & 0xFFFFFFEF;
            }
            if (!next && this.focusIndex > 0) {
                return bits & 0xFFFFFFF7;
            }
        }
        return bits;
    }
}

