/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.internal.corext.util.DelegateEntryComparator;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public final class AddDelegateMethodsOperation
implements IWorkspaceRunnable {
    private boolean fApply = true;
    private final List fCreated = new ArrayList();
    private TextEdit fResultingEdit = null;
    private final IJavaElement fInsert;
    private final boolean fSave;
    private final CodeGenerationSettings fSettings;
    private final CompilationUnit fASTRoot;
    private final DelegateEntry[] fDelegatesToCreate;

    public AddDelegateMethodsOperation(CompilationUnit astRoot, DelegateEntry[] delegatesToCreate, IJavaElement insert, CodeGenerationSettings settings, boolean apply, boolean save) {
        Assert.isTrue((astRoot != null && astRoot.getTypeRoot() instanceof ICompilationUnit ? 1 : 0) != 0);
        Assert.isTrue((delegatesToCreate != null && delegatesToCreate.length > 0 ? 1 : 0) != 0);
        Assert.isNotNull((Object)settings);
        this.fASTRoot = astRoot;
        this.fInsert = insert;
        this.fDelegatesToCreate = delegatesToCreate;
        this.fSettings = settings;
        this.fSave = save;
        this.fApply = apply;
    }

    public final String[] getCreatedMethods() {
        String[] keys = new String[this.fCreated.size()];
        this.fCreated.toArray(keys);
        return keys;
    }

    public final TextEdit getResultingEdit() {
        return this.fResultingEdit;
    }

    public final ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public final void run(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask("", 1);
            monitor.setTaskName(CodeGenerationMessages.AddDelegateMethodsOperation_monitor_message);
            this.fCreated.clear();
            ICompilationUnit cu = (ICompilationUnit)this.fASTRoot.getTypeRoot();
            ASTRewrite astRewrite = ASTRewrite.create((AST)this.fASTRoot.getAST());
            ImportRewrite importRewrite = StubUtility.createImportRewrite(this.fASTRoot, true);
            ITypeBinding parentType = this.fDelegatesToCreate[0].field.getDeclaringClass();
            ASTNode typeDecl = this.fASTRoot.findDeclaringNode((IBinding)parentType);
            ListRewrite listRewriter = null;
            if (typeDecl instanceof AbstractTypeDeclaration) {
                listRewriter = astRewrite.getListRewrite(typeDecl, ((AbstractTypeDeclaration)typeDecl).getBodyDeclarationsProperty());
            } else if (typeDecl instanceof AnonymousClassDeclaration) {
                listRewriter = astRewrite.getListRewrite(typeDecl, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
            }
            if (listRewriter != null) {
                ASTNode insertion = StubUtility2.getNodeToInsertBefore(listRewriter, this.fInsert);
                ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext(this.fASTRoot, typeDecl.getStartPosition(), importRewrite);
                Arrays.sort(this.fDelegatesToCreate, new DelegateEntryComparator());
                int i = 0;
                while (i < this.fDelegatesToCreate.length) {
                    IMethodBinding delegateMethod = this.fDelegatesToCreate[i].delegateMethod;
                    IVariableBinding field = this.fDelegatesToCreate[i].field;
                    MethodDeclaration newMethod = StubUtility2.createDelegationStub(cu, astRewrite, importRewrite, context, delegateMethod, field, this.fSettings);
                    if (newMethod != null) {
                        this.fCreated.add(delegateMethod);
                        if (insertion != null && insertion.getParent() == typeDecl) {
                            listRewriter.insertBefore((ASTNode)newMethod, insertion, null);
                        } else {
                            listRewriter.insertLast((ASTNode)newMethod, null);
                        }
                    }
                    ++i;
                }
                this.fResultingEdit = new MultiTextEdit();
                this.fResultingEdit.addChild(astRewrite.rewriteAST());
                this.fResultingEdit.addChild(importRewrite.rewriteImports((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                if (this.fApply) {
                    JavaModelUtil.applyEdit(cu, this.fResultingEdit, this.fSave, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public static class DelegateEntry {
        public final IMethodBinding delegateMethod;
        public final IVariableBinding field;

        public DelegateEntry(IMethodBinding delegateMethod, IVariableBinding field) {
            Assert.isNotNull((Object)delegateMethod);
            Assert.isNotNull((Object)field);
            this.delegateMethod = delegateMethod;
            this.field = field;
        }
    }
}

