/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.formatter.IndentManipulation;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;

public class JavaElementLine {
    private final ITypeRoot fElement;
    private final String fLineContents;
    private final int fLineNumber;
    private final int fLineStartOffset;
    private int fFlags;

    public JavaElementLine(ITypeRoot element, int lineNumber, int lineStartOffset) throws CoreException {
        this.fElement = element;
        this.fFlags = 0;
        IBuffer buffer = element.getBuffer();
        if (buffer == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", Messages.format(SearchMessages.JavaElementLine_error_nobuffer, BasicElementLabels.getFileName(element))));
        }
        int length = buffer.getLength();
        int i = lineStartOffset;
        char ch = buffer.getChar(i);
        while (lineStartOffset < length && IndentManipulation.isIndentChar((char)ch)) {
            ch = buffer.getChar(++i);
        }
        this.fLineStartOffset = i;
        StringBuffer buf = new StringBuffer();
        while (i < length && !IndentManipulation.isLineDelimiterChar((char)ch)) {
            if (Character.isISOControl(ch)) {
                buf.append(' ');
            } else {
                buf.append(ch);
            }
            ch = buffer.getChar(++i);
        }
        this.fLineContents = buf.toString();
        this.fLineNumber = lineNumber;
    }

    public void setFlags(int flags) {
        this.fFlags = flags;
    }

    public int getFlags() {
        return this.fFlags;
    }

    public ITypeRoot getJavaElement() {
        return this.fElement;
    }

    public int getLine() {
        return this.fLineNumber;
    }

    public String getLineContents() {
        return this.fLineContents;
    }

    public int getLineStartOffset() {
        return this.fLineStartOffset;
    }
}

