/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.EditFilterWizard;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class EditFilterAction
extends BuildpathModifierAction {
    public EditFilterAction(IWorkbenchSite site) {
        this(site, null, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
    }

    public EditFilterAction(IRunnableContext context, ISetSelectionTarget selectionTarget) {
        this(null, selectionTarget, context);
    }

    private EditFilterAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget, IRunnableContext context) {
        super(site, selectionTarget, 4);
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_label);
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_CONFIGURE_BUILDPATH_FILTERS);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Edit_tooltip);
        this.setDescription(NewWizardMessages.PackageExplorerActionGroup_FormText_Edit);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_CONFIGURE_BUILDPATH_FILTERS);
    }

    public String getDetailedDescription() {
        if (!this.isEnabled()) {
            return null;
        }
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Edit;
    }

    public void run() {
        Shell shell = this.getShell();
        try {
            EditFilterWizard wizard = this.createWizard();
            wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection(this.getSelectedElements().get(0)));
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            PixelConverter converter = new PixelConverter(JFaceResources.getDialogFont());
            dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
            dialog.create();
            int res = dialog.open();
            if (res == 0) {
                BuildpathDelta delta = new BuildpathDelta(this.getToolTipText());
                ArrayList newEntries = wizard.getExistingEntries();
                delta.setNewEntries(newEntries.toArray(new CPListElement[newEntries.size()]));
                IResource resource = wizard.getCreatedElement().getCorrespondingResource();
                delta.addCreatedResource(resource);
                delta.setDefaultOutputLocation(wizard.getOutputLocation());
                this.informListeners(delta);
                this.selectAndReveal((ISelection)new StructuredSelection((Object)wizard.getCreatedElement()));
            }
            this.notifyResult(res == 0);
        }
        catch (CoreException e) {
            String title = NewWizardMessages.AbstractOpenWizardAction_createerror_title;
            String message = NewWizardMessages.AbstractOpenWizardAction_createerror_message;
            ExceptionHandler.handle(e, shell, title, message);
        }
    }

    private EditFilterWizard createWizard() throws CoreException {
        IJavaProject javaProject = null;
        Object firstElement = this.getSelectedElements().get(0);
        javaProject = firstElement instanceof IJavaProject ? (IJavaProject)firstElement : ((IPackageFragmentRoot)firstElement).getJavaProject();
        CPListElement[] existingEntries = CPListElement.createFromExisting(javaProject);
        CPListElement elementToEdit = EditFilterAction.findElement((IJavaElement)firstElement, existingEntries);
        return new EditFilterWizard(existingEntries, elementToEdit, this.getOutputLocation(javaProject));
    }

    private IPath getOutputLocation(IJavaProject javaProject) {
        try {
            return javaProject.getOutputLocation();
        }
        catch (CoreException coreException) {
            IProject project = javaProject.getProject();
            IPath projPath = project.getFullPath();
            return projPath.append(PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"));
        }
    }

    private static CPListElement findElement(IJavaElement element, CPListElement[] elements) {
        IPath path = element.getPath();
        int i = 0;
        while (i < elements.length) {
            CPListElement cur = elements[i];
            if (cur.getEntryKind() == 3 && cur.getPath().equals((Object)path)) {
                return cur;
            }
            ++i;
        }
        return null;
    }

    protected boolean canHandle(IStructuredSelection selection) {
        block5: {
            IPackageFragmentRoot packageFragmentRoot;
            block6: {
                if (selection.size() != 1) {
                    return false;
                }
                try {
                    Object element = selection.getFirstElement();
                    if (element instanceof IJavaProject) {
                        return ClasspathModifier.isSourceFolder((IJavaProject)element);
                    }
                    if (!(element instanceof IPackageFragmentRoot)) break block5;
                    packageFragmentRoot = (IPackageFragmentRoot)element;
                    if (packageFragmentRoot.getKind() == 1) break block6;
                    return false;
                }
                catch (JavaModelException javaModelException) {}
            }
            return packageFragmentRoot.getJavaProject() != null;
        }
        return false;
    }
}

