/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.scheduler;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdateMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdatePlugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.progress.WorkbenchJob;

public class AutomaticUpdatesPopup
extends PopupDialog {
    public static final String[] ELAPSED = new String[]{AutomaticUpdateMessages.AutomaticUpdateScheduler_30Minutes, AutomaticUpdateMessages.AutomaticUpdateScheduler_60Minutes, AutomaticUpdateMessages.AutomaticUpdateScheduler_240Minutes};
    private static final long MINUTE = 60000L;
    private static final String PREFS_HREF = "PREFS";
    private static final String DIALOG_SETTINGS_SECTION = "AutomaticUpdatesPopup";
    private static final int POPUP_OFFSET = 20;
    IPreferenceStore prefs;
    long remindDelay = -1L;
    IPropertyChangeListener prefListener;
    WorkbenchJob remindJob;
    boolean downloaded;
    Composite dialogArea;
    Link remindLink;
    MouseListener clickListener;

    public AutomaticUpdatesPopup(Shell parentShell, boolean alreadyDownloaded, IPreferenceStore prefs) {
        super(parentShell, 16, false, true, true, false, false, AutomaticUpdateMessages.AutomaticUpdatesPopup_UpdatesAvailableTitle, null);
        this.downloaded = alreadyDownloaded;
        this.prefs = prefs;
        this.remindDelay = this.computeRemindDelay();
        this.clickListener = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AutomaticUpdatePlugin.getDefault().getAutomaticUpdater().launchUpdate();
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        this.dialogArea = new Composite(parent, 0);
        this.dialogArea.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.dialogArea.setLayout((Layout)layout);
        this.dialogArea.addMouseListener(this.clickListener);
        Label infoLabel = new Label(this.dialogArea, 0);
        if (this.downloaded) {
            infoLabel.setText(AutomaticUpdateMessages.AutomaticUpdatesPopup_ClickToReviewDownloaded);
        } else {
            infoLabel.setText(AutomaticUpdateMessages.AutomaticUpdatesPopup_ClickToReviewNotDownloaded);
        }
        infoLabel.setLayoutData((Object)new GridData(1808));
        infoLabel.addMouseListener(this.clickListener);
        this.createRemindSection(this.dialogArea);
        return this.dialogArea;
    }

    private void createRemindSection(Composite parent) {
        this.remindLink = new Link(parent, 131138);
        this.updateRemindText();
        this.remindLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)AutomaticUpdatesPopup.this.getShell(), (String)"org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdatesPreferencePage", null, null);
                dialog.open();
            }
        });
        this.remindLink.setLayoutData((Object)new GridData(1808));
    }

    private void updateRemindText() {
        if (this.prefs.getBoolean("remindOnSchedule")) {
            this.remindLink.setText(NLS.bind((String)AutomaticUpdateMessages.AutomaticUpdatesPopup_RemindAndPrefLink, (Object[])new String[]{this.prefs.getString("remindElapsedTime"), PREFS_HREF}));
        } else {
            this.remindLink.setText(AutomaticUpdateMessages.AutomaticUpdatesPopup_PrefLinkOnly);
        }
        this.remindLink.getParent().layout(true);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = AutomaticUpdatePlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }

    public int open() {
        this.prefListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                AutomaticUpdatesPopup.this.handlePreferenceChange(event);
            }
        };
        this.prefs.addPropertyChangeListener(this.prefListener);
        return super.open();
    }

    public boolean close() {
        return this.close(true);
    }

    public boolean close(boolean remind) {
        if (remind && this.prefs.getBoolean("remindOnSchedule")) {
            this.scheduleRemindJob();
        } else {
            this.cancelRemindJob();
        }
        if (this.prefListener != null) {
            this.prefs.removePropertyChangeListener(this.prefListener);
            this.prefListener = null;
        }
        return super.close();
    }

    void scheduleRemindJob() {
        if (this.remindJob != null) {
            this.remindJob.cancel();
        }
        if (this.remindDelay < 0L) {
            return;
        }
        this.remindJob = new WorkbenchJob(AutomaticUpdateMessages.AutomaticUpdatesPopup_ReminderJobTitle){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                AutomaticUpdatesPopup.this.open();
                return Status.OK_STATUS;
            }
        };
        this.remindJob.setSystem(true);
        this.remindJob.setPriority(10);
        this.remindJob.schedule(this.remindDelay);
    }

    long computeRemindDelay() {
        if (this.prefs.getBoolean("remindOnSchedule")) {
            String elapsed = this.prefs.getString("remindElapsedTime");
            int d = 0;
            while (d < ELAPSED.length) {
                if (ELAPSED[d].equals(elapsed)) {
                    switch (d) {
                        case 0: {
                            return 1800000L;
                        }
                        case 1: {
                            return 3600000L;
                        }
                        case 2: {
                            return 14400000L;
                        }
                    }
                }
                ++d;
            }
        }
        return -1L;
    }

    void cancelRemindJob() {
        if (this.remindJob != null) {
            this.remindJob.cancel();
            this.remindJob = null;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(AutomaticUpdateMessages.AutomaticUpdatesPopup_UpdatesAvailableTitle);
    }

    protected Point getInitialLocation(Point initialSize) {
        Point parentLocation;
        Point parentSize;
        Shell parent = this.getParentShell();
        if (parent != null) {
            parentSize = parent.getSize();
            parentLocation = parent.getLocation();
        } else {
            Rectangle bounds = this.getShell().getDisplay().getBounds();
            parentSize = new Point(bounds.width, bounds.height);
            parentLocation = new Point(0, 0);
        }
        return new Point(parentSize.x - initialSize.x + parentLocation.x - 20, parentSize.y - initialSize.y + parentLocation.y - 20);
    }

    void handlePreferenceChange(PropertyChangeEvent event) {
        if ("remindOnSchedule".equals(event.getProperty())) {
            if (this.prefs.getBoolean("remindOnSchedule")) {
                if (this.remindLink == null) {
                    this.createRemindSection(this.dialogArea);
                } else {
                    this.updateRemindText();
                    this.getShell().layout(true, true);
                }
                this.computeRemindDelay();
                this.scheduleRemindJob();
            } else {
                if (this.remindLink != null) {
                    this.updateRemindText();
                    this.getShell().layout(true, true);
                }
                this.cancelRemindJob();
            }
        } else if ("remindElapsedTime".equals(event.getProperty())) {
            this.computeRemindDelay();
            this.scheduleRemindJob();
        }
    }

    protected Control createTitleMenuArea(Composite parent) {
        Composite titleComposite = (Composite)super.createTitleMenuArea(parent);
        titleComposite.addMouseListener(this.clickListener);
        ToolBar toolBar = new ToolBar(titleComposite, 0x800000);
        ToolItem closeButton = new ToolItem(toolBar, 8, 0);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)toolBar);
        closeButton.setImage(AutomaticUpdatePlugin.getDefault().getImageRegistry().get("tool/close.gif"));
        closeButton.setHotImage(AutomaticUpdatePlugin.getDefault().getImageRegistry().get("tool/close_hot.gif"));
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPopup.this.close();
            }
        });
        toolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AutomaticUpdatesPopup.this.close();
            }
        });
        return titleComposite;
    }

    protected Control createTitleControl(Composite parent) {
        Control control = super.createTitleControl(parent);
        Object data = control.getLayoutData();
        if (data instanceof GridData) {
            ((GridData)data).horizontalSpan = 1;
        }
        return control;
    }
}

