/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.util.Arrays;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.Splitter;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffChangeListener;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.CommitCommentArea;
import org.eclipse.team.internal.ccvs.ui.mappings.ChangeSetComparator;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizard;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.ui.PixelConverter;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ParticipantPageCompareEditorInput;
import org.eclipse.team.ui.synchronize.ParticipantPagePane;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;

public class CommitWizardCommitPage
extends WizardPage
implements IPropertyChangeListener {
    public static final String SHOW_COMPARE = "ShowCompare";
    private static final String H_WEIGHT_1 = "HWeight1";
    private static final String H_WEIGHT_2 = "HWeight2";
    private static final String V_WEIGHT_1 = "VWeight1";
    private static final String V_WEIGHT_2 = "VWeight2";
    private final CommitCommentArea fCommentArea;
    private ISynchronizePageConfiguration fConfiguration;
    protected final CommitWizard fWizard;
    private ParticipantPagePane fPagePane;
    private PageBook bottomChild;
    private boolean fHasConflicts;
    private boolean fIsEmpty;
    private Splitter horizontalSash;
    private SashForm verticalSash;
    private boolean showCompare;

    public CommitWizardCommitPage(IResource[] resources, CommitWizard wizard) {
        super(CVSUIMessages.CommitWizardCommitPage_0);
        this.setTitle(CVSUIMessages.CommitWizardCommitPage_0);
        this.setDescription(CVSUIMessages.CommitWizardCommitPage_2);
        this.fWizard = wizard;
        this.fCommentArea = new CommitCommentArea();
        this.fCommentArea.setProposedComment(this.getProposedComment(resources));
        if (resources.length > 0) {
            this.fCommentArea.setProject(resources[0].getProject());
        }
        this.fWizard.getDiffTree().addDiffChangeListener(new IDiffChangeListener(){

            public void propertyChanged(IDiffTree tree, int property, IPath[] paths) {
            }

            public void diffsChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
                Utils.syncExec((Runnable)new Runnable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        1.access$0(this.this$1).updateEnablements();
                    }
                }, (Control)CommitWizardCommitPage.this.getControl());
            }

            static /* synthetic */ CommitWizardCommitPage access$0(1 var0) {
                return var0.CommitWizardCommitPage.this;
            }
        });
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Dialog.applyDialogFont((Control)parent);
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)SWTUtils.createGridLayout((int)1, (PixelConverter)converter, (int)-1));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.cvs.ui.commit_comment_page_context");
        this.horizontalSash = new Splitter(composite, 256);
        this.horizontalSash.setLayoutData((Object)new GridData(4, 4, true, true));
        this.verticalSash = new SashForm((Composite)this.horizontalSash, 512);
        this.verticalSash.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createCommentArea((Composite)this.verticalSash, converter);
        this.createChangesArea((Composite)this.verticalSash, converter);
        IDialogSettings section = this.getDialogSettings().getSection("CommitWizard");
        this.showCompare = section == null ? false : section.getBoolean(SHOW_COMPARE);
        int vWeight1 = 50;
        int vWeight2 = 50;
        if (section != null) {
            try {
                vWeight1 = section.getInt(V_WEIGHT_1);
                vWeight2 = section.getInt(V_WEIGHT_2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int hWeight1 = 35;
        int hWeight2 = 65;
        if (section != null) {
            try {
                hWeight1 = section.getInt(H_WEIGHT_1);
                hWeight2 = section.getInt(H_WEIGHT_2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!this.showCompare) {
            this.horizontalSash.setMaximizedControl((Control)this.verticalSash);
        }
        this.verticalSash.setWeights(new int[]{vWeight1, vWeight2});
        this.horizontalSash.setWeights(new int[]{hWeight1, hWeight2});
        Dialog.applyDialogFont((Control)parent);
        this.setControl((Control)composite);
        this.fCommentArea.setFocus();
        this.validatePage(false);
    }

    private void createCommentArea(Composite parent, PixelConverter converter) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(0, 0).create());
        this.fCommentArea.createArea(c);
        GridData gd = SWTUtils.createGridData((int)-1, (int)-1, (int)4, (int)4, (boolean)true, (boolean)true);
        this.fCommentArea.getComposite().setLayoutData((Object)gd);
        this.fCommentArea.addPropertyChangeListener(this);
        this.createPlaceholder(c);
    }

    private void createChangesArea(Composite parent, PixelConverter converter) {
        ModelSynchronizeParticipant participant = this.fWizard.getParticipant();
        int size = this.fWizard.getDiffTree().getAffectedResources().length;
        if (size > this.getFileDisplayThreshold()) {
            this.bottomChild = new PageBook(parent, 0);
            this.bottomChild.setLayoutData((Object)SWTUtils.createGridData((int)-1, (int)-1, (int)4, (int)4, (boolean)true, (boolean)false));
            Composite changeDesc = new Composite((Composite)this.bottomChild, 0);
            changeDesc.setLayout((Layout)SWTUtils.createGridLayout((int)1, (PixelConverter)converter, (int)0));
            SWTUtils.createLabel((Composite)changeDesc, (String)NLS.bind((String)CVSUIMessages.CommitWizardCommitPage_1, (Object[])new String[]{Integer.toString(size), Integer.toString(this.getFileDisplayThreshold())}));
            Button showChanges = new Button(changeDesc, 8);
            showChanges.setText(CVSUIMessages.CommitWizardCommitPage_5);
            showChanges.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CommitWizardCommitPage.this.showChangesPane();
                }
            });
            showChanges.setLayoutData((Object)new GridData());
            this.bottomChild.showPage((Control)changeDesc);
        } else {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)SWTUtils.createGridLayout((int)1, (PixelConverter)converter, (int)0));
            composite.setLayoutData((Object)SWTUtils.createGridData((int)-1, (int)-1, (int)4, (int)4, (boolean)true, (boolean)true));
            Control c = this.createChangesPage(composite, (ISynchronizeParticipant)participant);
            c.setLayoutData((Object)SWTUtils.createHVFillGridData());
        }
    }

    protected void showChangesPane() {
        Control c = this.createChangesPage((Composite)this.bottomChild, (ISynchronizeParticipant)this.fWizard.getParticipant());
        this.bottomChild.setLayoutData((Object)SWTUtils.createGridData((int)-1, (int)-1, (int)4, (int)4, (boolean)true, (boolean)true));
        this.bottomChild.showPage(c);
        Dialog.applyDialogFont((Control)this.getControl());
        ((Composite)this.getControl()).layout();
    }

    private Control createChangesPage(Composite composite, ISynchronizeParticipant participant) {
        this.fConfiguration = participant.createPageConfiguration();
        CompareConfiguration cc = new CompareConfiguration();
        cc.setLeftEditable(false);
        cc.setRightEditable(false);
        CommitWizardParticipantPageCompareEditorInput input = new CommitWizardParticipantPageCompareEditorInput(cc, this.fConfiguration, participant);
        Control control = input.createContents(composite);
        control.setLayoutData((Object)new GridData(1808));
        return control;
    }

    private int getFileDisplayThreshold() {
        return CVSUIPlugin.getPlugin().getPreferenceStore().getInt("pref_commit_files_display_threshold");
    }

    public void dispose() {
        super.dispose();
        if (this.fPagePane != null) {
            this.fPagePane.dispose();
        }
    }

    private void createPlaceholder(Composite composite) {
        Composite placeholder = new Composite(composite, 0);
        placeholder.setLayoutData((Object)new GridData(-1, this.convertHorizontalDLUsToPixels(4) / 3));
    }

    public String getComment(Shell shell) {
        return this.fCommentArea.getCommentWithPrompt(shell);
    }

    public boolean isPageComplete() {
        String comment;
        IPreferenceStore store = CVSUIPlugin.getPlugin().getPreferenceStore();
        String allowEmptyComment = store.getString("pref_allow_empty_commit_comment");
        if (allowEmptyComment.equals("never") && (comment = this.fCommentArea.getComment(false)).equals("")) {
            return false;
        }
        return super.isPageComplete();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.expand();
        if (visible && this.fConfiguration != null) {
            Viewer viewer = this.fConfiguration.getPage().getViewer();
            viewer.refresh();
        }
        this.updateEnablements();
        this.setFocus();
    }

    protected void expand() {
        Viewer viewer;
        if (this.fConfiguration != null && (viewer = this.fConfiguration.getPage().getViewer()) instanceof TreeViewer) {
            try {
                viewer.getControl().setRedraw(false);
                ((TreeViewer)viewer).expandAll();
            }
            finally {
                viewer.getControl().setRedraw(true);
            }
        }
    }

    protected void updateForModelChange() {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        this.expand();
        this.updateEnablements();
    }

    public void updateEnablements() {
        if (this.fConfiguration != null) {
            this.fHasConflicts = false;
            this.fIsEmpty = false;
            if (this.fWizard.hasConflicts()) {
                this.fHasConflicts = true;
            }
            if (!this.fWizard.hasOutgoingChanges()) {
                this.fIsEmpty = true;
            }
        }
        this.validatePage(false);
    }

    boolean validatePage(boolean setMessage) {
        IPreferenceStore store;
        String value;
        if (this.fCommentArea != null && this.fCommentArea.getComment(false).length() == 0 && "never".equals(value = (store = CVSUIPlugin.getPlugin().getPreferenceStore()).getString("pref_allow_empty_commit_comment"))) {
            this.setPageComplete(false);
            if (setMessage) {
                this.setErrorMessage(CVSUIMessages.CommitWizardCommitPage_3);
            }
            return false;
        }
        if (this.fHasConflicts) {
            this.setErrorMessage(CVSUIMessages.CommitWizardCommitPage_4);
            this.setPageComplete(false);
            return false;
        }
        if (this.fIsEmpty) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return false;
        }
        this.setPageComplete(true);
        this.setErrorMessage(null);
        return true;
    }

    public void setFocus() {
        this.fCommentArea.setFocus();
        this.validatePage(true);
    }

    protected IWizardContainer getContainer() {
        return super.getContainer();
    }

    ResourceTraversal[] getTraversalsToCommit() {
        return this.fWizard.getParticipant().getContext().getScope().getTraversals();
    }

    public void propertyChange(PropertyChangeEvent event) {
        IWizardContainer container;
        if (event.getProperty().equals("OkRequested") && (container = this.getContainer()) instanceof WizardDialog) {
            WizardDialog dialog = (WizardDialog)container;
            if (this.getWizard().canFinish()) {
                try {
                    this.getWizard().performFinish();
                }
                finally {
                    dialog.close();
                }
            }
        }
        if (event.getProperty().equals("CommentModified")) {
            this.validatePage(true);
        }
    }

    private String getProposedComment(IResource[] resourcesToCommit) {
        StringBuffer comment = new StringBuffer();
        ChangeSet[] sets = CVSUIPlugin.getPlugin().getChangeSetManager().getSets();
        Arrays.sort(sets, new ChangeSetComparator());
        int numMatchedSets = 0;
        int i = 0;
        while (i < sets.length) {
            ChangeSet set = sets[i];
            if (this.isUserSet(set) && this.containsOne(set, resourcesToCommit)) {
                if (numMatchedSets > 0) {
                    comment.append(System.getProperty("line.separator"));
                }
                comment.append(set.getComment());
                ++numMatchedSets;
            }
            ++i;
        }
        return comment.toString();
    }

    private boolean isUserSet(ChangeSet set) {
        if (set instanceof ActiveChangeSet) {
            ActiveChangeSet acs = (ActiveChangeSet)set;
            return acs.isUserCreated();
        }
        return false;
    }

    private boolean containsOne(ChangeSet set, IResource[] resourcesToCommit) {
        int j = 0;
        while (j < resourcesToCommit.length) {
            ActiveChangeSet acs;
            IResource resource = resourcesToCommit[j];
            if (set.contains(resource)) {
                return true;
            }
            if (set instanceof ActiveChangeSet && (acs = (ActiveChangeSet)set).getDiffTree().members(resource).length > 0) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public void finish() {
        int[] hWeights = this.horizontalSash.getWeights();
        int[] vWeights = this.verticalSash.getWeights();
        IDialogSettings section = this.getDialogSettings().getSection("CommitWizard");
        if (section == null) {
            section = this.getDialogSettings().addNewSection("CommitWizard");
        }
        if (this.showCompare) {
            section.put(H_WEIGHT_1, hWeights[0]);
            section.put(H_WEIGHT_2, hWeights[1]);
        }
        section.put(V_WEIGHT_1, vWeights[0]);
        section.put(V_WEIGHT_2, vWeights[1]);
        section.put(SHOW_COMPARE, this.showCompare);
    }

    public void showComparePane(boolean showCompare) {
        this.showCompare = showCompare;
        if (showCompare) {
            this.horizontalSash.setMaximizedControl(null);
        } else {
            this.horizontalSash.setMaximizedControl((Control)this.verticalSash);
        }
    }

    private class CommitWizardParticipantPageCompareEditorInput
    extends ParticipantPageCompareEditorInput {
        public CommitWizardParticipantPageCompareEditorInput(CompareConfiguration cc, ISynchronizePageConfiguration configuration, ISynchronizeParticipant participant) {
            super(cc, configuration, participant);
        }

        protected boolean isOfferToRememberParticipant() {
            return false;
        }

        protected CompareViewerSwitchingPane createContentViewerSwitchingPane(Splitter parent, int style, CompareEditorInput cei) {
            return super.createContentViewerSwitchingPane(CommitWizardCommitPage.this.horizontalSash, style, cei);
        }

        protected void setPageDescription(String title) {
            super.setPageDescription(TeamUIMessages.ParticipantPageSaveablePart_0);
        }
    }
}

