/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.comparator;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.Signature;
import org.eclipse.pde.api.tools.internal.comparator.ComparatorMessages;
import org.eclipse.pde.api.tools.internal.comparator.Delta;
import org.eclipse.pde.api.tools.internal.comparator.SignatureDecoder;
import org.eclipse.pde.api.tools.internal.comparator.SignatureDescriptor;
import org.eclipse.pde.api.tools.internal.comparator.TypeParameterDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiComparator;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiField;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class ClassFileComparator {
    private static boolean Debug = Util.DEBUG;
    private IApiBaseline apiBaseline1 = null;
    private IApiBaseline apiBaseline2 = null;
    private IApiComponent component = null;
    private IApiComponent component2 = null;
    private Delta delta = null;
    private IApiType type1 = null;
    private IApiType type2 = null;
    private int visibilityModifiers;
    private int currentDescriptorRestrictions;
    private int initialDescriptorRestrictions;
    private MultiStatus status = null;

    public static void setDebug(boolean debugValue) {
        Debug = debugValue || Util.DEBUG;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isCheckedException(IApiBaseline baseline, IApiComponent apiComponent, String exceptionName) {
        if (baseline == null) {
            return true;
        }
        try {
            if (Util.isJavaLangRuntimeException(exceptionName)) {
                return false;
            }
            String packageName = Signatures.getPackageName(exceptionName);
            IApiTypeRoot result = Util.getClassFile(baseline.resolvePackage(apiComponent, packageName), exceptionName);
            if (result == null) return true;
            IApiType exception = result.getStructure();
            if (exception == null) {
                return false;
            }
            do {
                if (Util.isJavaLangObject(exception.getName())) {
                    return true;
                }
                String superName = exception.getSuperclassName();
                packageName = Signatures.getPackageName(superName);
                result = Util.getClassFile(baseline.resolvePackage(apiComponent, packageName), superName);
                if (result != null) continue;
                if (!Debug) return true;
                System.err.println("CHECKED EXCEPTION LOOKUP: Could not find " + superName + " in baseline " + baseline.getName() + " from component " + apiComponent.getSymbolicName());
                return true;
            } while (!Util.isJavaLangRuntimeException((exception = result.getStructure()).getName()));
            return false;
        }
        catch (CoreException e) {
            this.reportStatus(e);
        }
        return true;
    }

    public ClassFileComparator(IApiTypeRoot classFile, IApiTypeRoot classFile2, IApiComponent component, IApiComponent component2, IApiBaseline apiState, IApiBaseline apiState2, int visibilityModifiers) throws CoreException {
        this.component = component;
        this.component2 = component2;
        this.type1 = classFile.getStructure();
        this.type2 = classFile2.getStructure();
        this.apiBaseline1 = apiState;
        this.apiBaseline2 = apiState2;
        this.visibilityModifiers = visibilityModifiers;
    }

    public ClassFileComparator(IApiType type, IApiTypeRoot classFile2, IApiComponent component, IApiComponent component2, IApiBaseline apiState, IApiBaseline apiState2, int visibilityModifiers) throws CoreException {
        this.component = component;
        this.component2 = component2;
        this.type1 = type;
        this.type2 = classFile2.getStructure();
        this.apiBaseline1 = apiState;
        this.apiBaseline2 = apiState2;
        this.visibilityModifiers = visibilityModifiers;
    }

    private void addDelta(IDelta delta) {
        this.delta.add(delta);
    }

    private void addDelta(int elementType, int kind, int flags, int restrictions, int oldModifiers, int newModifiers, IApiType type, String key, String data) {
        this.addDelta(new Delta(Util.getDeltaComponentVersionsId(this.component2), elementType, kind, flags, restrictions, oldModifiers, newModifiers, type.getName(), key, data));
    }

    private void addDelta(int elementType, int kind, int flags, int restrictions, int oldModifiers, int newModifiers, IApiType type, String key, String[] datas) {
        this.addDelta(new Delta(Util.getDeltaComponentVersionsId(this.component2), elementType, kind, flags, restrictions, oldModifiers, newModifiers, type.getName(), key, datas));
    }

    private void checkSuperclass() throws CoreException {
        List superclassList1 = this.getSuperclassList(this.type1);
        if (!this.isStatusOk()) {
            return;
        }
        HashSet<String> superclassNames2 = null;
        List superclassList2 = this.getSuperclassList(this.type2);
        if (!this.isStatusOk()) {
            return;
        }
        if (superclassList2 != null) {
            superclassNames2 = new HashSet<String>();
            Iterator iterator = superclassList2.iterator();
            while (iterator.hasNext()) {
                superclassNames2.add(((IApiType)iterator.next()).getName());
            }
        }
        if (superclassList1 == null) {
            if (superclassList2 != null) {
                this.addDelta(this.getElementType(this.type1), 1, 39, this.currentDescriptorRestrictions, this.type1.getModifiers(), this.type2.getModifiers(), this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
            }
        } else if (superclassList2 == null) {
            this.addDelta(this.getElementType(this.type1), 3, 39, this.currentDescriptorRestrictions, this.type1.getModifiers(), this.type2.getModifiers(), this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
        }
        if (superclassList1 != null && superclassList2 != null) {
            IApiType superclassType2 = (IApiType)superclassList2.get(0);
            IApiType superclassType = (IApiType)superclassList1.get(0);
            if (!superclassType.getName().equals(superclassType2.getName())) {
                if (!superclassNames2.contains(superclassType.getName())) {
                    this.addDelta(this.getElementType(this.type1), 3, 39, this.currentDescriptorRestrictions, this.type1.getModifiers(), this.type2.getModifiers(), this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
                } else {
                    this.addDelta(this.getElementType(this.type1), 1, 39, this.currentDescriptorRestrictions, this.type1.getModifiers(), this.type2.getModifiers(), this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
                }
            }
        }
    }

    protected void reportStatus(IStatus newstatus) {
        if (this.status == null) {
            String msg = MessageFormat.format((String)ComparatorMessages.ClassFileComparator_0, (Object[])new String[]{this.type1.getName()});
            this.status = new MultiStatus("org.eclipse.pde.api.tools", 4, msg, null);
        }
        this.status.add(newstatus);
    }

    private void reportStatus(CoreException e) {
        this.reportStatus(e.getStatus());
    }

    private boolean isStatusOk() {
        return this.status == null;
    }

    public IStatus getStatus() {
        return this.status;
    }

    private void checkSuperInterfaces() {
        block20: {
            Set superinterfacesSet2;
            Set superinterfacesSet1;
            block19: {
                superinterfacesSet1 = this.getInterfacesSet(this.type1);
                if (!this.isStatusOk()) {
                    return;
                }
                superinterfacesSet2 = this.getInterfacesSet(this.type2);
                if (!this.isStatusOk()) {
                    return;
                }
                if (superinterfacesSet1 != null) break block19;
                if (superinterfacesSet2 == null) break block20;
                this.addDelta(this.getElementType(this.type1), 2, 15, this.currentDescriptorRestrictions, this.type1.getModifiers(), this.type2.getModifiers(), this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
                if (this.type1.isInterface()) {
                    Iterator iterator = superinterfacesSet2.iterator();
                    block2: while (iterator.hasNext()) {
                        IApiType type = (IApiType)iterator.next();
                        IApiMethod[] methods = type.getMethods();
                        int length = methods.length;
                        if (length == 0) continue;
                        int j = 0;
                        while (j < length) {
                            IApiMethod method = methods[j];
                            IApiMethod method3 = this.type1.getMethod(method.getName(), method.getSignature());
                            if (method3 == null) {
                                this.addDelta(this.getElementType(this.type1), 1, 69, this.currentDescriptorRestrictions, this.type1.getModifiers(), this.type2.getModifiers(), this.type1, this.type1.getName(), new String[]{Util.getDescriptorName(this.type1), type.getName(), this.getMethodDisplayName(method, type)});
                                continue block2;
                            }
                            ++j;
                        }
                    }
                }
                break block20;
            }
            if (superinterfacesSet2 == null) {
                this.addDelta(this.getElementType(this.type1), 2, 10, this.currentDescriptorRestrictions, this.type1.getModifiers(), this.type2.getModifiers(), this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
            } else {
                HashSet<String> names2 = new HashSet<String>();
                Iterator iterator = superinterfacesSet2.iterator();
                while (iterator.hasNext()) {
                    names2.add(((IApiType)iterator.next()).getName());
                }
                boolean contracted = false;
                Iterator iterator2 = superinterfacesSet1.iterator();
                while (iterator2.hasNext()) {
                    IApiType superInterfaceType = (IApiType)iterator2.next();
                    if (names2.remove(superInterfaceType.getName())) continue;
                    contracted = true;
                }
                if (contracted) {
                    this.addDelta(this.getElementType(this.type1), 2, 10, this.currentDescriptorRestrictions, this.type1.getModifiers(), this.type2.getModifiers(), this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
                    return;
                }
                if (names2.size() > 0) {
                    this.addDelta(this.getElementType(this.type1), 2, 15, this.currentDescriptorRestrictions, this.type1.getModifiers(), this.type2.getModifiers(), this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
                    if (this.type1.isInterface()) {
                        iterator2 = names2.iterator();
                        block6: while (iterator2.hasNext()) {
                            String interfaceName = (String)iterator2.next();
                            try {
                                IApiMethod[] methods;
                                int length;
                                IApiType type;
                                IApiTypeRoot interfaceClassFile = this.getType(interfaceName, this.component2, this.apiBaseline2);
                                if (interfaceClassFile == null || (type = interfaceClassFile.getStructure()) == null || (length = (methods = type.getMethods()).length) <= 0) continue;
                                int j = 0;
                                while (j < length) {
                                    IApiMethod method = methods[j];
                                    boolean found = false;
                                    Iterator iterator22 = superinterfacesSet1.iterator();
                                    while (iterator22.hasNext()) {
                                        IApiType superTypeDescriptor = (IApiType)iterator22.next();
                                        IApiMethod method3 = superTypeDescriptor.getMethod(method.getName(), method.getSignature());
                                        if (method3 == null) continue;
                                        found = true;
                                        break;
                                    }
                                    if (!found) {
                                        this.addDelta(this.getElementType(this.type1), 1, 69, this.currentDescriptorRestrictions, this.type1.getModifiers(), this.type2.getModifiers(), this.type1, this.type1.getName(), new String[]{Util.getDescriptorName(this.type1), type.getName(), this.getMethodDisplayName(method, type)});
                                        continue block6;
                                    }
                                    ++j;
                                }
                            }
                            catch (CoreException e) {
                                ApiPlugin.log(e);
                            }
                        }
                    }
                }
            }
        }
    }

    private void checkTypeMembers() throws CoreException {
        IApiType[] typeMembers = this.type1.getMemberTypes();
        IApiType[] typeMembers2 = this.type2.getMemberTypes();
        ArrayList<String> added = new ArrayList<String>(typeMembers2.length);
        int i = 0;
        while (i < typeMembers2.length) {
            added.add(typeMembers2[i].getName());
            ++i;
        }
        if (typeMembers.length > 0) {
            IApiType typeMember;
            if (typeMembers2.length == 0) {
                i = 0;
                while (i < typeMembers.length) {
                    try {
                        IApiType typeMember2 = typeMembers[i];
                        IApiDescription apiDescription = this.component.getApiDescription();
                        IApiAnnotations memberTypeElementDescription = apiDescription.resolveAnnotations(typeMember2.getHandle());
                        int memberTypeVisibility = 0;
                        if (memberTypeElementDescription != null) {
                            memberTypeVisibility = memberTypeElementDescription.getVisibility();
                        }
                        if ((memberTypeVisibility & this.visibilityModifiers) != 0 && (this.visibilityModifiers != 1 || !Util.isDefault(typeMember2.getModifiers()) && !Flags.isPrivate((int)typeMember2.getModifiers()))) {
                            this.addDelta(this.getElementType(this.type1), 3, 48, this.currentDescriptorRestrictions, typeMember2.getModifiers(), 0, this.type1, typeMember2.getName(), new String[]{typeMember2.getName().replace('$', '.'), Util.getComponentVersionsId(this.component2)});
                        }
                    }
                    catch (CoreException e) {
                        this.reportStatus(e);
                    }
                    ++i;
                }
                return;
            }
            ArrayList<IApiType> removedTypeMembers = new ArrayList<IApiType>();
            int i2 = 0;
            while (i2 < typeMembers.length) {
                typeMember = typeMembers[i2];
                IApiType typeMember2 = this.type2.getMemberType(typeMember.getSimpleName());
                if (typeMember2 == null) {
                    removedTypeMembers.add(typeMember);
                } else {
                    added.remove(typeMember2.getName());
                    try {
                        IApiDescription apiDescription = this.component.getApiDescription();
                        IApiAnnotations memberTypeElementDescription = apiDescription.resolveAnnotations(typeMember.getHandle());
                        int memberTypeVisibility = 0;
                        if (memberTypeElementDescription != null) {
                            memberTypeVisibility = memberTypeElementDescription.getVisibility();
                        }
                        if ((memberTypeVisibility & this.visibilityModifiers) != 0) {
                            int restrictions;
                            IApiDescription apiDescription2 = this.component2.getApiDescription();
                            IApiAnnotations memberTypeElementDescription2 = apiDescription2.resolveAnnotations(typeMember2.getHandle());
                            int memberTypeVisibility2 = 0;
                            if (memberTypeElementDescription2 != null) {
                                memberTypeVisibility2 = memberTypeElementDescription2.getVisibility();
                            }
                            String deltaComponentID = Util.getDeltaComponentVersionsId(this.component2);
                            int n = restrictions = memberTypeElementDescription2 != null ? memberTypeElementDescription2.getRestrictions() : 0;
                            if (Flags.isFinal((int)this.type2.getModifiers())) {
                                restrictions |= 2;
                            }
                            if (ClassFileComparator.isAPI(memberTypeVisibility, typeMember) && !ClassFileComparator.isAPI(memberTypeVisibility2, typeMember2)) {
                                this.addDelta(new Delta(deltaComponentID, this.getElementType(typeMember), 2, 11, restrictions | this.currentDescriptorRestrictions, typeMember.getModifiers(), typeMember2.getModifiers(), typeMember.getName(), typeMember.getName(), new String[]{typeMember.getName().replace('$', '.')}));
                            } else {
                                IApiTypeRoot memberType2;
                                ClassFileComparator comparator;
                                IDelta delta2;
                                if ((memberTypeVisibility2 & this.visibilityModifiers) == 0) {
                                    this.addDelta(new Delta(deltaComponentID, this.getElementType(typeMember), 2, 52, restrictions | this.currentDescriptorRestrictions, typeMember.getModifiers(), typeMember2.getModifiers(), typeMember.getName(), typeMember.getName(), new String[]{typeMember.getName().replace('$', '.')}));
                                }
                                if ((this.visibilityModifiers != 1 || !Util.isDefault(typeMember2.getModifiers()) && !Flags.isPrivate((int)typeMember2.getModifiers())) && (delta2 = (comparator = new ClassFileComparator(typeMember, memberType2 = this.component2.findTypeRoot(typeMember.getName()), this.component, this.component2, this.apiBaseline1, this.apiBaseline2, this.visibilityModifiers)).getDelta(null)) != null && delta2 != ApiComparator.NO_DELTA) {
                                    this.addDelta(delta2);
                                }
                            }
                        }
                    }
                    catch (CoreException e) {
                        this.reportStatus(e);
                    }
                }
                ++i2;
            }
            Iterator iterator = removedTypeMembers.iterator();
            while (iterator.hasNext()) {
                try {
                    typeMember = (IApiType)iterator.next();
                    IApiDescription apiDescription = this.component.getApiDescription();
                    IApiAnnotations memberTypeElementDescription = apiDescription.resolveAnnotations(typeMember.getHandle());
                    int memberTypeVisibility = 0;
                    if (memberTypeElementDescription != null) {
                        memberTypeVisibility = memberTypeElementDescription.getVisibility();
                    }
                    if ((memberTypeVisibility & this.visibilityModifiers) == 0 || this.visibilityModifiers == 1 && (Util.isDefault(typeMember.getModifiers()) || Flags.isPrivate((int)typeMember.getModifiers()))) continue;
                    this.addDelta(this.getElementType(this.type1), 3, 48, memberTypeElementDescription != null ? memberTypeElementDescription.getRestrictions() : 0, typeMember.getModifiers(), 0, this.type1, typeMember.getName(), new String[]{typeMember.getName().replace('$', '.'), Util.getComponentVersionsId(this.component2)});
                }
                catch (CoreException e) {
                    this.reportStatus(e);
                }
            }
        }
        Iterator iterator = added.iterator();
        while (iterator.hasNext()) {
            try {
                String name = (String)iterator.next();
                int index = name.lastIndexOf(36);
                IApiType typeMember = this.type2.getMemberType(name.substring(index + 1));
                IApiDescription apiDescription2 = this.component2.getApiDescription();
                IApiAnnotations memberTypeElementDescription2 = apiDescription2.resolveAnnotations(typeMember.getHandle());
                int memberTypeVisibility2 = 0;
                if (memberTypeElementDescription2 != null) {
                    memberTypeVisibility2 = memberTypeElementDescription2.getVisibility();
                }
                if ((memberTypeVisibility2 & this.visibilityModifiers) == 0 || this.visibilityModifiers == 1 && (Util.isDefault(typeMember.getModifiers()) || Flags.isPrivate((int)typeMember.getModifiers()))) continue;
                this.addDelta(this.getElementType(this.type1), 1, 48, this.currentDescriptorRestrictions, 0, typeMember.getModifiers(), this.type1, typeMember.getSimpleName(), typeMember.getSimpleName());
            }
            catch (CoreException e) {
                this.reportStatus(e);
            }
        }
    }

    private void checkGenericSignature(String signature1, String signature2, IApiMember element1, IApiMember element2) {
        block32: {
            block34: {
                int length;
                SignatureDescriptor signatureDescriptor;
                block35: {
                    block31: {
                        SignatureDescriptor signatureDescriptor2;
                        block33: {
                            if (signature1 != null) break block31;
                            if (signature2 == null) break block32;
                            signatureDescriptor2 = this.getSignatureDescriptor(signature2);
                            TypeParameterDescriptor[] typeParameterDescriptors = signatureDescriptor2.getTypeParameterDescriptors();
                            if (typeParameterDescriptors.length == 0) break block33;
                            this.addDelta(this.getElementType(element1), 1, 51, this.currentDescriptorRestrictions, element1.getModifiers(), element2.getModifiers(), this.type1, element1.getName(), new String[]{this.getDataFor(element1, this.type1)});
                            break block32;
                        }
                        if (signatureDescriptor2.getTypeArguments().length == 0) break block32;
                        this.addDelta(this.getElementType(element1), 1, 47, this.currentDescriptorRestrictions, element1.getModifiers(), element2.getModifiers(), this.type1, element1.getName(), new String[]{this.getDataFor(element1, this.type1)});
                        break block32;
                    }
                    if (signature2 != null) break block34;
                    signatureDescriptor = this.getSignatureDescriptor(signature1);
                    TypeParameterDescriptor[] typeParameterDescriptors = signatureDescriptor.getTypeParameterDescriptors();
                    length = typeParameterDescriptors.length;
                    if (length == 0) break block35;
                    int i = 0;
                    while (i < length) {
                        TypeParameterDescriptor typeParameterDescriptor = typeParameterDescriptors[i];
                        this.addDelta(this.getElementType(element1), 3, 49, this.currentDescriptorRestrictions, element1.getModifiers(), element2.getModifiers(), this.type1, element1.getName(), new String[]{this.getDataFor(element1, this.type1), typeParameterDescriptor.name});
                        ++i;
                    }
                    break block32;
                }
                String[] typeArguments = signatureDescriptor.getTypeArguments();
                length = typeArguments.length;
                if (length == 0) break block32;
                int i = 0;
                while (i < length) {
                    String typeArgument = typeArguments[i];
                    this.addDelta(this.getElementType(element1), 3, 68, this.currentDescriptorRestrictions, element1.getModifiers(), element2.getModifiers(), this.type1, element1.getName(), new String[]{this.getDataFor(element1, this.type1), typeArgument});
                    ++i;
                }
                break block32;
            }
            SignatureDescriptor signatureDescriptor = this.getSignatureDescriptor(signature1);
            SignatureDescriptor signatureDescriptor2 = this.getSignatureDescriptor(signature2);
            TypeParameterDescriptor[] typeParameterDescriptors1 = signatureDescriptor.getTypeParameterDescriptors();
            TypeParameterDescriptor[] typeParameterDescriptors2 = signatureDescriptor2.getTypeParameterDescriptors();
            int length = typeParameterDescriptors1.length;
            int length2 = typeParameterDescriptors2.length;
            int min = length;
            int max = length2;
            if (length > length2) {
                min = length2;
                max = length;
            }
            int i = 0;
            while (i < min) {
                TypeParameterDescriptor parameterDescriptor1 = typeParameterDescriptors1[i];
                TypeParameterDescriptor parameterDescriptor2 = typeParameterDescriptors2[i];
                String name = parameterDescriptor1.name;
                if (!name.equals(parameterDescriptor2.name)) {
                    this.addDelta(10, 2, 50, this.currentDescriptorRestrictions, element1.getModifiers(), element2.getModifiers(), this.type1, name, new String[]{this.getDataFor(element1, this.type1), name});
                }
                if (parameterDescriptor1.classBound == null) {
                    if (parameterDescriptor2.classBound != null) {
                        this.addDelta(10, 1, 6, this.currentDescriptorRestrictions, element1.getModifiers(), element2.getModifiers(), this.type1, name, new String[]{this.getDataFor(element1, this.type1), name});
                    }
                } else if (parameterDescriptor2.classBound == null) {
                    this.addDelta(10, 3, 6, this.currentDescriptorRestrictions, element1.getModifiers(), element2.getModifiers(), this.type1, name, new String[]{this.getDataFor(element1, this.type1), name});
                } else if (!parameterDescriptor1.classBound.equals(parameterDescriptor2.classBound)) {
                    this.addDelta(10, 2, 6, this.currentDescriptorRestrictions, element1.getModifiers(), element2.getModifiers(), this.type1, name, new String[]{this.getDataFor(element1, this.type1), name});
                }
                List interfaceBounds1 = parameterDescriptor1.interfaceBounds;
                List interfaceBounds2 = parameterDescriptor2.interfaceBounds;
                if (interfaceBounds1 == null) {
                    if (interfaceBounds2 != null) {
                        Iterator iterator = interfaceBounds2.iterator();
                        while (iterator.hasNext()) {
                            this.addDelta(10, 1, 23, this.currentDescriptorRestrictions, element1.getModifiers(), element2.getModifiers(), this.type1, name, new String[]{this.getDataFor(element1, this.type1), name, (String)iterator.next()});
                        }
                    }
                } else if (interfaceBounds2 == null) {
                    Iterator iterator = interfaceBounds1.iterator();
                    while (iterator.hasNext()) {
                        this.addDelta(10, 3, 23, this.currentDescriptorRestrictions, element1.getModifiers(), element2.getModifiers(), this.type1, name, new String[]{this.getDataFor(element1, this.type1), name, (String)iterator.next()});
                    }
                } else {
                    int size1 = interfaceBounds1.size();
                    int size2 = interfaceBounds2.size();
                    int boundsMin = size1;
                    int boundsMax = size2;
                    if (size1 > size2) {
                        boundsMin = size2;
                        boundsMax = size1;
                    }
                    int index = 0;
                    while (index < boundsMin) {
                        String currentInterfaceBound = (String)interfaceBounds1.get(index);
                        if (!currentInterfaceBound.equals(interfaceBounds2.get(index))) {
                            this.addDelta(10, 2, 23, this.currentDescriptorRestrictions, element1.getModifiers(), element2.getModifiers(), this.type1, name, new String[]{this.getDataFor(element1, this.type1), name, currentInterfaceBound});
                        }
                        ++index;
                    }
                    if (boundsMin != boundsMax) {
                        boolean added = boundsMax == size2;
                        while (index < boundsMax) {
                            String currentInterfaceBound = added ? (String)interfaceBounds2.get(index) : (String)interfaceBounds1.get(index);
                            this.addDelta(10, added ? 1 : 3, 23, this.currentDescriptorRestrictions, element1.getModifiers(), element2.getModifiers(), this.type1, element1.getName(), new String[]{this.getDataFor(element1, this.type1), name, currentInterfaceBound});
                            ++index;
                        }
                    }
                }
                ++i;
            }
            if (min != max) {
                boolean added = max == length2;
                while (i < max) {
                    TypeParameterDescriptor currentTypeParameter = added ? typeParameterDescriptors2[i] : typeParameterDescriptors1[i];
                    this.addDelta(this.getElementType(element1), added ? 1 : 3, 49, this.currentDescriptorRestrictions, element1.getModifiers(), element2.getModifiers(), this.type1, element1.getName(), new String[]{this.getDataFor(element1, this.type1), currentTypeParameter.name});
                    ++i;
                }
            }
            if (length2 > 0 || length > 0) {
                return;
            }
            String[] typeArguments = signatureDescriptor.getTypeArguments();
            String[] typeArguments2 = signatureDescriptor2.getTypeArguments();
            length = typeArguments.length;
            length2 = typeArguments2.length;
            min = length;
            max = length2;
            if (length > length2) {
                min = length2;
                max = length;
            }
            i = 0;
            while (i < min) {
                String currentTypeArgument = typeArguments[i];
                String newTypeArgument = typeArguments2[i];
                if (!currentTypeArgument.equals(newTypeArgument)) {
                    this.addDelta(this.getElementType(element1), 2, 68, this.currentDescriptorRestrictions, element1.getModifiers(), element2.getModifiers(), this.type1, element1.getName(), new String[]{this.getDataFor(element1, this.type1), currentTypeArgument, newTypeArgument});
                }
                ++i;
            }
            if (min != max) {
                boolean added = max == length2;
                while (i < max) {
                    String currentTypeArgument = added ? typeArguments2[i] : typeArguments[i];
                    this.addDelta(this.getElementType(element1), added ? 1 : 3, 68, this.currentDescriptorRestrictions, element1.getModifiers(), element2.getModifiers(), this.type1, element1.getName(), new String[]{this.getDataFor(element1, this.type1), currentTypeArgument});
                    ++i;
                }
            }
        }
    }

    private void collectAllInterfaces(IApiType type, Set set) {
        try {
            String superclassName;
            IApiType[] interfaces = type.getSuperInterfaces();
            if (interfaces != null) {
                int i = 0;
                while (i < interfaces.length) {
                    IApiType anInterface = interfaces[i];
                    int visibility = 2;
                    IApiComponent ifaceComponent = anInterface.getApiComponent();
                    IApiDescription apiDescription = ifaceComponent.getApiDescription();
                    IApiAnnotations elementDescription = apiDescription.resolveAnnotations(anInterface.getHandle());
                    if (elementDescription != null) {
                        visibility = elementDescription.getVisibility();
                    }
                    if ((visibility & this.visibilityModifiers) != 0) {
                        set.add(anInterface);
                    }
                    this.collectAllInterfaces(anInterface, set);
                    ++i;
                }
            }
            if ((superclassName = type.getSuperclassName()) != null && !Util.isJavaLangObject(superclassName)) {
                IApiType superclass = type.getSuperclass();
                this.collectAllInterfaces(superclass, set);
            }
        }
        catch (CoreException e) {
            this.reportStatus(e);
        }
    }

    private String getDataFor(IApiMember member, IApiType type) {
        switch (member.getType()) {
            case 2: {
                if (((IApiType)member).isMemberType()) {
                    return member.getName().replace('$', '.');
                }
                return member.getName();
            }
            case 6: {
                StringBuffer buffer = new StringBuffer();
                buffer.append(type.getName()).append('.').append(this.getMethodDisplayName((IApiMethod)member, type));
                return String.valueOf(buffer);
            }
            case 5: {
                StringBuffer buffer = new StringBuffer();
                buffer.append(type.getName()).append('.').append(member.getName());
                return String.valueOf(buffer);
            }
        }
        return null;
    }

    private Delta createDelta() {
        return new Delta();
    }

    public IDelta getDelta(IProgressMonitor monitor) {
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            this.delta = this.createDelta();
            int typeAccess = this.type1.getModifiers();
            int typeAccess2 = this.type2.getModifiers();
            IApiDescription component2ApiDescription = this.component2.getApiDescription();
            IApiAnnotations elementDescription2 = component2ApiDescription.resolveAnnotations(this.type2.getHandle());
            this.initialDescriptorRestrictions = 0;
            this.currentDescriptorRestrictions = 0;
            if (elementDescription2 != null) {
                int restrictions2 = elementDescription2.getRestrictions();
                IApiDescription apiDescription = this.component.getApiDescription();
                if (this.component.hasApiDescription()) {
                    int restrictions = 0;
                    IApiAnnotations componentApiDescription = apiDescription.resolveAnnotations(this.type1.getHandle());
                    if (componentApiDescription != null) {
                        this.initialDescriptorRestrictions = restrictions = componentApiDescription.getRestrictions();
                    }
                    if (restrictions2 != restrictions) {
                        if (this.type1.isInterface()) {
                            if (RestrictionModifiers.isImplementRestriction(restrictions2) && !RestrictionModifiers.isImplementRestriction(restrictions) || RestrictionModifiers.isExtendRestriction(restrictions2) && !RestrictionModifiers.isExtendRestriction(restrictions)) {
                                this.addDelta(this.getElementType(this.type1), 1, 37, restrictions2, typeAccess, typeAccess2, this.type2, this.type2.getName(), Util.getDescriptorName(this.type1));
                            }
                        } else {
                            boolean reportChangedRestrictions = false;
                            if (!Flags.isFinal((int)typeAccess2) && !Flags.isFinal((int)typeAccess) && RestrictionModifiers.isExtendRestriction(restrictions2) && !RestrictionModifiers.isExtendRestriction(restrictions)) {
                                reportChangedRestrictions = true;
                                this.addDelta(this.getElementType(this.type1), 1, 37, restrictions2, typeAccess, typeAccess2, this.type2, this.type2.getName(), Util.getDescriptorName(this.type1));
                            }
                            if (!(reportChangedRestrictions || Flags.isAbstract((int)typeAccess2) || Flags.isAbstract((int)typeAccess) || !RestrictionModifiers.isInstantiateRestriction(restrictions2) || RestrictionModifiers.isInstantiateRestriction(restrictions))) {
                                this.addDelta(this.getElementType(this.type1), 1, 37, restrictions2, typeAccess, typeAccess2, this.type2, this.type2.getName(), Util.getDescriptorName(this.type1));
                            }
                        }
                    }
                }
                this.currentDescriptorRestrictions = restrictions2;
            }
            if (Flags.isFinal((int)typeAccess2)) {
                this.currentDescriptorRestrictions |= 2;
            }
            if (Flags.isFinal((int)typeAccess)) {
                this.initialDescriptorRestrictions |= 2;
            }
            if (Flags.isDeprecated((int)typeAccess)) {
                if (!Flags.isDeprecated((int)typeAccess2)) {
                    this.addDelta(this.getElementType(this.type1), 3, 72, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
                }
            } else if (Flags.isDeprecated((int)typeAccess2)) {
                this.addDelta(this.getElementType(this.type1), 1, 72, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
            }
            if (Flags.isProtected((int)typeAccess)) {
                if (Flags.isPrivate((int)typeAccess2) || Util.isDefault(typeAccess2)) {
                    this.addDelta(this.getElementType(this.type1), 2, 11, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
                    Delta delta = this.delta;
                    return delta;
                }
                if (Flags.isPublic((int)typeAccess2)) {
                    this.addDelta(this.getElementType(this.type1), 2, 22, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
                    Delta delta = this.delta;
                    return delta;
                }
            } else {
                if (Flags.isPublic((int)typeAccess) && (Flags.isProtected((int)typeAccess2) || Flags.isPrivate((int)typeAccess2) || Util.isDefault(typeAccess2))) {
                    this.addDelta(this.getElementType(this.type1), 2, 11, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
                    Delta delta = this.delta;
                    return delta;
                }
                if (Util.isDefault(typeAccess) && (Flags.isPublic((int)typeAccess2) || Flags.isProtected((int)typeAccess2))) {
                    this.addDelta(this.getElementType(this.type1), 2, 22, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
                    Delta delta = this.delta;
                    return delta;
                }
                if (Flags.isPrivate((int)typeAccess) && (Util.isDefault(typeAccess2) || Flags.isPublic((int)typeAccess2) || Flags.isProtected((int)typeAccess2))) {
                    this.addDelta(this.getElementType(this.type1), 2, 22, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
                    Delta delta = this.delta;
                    return delta;
                }
            }
            if (Flags.isAnnotation((int)typeAccess)) {
                if (!Flags.isAnnotation((int)typeAccess2)) {
                    if (Flags.isInterface((int)typeAccess2)) {
                        this.addDelta(1, 2, 41, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), new String[]{Util.getDescriptorName(this.type1), Integer.toString(1), Integer.toString(8)});
                    } else if (Flags.isEnum((int)typeAccess2)) {
                        this.addDelta(1, 2, 41, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), new String[]{Util.getDescriptorName(this.type1), Integer.toString(1), Integer.toString(6)});
                    } else {
                        this.addDelta(1, 2, 41, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), new String[]{Util.getDescriptorName(this.type1), Integer.toString(1), Integer.toString(4)});
                    }
                    Delta delta = this.delta;
                    return delta;
                }
            } else if (Flags.isInterface((int)typeAccess)) {
                if (Flags.isAnnotation((int)typeAccess2)) {
                    this.addDelta(8, 2, 41, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), new String[]{Util.getDescriptorName(this.type1), Integer.toString(8), Integer.toString(1)});
                    Delta delta = this.delta;
                    return delta;
                }
                if (!Flags.isInterface((int)typeAccess2)) {
                    if (Flags.isEnum((int)typeAccess2)) {
                        this.addDelta(8, 2, 41, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), new String[]{Util.getDescriptorName(this.type1), Integer.toString(8), Integer.toString(6)});
                    } else {
                        this.addDelta(8, 2, 41, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), new String[]{Util.getDescriptorName(this.type1), Integer.toString(8), Integer.toString(4)});
                    }
                    Delta delta = this.delta;
                    return delta;
                }
            } else if (Flags.isEnum((int)typeAccess)) {
                if (!Flags.isEnum((int)typeAccess2)) {
                    if (Flags.isAnnotation((int)typeAccess2)) {
                        this.addDelta(6, 2, 41, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), new String[]{Util.getDescriptorName(this.type1), Integer.toString(6), Integer.toString(1)});
                    } else if (Flags.isInterface((int)typeAccess2)) {
                        this.addDelta(6, 2, 41, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), new String[]{Util.getDescriptorName(this.type1), Integer.toString(6), Integer.toString(8)});
                    } else {
                        this.addDelta(6, 2, 41, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), new String[]{Util.getDescriptorName(this.type1), Integer.toString(6), Integer.toString(4)});
                    }
                    Delta delta = this.delta;
                    return delta;
                }
            } else if (!Util.isClass(typeAccess2)) {
                if (Flags.isAnnotation((int)typeAccess2)) {
                    this.addDelta(4, 2, 41, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), new String[]{Util.getDescriptorName(this.type1), Integer.toString(4), Integer.toString(1)});
                } else if (Flags.isInterface((int)typeAccess2)) {
                    this.addDelta(4, 2, 41, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), new String[]{Util.getDescriptorName(this.type1), Integer.toString(4), Integer.toString(8)});
                } else {
                    this.addDelta(4, 2, 41, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), new String[]{Util.getDescriptorName(this.type1), Integer.toString(4), Integer.toString(6)});
                }
                Delta delta = this.delta;
                return delta;
            }
            if (Flags.isStatic((int)typeAccess)) {
                if (!Flags.isStatic((int)typeAccess2)) {
                    this.addDelta(this.getElementType(this.type1), 2, 38, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
                }
            } else if (Flags.isStatic((int)typeAccess2)) {
                this.addDelta(this.getElementType(this.type1), 2, 33, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
            }
            this.checkSuperclass();
            this.checkSuperInterfaces();
            IApiField[] fields1 = this.type1.getFields();
            IApiField[] fields2 = this.type2.getFields();
            HashSet<String> addedFields = new HashSet<String>(fields2.length);
            int i = 0;
            while (i < fields2.length) {
                addedFields.add(fields2[i].getName());
                ++i;
            }
            i = 0;
            while (i < fields1.length) {
                addedFields.remove(fields1[i].getName());
                this.getDeltaForField(fields1[i]);
                ++i;
            }
            Iterator iterator = addedFields.iterator();
            while (iterator.hasNext()) {
                IApiField field = this.type2.getField((String)iterator.next());
                this.reportFieldAddition(field, this.type2);
            }
            IApiMethod[] methods1 = this.type1.getMethods();
            IApiMethod[] methods2 = this.type2.getMethods();
            HashSet<IMemberDescriptor> addedMethods = new HashSet<IMemberDescriptor>(methods2.length);
            int i2 = 0;
            while (i2 < methods2.length) {
                if (!methods2[i2].isSynthetic()) {
                    addedMethods.add(methods2[i2].getHandle());
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < methods1.length) {
                addedMethods.remove(methods1[i2].getHandle());
                this.getDeltaForMethod(methods1[i2]);
                ++i2;
            }
            Iterator iterator2 = addedMethods.iterator();
            while (iterator2.hasNext()) {
                IMethodDescriptor md = (IMethodDescriptor)iterator2.next();
                IApiMethod method = this.type2.getMethod(md.getName(), md.getSignature());
                this.reportMethodAddition(method, this.type2);
            }
            if (Flags.isAbstract((int)typeAccess)) {
                if (!Flags.isAbstract((int)typeAccess2)) {
                    this.addDelta(this.getElementType(this.type1), 2, 1, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
                }
            } else if (Flags.isAbstract((int)typeAccess2) && !RestrictionModifiers.isInstantiateRestriction(this.initialDescriptorRestrictions)) {
                this.addDelta(this.getElementType(this.type1), 2, 30, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
            }
            if (Flags.isFinal((int)typeAccess)) {
                if (!Flags.isFinal((int)typeAccess2)) {
                    this.addDelta(this.getElementType(this.type1), 2, 18, this.currentDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
                }
            } else if (Flags.isFinal((int)typeAccess2)) {
                this.addDelta(this.getElementType(this.type1), 2, 31, this.initialDescriptorRestrictions, typeAccess, typeAccess2, this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
            }
            String signature1 = this.type1.getGenericSignature();
            String signature2 = this.type2.getGenericSignature();
            this.checkGenericSignature(signature1, signature2, this.type1, this.type2);
            this.checkTypeMembers();
            IDelta iDelta = this.delta.isEmpty() ? ApiComparator.NO_DELTA : this.delta;
            return iDelta;
        }
        catch (CoreException e) {
            this.reportStatus(e);
            return null;
        }
        finally {
            localmonitor.done();
        }
    }

    private void getDeltaForField(IApiField field) {
        IApiDescription apiDescription;
        int access = field.getModifiers();
        if (Flags.isSynthetic((int)access)) {
            return;
        }
        String name = field.getName();
        IApiField field2 = this.type2.getField(name);
        if (field2 == null) {
            if (Flags.isPrivate((int)access) || Util.isDefault(access)) {
                this.addDelta(this.getElementType(this.type1), 3, 16, this.currentDescriptorRestrictions, access, 0, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
            } else {
                boolean found = false;
                if (this.component2 != null) {
                    IApiType superTypeDescriptor;
                    Iterator iterator;
                    if (this.type1.isInterface()) {
                        Set interfacesSet = this.getInterfacesSet(this.type2);
                        if (interfacesSet != null) {
                            iterator = interfacesSet.iterator();
                            while (iterator.hasNext()) {
                                superTypeDescriptor = (IApiType)iterator.next();
                                IApiField field3 = superTypeDescriptor.getField(name);
                                if (field3 == null) continue;
                                this.addDelta(this.getElementType(this.type1), 3, 17, this.currentDescriptorRestrictions, access, field3.getModifiers(), this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
                                found = true;
                                break;
                            }
                        }
                    } else {
                        List superclassList = this.getSuperclassList(this.type2);
                        if (superclassList != null && this.isStatusOk()) {
                            iterator = superclassList.iterator();
                            while (iterator.hasNext()) {
                                int access3;
                                superTypeDescriptor = (IApiType)iterator.next();
                                IApiField field3 = superTypeDescriptor.getField(name);
                                if (field3 == null || !Flags.isPublic((int)(access3 = field3.getModifiers())) && !Flags.isProtected((int)access3)) continue;
                                this.addDelta(this.getElementType(this.type1), 3, 17, this.currentDescriptorRestrictions, access, field3.getModifiers(), this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
                                found = true;
                                break;
                            }
                        }
                    }
                }
                if (!found) {
                    if (this.visibilityModifiers == 1 && this.component.hasApiDescription()) {
                        int restrictions;
                        IApiAnnotations apiAnnotations;
                        IApiDescription apiDescription2 = null;
                        try {
                            apiDescription2 = this.component.getApiDescription();
                        }
                        catch (CoreException e) {
                            this.reportStatus(e);
                        }
                        if (apiDescription2 != null && (apiAnnotations = apiDescription2.resolveAnnotations(field.getHandle())) != null && RestrictionModifiers.isReferenceRestriction(restrictions = apiAnnotations.getRestrictions())) {
                            return;
                        }
                    }
                    if (field.isEnumConstant()) {
                        this.addDelta(this.getElementType(this.type1), 3, 12, this.currentDescriptorRestrictions, this.type1.getModifiers(), this.type2.getModifiers(), this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
                        return;
                    }
                    this.addDelta(this.getElementType(this.type1), 3, 16, this.currentDescriptorRestrictions, access, 0, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
                }
            }
            return;
        }
        int restrictions = 0;
        int referenceRestrictions = 0;
        int access2 = field2.getModifiers();
        if (this.component2.hasApiDescription()) {
            try {
                apiDescription = this.component2.getApiDescription();
                IApiAnnotations resolvedAPIDescription = apiDescription.resolveAnnotations(field2.getHandle());
                if (resolvedAPIDescription != null) {
                    restrictions = resolvedAPIDescription.getRestrictions();
                }
            }
            catch (CoreException coreException) {}
        }
        if (this.visibilityModifiers == 1 && this.component.hasApiDescription()) {
            IApiAnnotations apiAnnotations;
            apiDescription = null;
            try {
                apiDescription = this.component.getApiDescription();
            }
            catch (CoreException e) {
                this.reportStatus(e);
            }
            if (apiDescription != null && (apiAnnotations = apiDescription.resolveAnnotations(field.getHandle())) != null) {
                referenceRestrictions = apiAnnotations.getRestrictions();
            }
            if (RestrictionModifiers.isReferenceRestriction(referenceRestrictions)) {
                if (!RestrictionModifiers.isReferenceRestriction(restrictions)) {
                    if (field2.isEnumConstant()) {
                        this.addDelta(this.getElementType(this.type2), 1, 12, this.currentDescriptorRestrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type2), name});
                    } else {
                        this.addDelta(this.getElementType(this.type2), 1, 16, this.currentDescriptorRestrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type2), name});
                    }
                    return;
                }
            } else if (RestrictionModifiers.isReferenceRestriction(restrictions)) {
                if ((Flags.isPublic((int)access2) || Flags.isProtected((int)access2)) && (Flags.isPublic((int)access) || Flags.isProtected((int)access)) && this.visibilityModifiers == 1) {
                    this.addDelta(this.getElementType(this.type2), 3, field2.isEnumConstant() ? 64 : 61, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type2), name});
                }
                return;
            }
        }
        restrictions |= this.currentDescriptorRestrictions;
        if (!field.getSignature().equals(field2.getSignature())) {
            this.addDelta(7, 2, 46, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
        } else {
            String signature1 = field.getGenericSignature();
            String signature2 = field2.getGenericSignature();
            this.checkGenericSignature(signature1, signature2, field, field2);
        }
        boolean changeFinalToNonFinal = false;
        if (Flags.isProtected((int)access)) {
            if (Flags.isPrivate((int)access2) || Util.isDefault(access2)) {
                this.addDelta(7, 2, 11, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
            } else if (Flags.isPublic((int)access2)) {
                this.addDelta(7, 2, 22, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
            }
        } else if (Flags.isPublic((int)access) && (Flags.isProtected((int)access2) || Flags.isPrivate((int)access2) || Util.isDefault(access2))) {
            this.addDelta(7, 2, 11, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
        } else if (Flags.isPrivate((int)access) && (Flags.isProtected((int)access2) || Util.isDefault(access2) || Flags.isPublic((int)access2))) {
            this.addDelta(7, 2, 22, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
        } else if (Util.isDefault(access) && (Flags.isProtected((int)access2) || Flags.isPublic((int)access2))) {
            this.addDelta(7, 2, 22, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
        }
        if (Flags.isFinal((int)access)) {
            if (!Flags.isFinal((int)access2)) {
                if (!Flags.isStatic((int)access2)) {
                    this.addDelta(7, 2, 19, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
                } else if (field.getConstantValue() != null) {
                    changeFinalToNonFinal = true;
                    this.addDelta(7, 2, 20, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
                } else {
                    this.addDelta(7, 2, 21, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
                }
            }
        } else if (Flags.isFinal((int)access2)) {
            this.addDelta(7, 2, 31, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
        }
        if (Flags.isStatic((int)access)) {
            if (!Flags.isStatic((int)access2)) {
                this.addDelta(7, 2, 38, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
            }
        } else if (Flags.isStatic((int)access2)) {
            this.addDelta(7, 2, 33, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
        }
        if (Flags.isTransient((int)access)) {
            if (!Flags.isTransient((int)access2)) {
                this.addDelta(7, 2, 45, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
            }
        } else if (Flags.isTransient((int)access2)) {
            this.addDelta(7, 2, 35, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
        }
        if (Flags.isVolatile((int)access)) {
            if (!Flags.isVolatile((int)access2)) {
                this.addDelta(7, 2, 58, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
            }
        } else if (Flags.isVolatile((int)access2)) {
            this.addDelta(7, 2, 57, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
        }
        if (Flags.isDeprecated((int)access)) {
            if (!Flags.isDeprecated((int)access2)) {
                this.addDelta(7, 3, 72, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
            }
        } else if (Flags.isDeprecated((int)access2)) {
            this.addDelta(7, 1, 72, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name});
        }
        if (field.getConstantValue() != null) {
            if (field2.getConstantValue() == null) {
                if (!changeFinalToNonFinal) {
                    this.addDelta(7, 3, 54, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name, String.valueOf(field.getConstantValue())});
                }
            } else if (!field.getConstantValue().equals(field2.getConstantValue())) {
                this.addDelta(7, 2, 54, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name, String.valueOf(field.getConstantValue())});
            }
        } else if (field2.getConstantValue() != null) {
            this.addDelta(7, 1, 54, restrictions, access, access2, this.type1, name, new String[]{Util.getDescriptorName(this.type1), name, String.valueOf(field2.getConstantValue())});
        }
    }

    private void getDeltaForMethod(IApiMethod method) {
        String exceptionName;
        int access = method.getModifiers();
        if (Flags.isSynthetic((int)access)) {
            return;
        }
        String name = method.getName();
        String descriptor = method.getSignature();
        String key = this.getKeyForMethod(method, this.type1);
        IApiMethod method2 = this.type2.getMethod(name, descriptor);
        String methodDisplayName = this.getMethodDisplayName(method, this.type1);
        if (method2 == null) {
            if (method.isClassInitializer()) {
                this.addDelta(this.getElementType(this.type1), 3, 7, this.currentDescriptorRestrictions, access, 0, this.type1, this.type1.getName(), Util.getDescriptorName(this.type1));
                return;
            }
            if (Flags.isPrivate((int)access) || Util.isDefault(access)) {
                this.addDelta(this.getElementType(this.type1), 3, this.getTargetType(method), Flags.isAbstract((int)this.type2.getModifiers()) ? this.currentDescriptorRestrictions | 4 : this.currentDescriptorRestrictions, access, 0, this.type1, this.getKeyForMethod(method, this.type1), new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
                return;
            }
            boolean found = false;
            if (this.component2 != null && !method.isConstructor()) {
                IApiType superTypeDescriptor;
                Iterator iterator;
                if (this.type1.isInterface()) {
                    Set interfacesSet = this.getInterfacesSet(this.type2);
                    if (interfacesSet != null && this.isStatusOk()) {
                        iterator = interfacesSet.iterator();
                        while (iterator.hasNext()) {
                            superTypeDescriptor = (IApiType)iterator.next();
                            IApiMethod method3 = superTypeDescriptor.getMethod(name, descriptor);
                            if (method3 == null) continue;
                            this.addDelta(this.getElementType(this.type1), 3, 26, this.currentDescriptorRestrictions, access, method3.getModifiers(), this.type1, this.getKeyForMethod(method3, this.type1), new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
                            found = true;
                            break;
                        }
                    }
                } else {
                    List superclassList = this.getSuperclassList(this.type2, true);
                    if (superclassList != null && this.isStatusOk()) {
                        iterator = superclassList.iterator();
                        while (iterator.hasNext()) {
                            int access3;
                            superTypeDescriptor = (IApiType)iterator.next();
                            IApiMethod method3 = superTypeDescriptor.getMethod(name, descriptor);
                            if (method3 == null || !Flags.isPublic((int)(access3 = method3.getModifiers())) && !Flags.isProtected((int)access3)) continue;
                            this.addDelta(this.getElementType(this.type1), 3, 26, this.currentDescriptorRestrictions, access, access3, this.type1, this.getKeyForMethod(method3, this.type1), new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
                            found = true;
                            break;
                        }
                    }
                }
            }
            if (!found) {
                if (this.visibilityModifiers == 1 && this.component.hasApiDescription()) {
                    int restrictions;
                    IApiAnnotations apiAnnotations;
                    IApiDescription apiDescription = null;
                    try {
                        apiDescription = this.component.getApiDescription();
                    }
                    catch (CoreException e) {
                        this.reportStatus(e);
                    }
                    if (apiDescription != null && (apiAnnotations = apiDescription.resolveAnnotations(method.getHandle())) != null && RestrictionModifiers.isReferenceRestriction(restrictions = apiAnnotations.getRestrictions())) {
                        return;
                    }
                }
                if (this.type1.isAnnotation()) {
                    this.addDelta(this.getElementType(this.type1), 3, method.getDefaultValue() != null ? 27 : 28, this.currentDescriptorRestrictions, access, 0, this.type1, this.getKeyForMethod(method, this.type1), new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
                } else {
                    int restrictions = this.currentDescriptorRestrictions;
                    if (RestrictionModifiers.isExtendRestriction(this.initialDescriptorRestrictions) && !RestrictionModifiers.isExtendRestriction(this.currentDescriptorRestrictions)) {
                        restrictions = this.initialDescriptorRestrictions;
                    }
                    this.addDelta(this.getElementType(this.type1), 3, this.getTargetType(method), Flags.isAbstract((int)this.type2.getModifiers()) ? restrictions | 4 : restrictions, access, 0, this.type1, this.getKeyForMethod(method, this.type1), new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
                }
            }
            return;
        }
        int restrictions = this.currentDescriptorRestrictions;
        if (this.component2.hasApiDescription()) {
            try {
                IApiDescription apiDescription = this.component2.getApiDescription();
                IApiAnnotations resolvedAPIDescription = apiDescription.resolveAnnotations(method2.getHandle());
                if (resolvedAPIDescription != null) {
                    restrictions |= resolvedAPIDescription.getRestrictions();
                }
            }
            catch (CoreException coreException) {}
        }
        int referenceRestrictions = this.initialDescriptorRestrictions;
        int access2 = method2.getModifiers();
        if (this.component.hasApiDescription()) {
            IApiAnnotations apiAnnotations;
            IApiDescription apiDescription = null;
            try {
                apiDescription = this.component.getApiDescription();
            }
            catch (CoreException e) {
                this.reportStatus(e);
            }
            if (apiDescription != null && (apiAnnotations = apiDescription.resolveAnnotations(method.getHandle())) != null) {
                referenceRestrictions |= apiAnnotations.getRestrictions();
            }
        }
        if (this.visibilityModifiers == 1 && this.component.hasApiDescription()) {
            if (RestrictionModifiers.isReferenceRestriction(referenceRestrictions)) {
                if (!RestrictionModifiers.isReferenceRestriction(restrictions)) {
                    if (method.isConstructor()) {
                        this.addDelta(this.getElementType(this.type2), 1, 8, this.currentDescriptorRestrictions, access, access2, this.type1, this.getKeyForMethod(method, this.type2), new String[]{Util.getDescriptorName(this.type2), methodDisplayName});
                    } else if (this.type2.isAnnotation()) {
                        if (method.getDefaultValue() != null) {
                            this.addDelta(this.getElementType(this.type2), 1, 27, this.currentDescriptorRestrictions, access, access2, this.type1, this.getKeyForMethod(method, this.type2), new String[]{Util.getDescriptorName(this.type2), methodDisplayName});
                        } else {
                            this.addDelta(this.getElementType(this.type2), 1, 28, this.currentDescriptorRestrictions, access, access2, this.type1, this.getKeyForMethod(method, this.type2), new String[]{Util.getDescriptorName(this.type2), methodDisplayName});
                        }
                    } else {
                        boolean found = false;
                        if (this.component2 != null) {
                            if (this.type1.isInterface()) {
                                Set interfacesSet = this.getInterfacesSet(this.type2);
                                if (interfacesSet != null && this.isStatusOk()) {
                                    Iterator iterator = interfacesSet.iterator();
                                    while (iterator.hasNext()) {
                                        IApiType superTypeDescriptor = (IApiType)iterator.next();
                                        IApiMethod method3 = superTypeDescriptor.getMethod(name, descriptor);
                                        if (method3 == null) continue;
                                        found = true;
                                        break;
                                    }
                                }
                            } else {
                                List superclassList = this.getSuperclassList(this.type2, true);
                                if (superclassList != null) {
                                    Iterator iterator = superclassList.iterator();
                                    while (iterator.hasNext()) {
                                        int access3;
                                        IApiType superTypeDescriptor = (IApiType)iterator.next();
                                        IApiMethod method3 = superTypeDescriptor.getMethod(name, descriptor);
                                        if (method3 == null || !Flags.isPublic((int)(access3 = method3.getModifiers())) && !Flags.isProtected((int)access3)) continue;
                                        found = true;
                                        break;
                                    }
                                }
                            }
                        }
                        this.addDelta(this.getElementType(this.type2), 1, found ? 36 : 25, this.currentDescriptorRestrictions, access, access2, this.type1, this.getKeyForMethod(method, this.type2), new String[]{Util.getDescriptorName(this.type2), methodDisplayName});
                    }
                    return;
                }
            } else if (RestrictionModifiers.isReferenceRestriction(restrictions) && (Flags.isPublic((int)access2) || Flags.isProtected((int)access2))) {
                if (this.type2.isAnnotation()) {
                    this.addDelta(this.getElementType(this.type2), 3, method.getDefaultValue() != null ? 65 : 66, this.currentDescriptorRestrictions, access, access2, this.type1, this.getKeyForMethod(method2, this.type2), new String[]{Util.getDescriptorName(this.type2), methodDisplayName});
                } else if (Flags.isPublic((int)access) || Flags.isProtected((int)access)) {
                    this.addDelta(this.getElementType(this.type2), 3, method.isConstructor() ? 63 : 62, Flags.isAbstract((int)this.type2.getModifiers()) ? this.currentDescriptorRestrictions | 4 : this.currentDescriptorRestrictions, access, access2, this.type1, this.getKeyForMethod(method2, this.type2), new String[]{Util.getDescriptorName(this.type2), methodDisplayName});
                }
                return;
            }
        }
        if (!(!this.component.hasApiDescription() || method.isConstructor() || method.isClassInitializer() || this.type1.isInterface() || this.type1.isAnnotation() || restrictions == referenceRestrictions || Flags.isFinal((int)access2) || !RestrictionModifiers.isOverrideRestriction(restrictions) || RestrictionModifiers.isOverrideRestriction(referenceRestrictions))) {
            this.addDelta(this.getElementType(method), 1, 37, restrictions, access, access2, this.type1, this.getKeyForMethod(method2, this.type2), new String[]{Util.getDescriptorName(this.type2), methodDisplayName});
        }
        String[] names1 = method.getExceptionNames();
        ArrayList<String> list1 = null;
        if (names1 != null) {
            list1 = new ArrayList<String>(names1.length);
            int i = 0;
            while (i < names1.length) {
                list1.add(names1[i]);
                ++i;
            }
        }
        String[] names2 = method2.getExceptionNames();
        ArrayList<String> list2 = null;
        if (names2 != null) {
            list2 = new ArrayList<String>(names2.length);
            int i = 0;
            while (i < names2.length) {
                list2.add(names2[i]);
                ++i;
            }
        }
        if (names1 != null) {
            if (names2 == null) {
                Iterator iterator = list1.iterator();
                while (iterator.hasNext()) {
                    exceptionName = ((String)iterator.next()).replace('/', '.');
                    if (this.isCheckedException(this.apiBaseline1, this.component, exceptionName)) {
                        this.addDelta(this.getElementType(method), 3, 5, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName, exceptionName});
                        break;
                    }
                    this.addDelta(this.getElementType(method), 3, 53, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName, exceptionName});
                }
            } else {
                String exceptionName2;
                ArrayList<String> removedExceptions = new ArrayList<String>();
                Iterator iterator = list1.iterator();
                while (iterator.hasNext()) {
                    exceptionName2 = ((String)iterator.next()).replace('/', '.');
                    if (list2.remove(exceptionName2)) continue;
                    removedExceptions.add(exceptionName2);
                }
                if (removedExceptions.size() != 0) {
                    iterator = removedExceptions.iterator();
                    while (iterator.hasNext()) {
                        exceptionName2 = ((String)iterator.next()).replace('/', '.');
                        if (this.isCheckedException(this.apiBaseline1, this.component, exceptionName2)) {
                            this.addDelta(this.getElementType(method), 3, 5, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName, exceptionName2});
                            break;
                        }
                        this.addDelta(this.getElementType(method), 3, 53, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName, exceptionName2});
                    }
                }
                iterator = list2.iterator();
                while (iterator.hasNext()) {
                    exceptionName2 = ((String)iterator.next()).replace('/', '.');
                    if (this.isCheckedException(this.apiBaseline2, this.component2, exceptionName2)) {
                        this.addDelta(this.getElementType(method), 1, 5, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName, exceptionName2});
                        break;
                    }
                    this.addDelta(this.getElementType(method), 1, 53, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName, exceptionName2});
                }
            }
        } else if (names2 != null) {
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                exceptionName = ((String)iterator.next()).replace('/', '.');
                if (this.isCheckedException(this.apiBaseline2, this.component2, exceptionName)) {
                    this.addDelta(this.getElementType(method), 1, 5, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName, exceptionName});
                    break;
                }
                this.addDelta(this.getElementType(method), 1, 53, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName, exceptionName});
            }
        }
        if (Flags.isVarargs((int)access)) {
            if (!Flags.isVarargs((int)access2)) {
                this.addDelta(this.getElementType(method), 2, 55, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
            }
        } else if (Flags.isVarargs((int)access2)) {
            this.addDelta(this.getElementType(method), 2, 4, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
        }
        if (Flags.isProtected((int)access)) {
            if (Flags.isPrivate((int)access2) || Util.isDefault(access2)) {
                this.addDelta(this.getElementType(method), 2, 11, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
            } else if (Flags.isPublic((int)access2)) {
                this.addDelta(this.getElementType(method), 2, 22, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
            }
        } else if (Flags.isPublic((int)access) && (Flags.isProtected((int)access2) || Flags.isPrivate((int)access2) || Util.isDefault(access2))) {
            this.addDelta(this.getElementType(method), 2, 11, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
        } else if (Util.isDefault(access) && (Flags.isPublic((int)access2) || Flags.isProtected((int)access2))) {
            this.addDelta(this.getElementType(method), 2, 22, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
        } else if (Flags.isPrivate((int)access) && (Util.isDefault(access2) || Flags.isPublic((int)access2) || Flags.isProtected((int)access2))) {
            this.addDelta(this.getElementType(method), 2, 22, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
        }
        if (Flags.isAbstract((int)access)) {
            if (!Flags.isAbstract((int)access2)) {
                this.addDelta(this.getElementType(method), 2, 1, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
            }
        } else if (Flags.isAbstract((int)access2)) {
            this.addDelta(this.getElementType(method), 2, 30, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
        }
        if (Flags.isFinal((int)access)) {
            if (!Flags.isFinal((int)access2)) {
                this.addDelta(this.getElementType(method), 2, 18, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
            }
        } else if (Flags.isFinal((int)access2)) {
            int res = restrictions;
            if (!RestrictionModifiers.isOverrideRestriction(res)) {
                if (RestrictionModifiers.isExtendRestriction(this.currentDescriptorRestrictions)) {
                    res = this.currentDescriptorRestrictions;
                } else if (RestrictionModifiers.isExtendRestriction(this.initialDescriptorRestrictions)) {
                    res = this.initialDescriptorRestrictions;
                }
                if (RestrictionModifiers.isOverrideRestriction(referenceRestrictions)) {
                    res = referenceRestrictions;
                }
            }
            this.addDelta(this.getElementType(method2), 2, 31, res, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type2), this.getMethodDisplayName(method2, this.type2)});
        }
        if (Flags.isStatic((int)access)) {
            if (!Flags.isStatic((int)access2)) {
                this.addDelta(this.getElementType(method), 2, 38, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
            }
        } else if (Flags.isStatic((int)access2)) {
            this.addDelta(this.getElementType(method), 2, 33, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
        }
        if (Flags.isNative((int)access)) {
            if (!Flags.isNative((int)access2)) {
                this.addDelta(this.getElementType(method), 2, 29, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
            }
        } else if (Flags.isNative((int)access2)) {
            this.addDelta(this.getElementType(method), 2, 32, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
        }
        if (Flags.isSynchronized((int)access)) {
            if (!Flags.isSynchronized((int)access2)) {
                this.addDelta(this.getElementType(method), 2, 40, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
            }
        } else if (Flags.isSynchronized((int)access2)) {
            this.addDelta(this.getElementType(method), 2, 34, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
        }
        if (Flags.isDeprecated((int)access)) {
            if (!Flags.isDeprecated((int)access2)) {
                this.addDelta(this.getElementType(method), 3, 72, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
            }
        } else if (Flags.isDeprecated((int)access2)) {
            this.addDelta(this.getElementType(method), 1, 72, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
        }
        String signature1 = method.getGenericSignature();
        String signature2 = method2.getGenericSignature();
        this.checkGenericSignature(signature1, signature2, method, method2);
        if (method.getDefaultValue() == null) {
            if (method2.getDefaultValue() != null) {
                this.addDelta(this.getElementType(method), 1, 2, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
            }
        } else if (method2.getDefaultValue() == null) {
            this.addDelta(this.getElementType(method), 3, 2, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
        } else if (!method.getDefaultValue().equals(method2.getDefaultValue())) {
            this.addDelta(this.getElementType(method), 2, 2, restrictions, access, access2, this.type1, key, new String[]{Util.getDescriptorName(this.type1), methodDisplayName});
        }
    }

    private Set getInterfacesSet(IApiType type) {
        HashSet set = new HashSet();
        this.status = null;
        this.collectAllInterfaces(type, set);
        if (set.isEmpty()) {
            return null;
        }
        return set;
    }

    private String getMethodDisplayName(IApiMethod method, IApiType type) {
        String methodName = null;
        methodName = method.isConstructor() ? type.getSimpleName() : method.getName();
        String signature = null;
        String genericSignature = method.getGenericSignature();
        signature = genericSignature != null ? genericSignature : method.getSignature();
        return Signature.toString((String)signature, (String)methodName, null, (boolean)false, (boolean)false);
    }

    private SignatureDescriptor getSignatureDescriptor(String signature) {
        SignatureDescriptor signatureDescriptor = new SignatureDescriptor();
        SignatureReader signatureReader = new SignatureReader(signature);
        signatureReader.accept((SignatureVisitor)new SignatureDecoder(signatureDescriptor));
        return signatureDescriptor;
    }

    private List getSuperclassList(IApiType type) {
        return this.getSuperclassList(type, false);
    }

    private List getSuperclassList(IApiType type, boolean includeObject) {
        return this.getSuperclassList(type, includeObject, false);
    }

    private List getSuperclassList(IApiType type, boolean includeObject, boolean includePrivate) {
        IApiType superClass = type;
        this.status = null;
        String superName = superClass.getSuperclassName();
        if (Util.isJavaLangObject(superName) && !includeObject) {
            return null;
        }
        ArrayList<IApiType> list = new ArrayList<IApiType>();
        try {
            while (superName != null && (!Util.isJavaLangObject(superName) || includeObject)) {
                superClass = superClass.getSuperclass();
                int visibility = 2;
                IApiComponent superComponent = superClass.getApiComponent();
                IApiDescription apiDescription = superComponent.getApiDescription();
                IApiAnnotations elementDescription = apiDescription.resolveAnnotations(superClass.getHandle());
                if (elementDescription != null) {
                    visibility = elementDescription.getVisibility();
                }
                if (includePrivate || (visibility & this.visibilityModifiers) != 0) {
                    list.add(superClass);
                }
                superName = superClass.getSuperclassName();
            }
        }
        catch (CoreException e) {
            this.reportStatus(e);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    private void reportFieldAddition(IApiField field, IApiType type) {
        int access = field.getModifiers();
        String name = field.getName();
        if (Flags.isSynthetic((int)access)) {
            return;
        }
        if (this.visibilityModifiers == 1 && this.component2.hasApiDescription()) {
            int restrictions;
            IApiAnnotations apiAnnotations;
            IApiDescription apiDescription = null;
            try {
                apiDescription = this.component2.getApiDescription();
            }
            catch (CoreException e) {
                this.reportStatus(e);
            }
            if (apiDescription != null && (apiAnnotations = apiDescription.resolveAnnotations(field.getHandle())) != null && RestrictionModifiers.isReferenceRestriction(restrictions = apiAnnotations.getRestrictions())) {
                return;
            }
        }
        if (field.isEnumConstant()) {
            this.addDelta(this.getElementType(type), 1, 12, this.currentDescriptorRestrictions, 0, access, this.type1, name, new String[]{Util.getDescriptorName(type), name});
        } else {
            this.addDelta(this.getElementType(type), 1, 16, this.currentDescriptorRestrictions, 0, access, this.type1, name, new String[]{Util.getDescriptorName(type), name});
        }
    }

    private void reportMethodAddition(IApiMethod method, IApiType type) {
        int access = method.getModifiers();
        if (method.isClassInitializer()) {
            this.addDelta(this.getElementType(type), 1, 7, this.currentDescriptorRestrictions, 0, access, this.type1, type.getName(), Util.getDescriptorName(this.type1));
            return;
        }
        if (Flags.isSynthetic((int)access)) {
            return;
        }
        IApiDescription apiDescription = null;
        if ((this.visibilityModifiers & 1) != 0 && this.component2.hasApiDescription()) {
            IApiAnnotations apiAnnotations;
            int restrictions = 0;
            try {
                apiDescription = this.component2.getApiDescription();
            }
            catch (CoreException e) {
                this.reportStatus(e);
            }
            if (apiDescription != null && (apiAnnotations = apiDescription.resolveAnnotations(method.getHandle())) != null) {
                restrictions = apiAnnotations.getRestrictions();
            }
            if (this.visibilityModifiers == 1 && RestrictionModifiers.isReferenceRestriction(restrictions)) {
                return;
            }
        }
        String methodDisplayName = this.getMethodDisplayName(method, type);
        int restrictionsForMethodAddition = this.currentDescriptorRestrictions;
        if (Flags.isFinal((int)this.type2.getModifiers())) {
            restrictionsForMethodAddition |= 2;
        }
        if (apiDescription != null && this.type2.isMemberType() && Flags.isProtected((int)this.type2.getModifiers())) {
            IApiType enclosingType = this.type2;
            try {
                do {
                    IApiAnnotations memberTypeAnnotations;
                    if (enclosingType == null || (memberTypeAnnotations = apiDescription.resolveAnnotations(enclosingType.getHandle())) == null) continue;
                    int restrictions = memberTypeAnnotations.getRestrictions();
                    if (RestrictionModifiers.isReferenceRestriction(restrictions)) {
                        restrictionsForMethodAddition |= 8;
                    }
                    if (RestrictionModifiers.isExtendRestriction(restrictions)) {
                        restrictionsForMethodAddition |= 2;
                        if (this.visibilityModifiers == 1) {
                            return;
                        }
                    }
                    if (!RestrictionModifiers.isImplementRestriction(restrictions)) continue;
                    restrictionsForMethodAddition |= 1;
                } while ((enclosingType = enclosingType.getEnclosingType()) != null);
            }
            catch (CoreException e) {
                this.reportStatus(e);
            }
        }
        if (Flags.isPublic((int)access) || Flags.isProtected((int)access)) {
            if (method.isConstructor()) {
                this.addDelta(this.getElementType(type), 1, 8, restrictionsForMethodAddition, 0, access, this.type1, this.getKeyForMethod(method, type), new String[]{Util.getDescriptorName(type), methodDisplayName});
            } else if (type.isAnnotation()) {
                if (method.getDefaultValue() != null) {
                    this.addDelta(this.getElementType(type), 1, 27, restrictionsForMethodAddition, 0, access, this.type1, this.getKeyForMethod(method, type), new String[]{Util.getDescriptorName(type), methodDisplayName});
                } else {
                    this.addDelta(this.getElementType(type), 1, 28, restrictionsForMethodAddition, 0, access, this.type1, this.getKeyForMethod(method, type), new String[]{Util.getDescriptorName(type), methodDisplayName});
                }
            } else {
                int access3;
                List superclassList;
                IApiMethod method3;
                IApiType superTypeDescriptor;
                Iterator iterator;
                Set interfacesSet;
                String name;
                boolean found = false;
                if (this.component2 != null) {
                    name = method.getName();
                    String descriptor = method.getSignature();
                    if (this.type1.isInterface()) {
                        interfacesSet = this.getInterfacesSet(this.type2);
                        if (interfacesSet != null && this.isStatusOk()) {
                            iterator = interfacesSet.iterator();
                            while (iterator.hasNext()) {
                                superTypeDescriptor = (IApiType)iterator.next();
                                method3 = superTypeDescriptor.getMethod(name, descriptor);
                                if (method3 == null) continue;
                                found = true;
                                break;
                            }
                        }
                    } else {
                        superclassList = this.getSuperclassList(this.type2, true);
                        if (superclassList != null && this.isStatusOk()) {
                            iterator = superclassList.iterator();
                            while (iterator.hasNext()) {
                                superTypeDescriptor = (IApiType)iterator.next();
                                method3 = superTypeDescriptor.getMethod(name, descriptor);
                                if (method3 == null || !Flags.isPublic((int)(access3 = method3.getModifiers())) && !Flags.isProtected((int)access3)) continue;
                                found = true;
                                break;
                            }
                        }
                    }
                }
                if (!found) {
                    if (this.component != null) {
                        name = method.getName();
                        String descriptor = method.getSignature();
                        if (this.type1.isInterface()) {
                            interfacesSet = this.getInterfacesSet(this.type1);
                            if (interfacesSet != null && this.isStatusOk()) {
                                iterator = interfacesSet.iterator();
                                while (iterator.hasNext()) {
                                    superTypeDescriptor = (IApiType)iterator.next();
                                    method3 = superTypeDescriptor.getMethod(name, descriptor);
                                    if (method3 == null) continue;
                                    found = true;
                                    break;
                                }
                            }
                        } else {
                            superclassList = this.getSuperclassList(this.type1, true);
                            if (superclassList != null && this.isStatusOk()) {
                                iterator = superclassList.iterator();
                                while (iterator.hasNext()) {
                                    superTypeDescriptor = (IApiType)iterator.next();
                                    method3 = superTypeDescriptor.getMethod(name, descriptor);
                                    if (method3 == null || !Flags.isPublic((int)(access3 = method3.getModifiers())) && !Flags.isProtected((int)access3)) continue;
                                    found = true;
                                    break;
                                }
                            }
                        }
                    }
                    this.addDelta(this.getElementType(type), 1, found ? 67 : 25, restrictionsForMethodAddition, 0, method.getModifiers(), this.type1, this.getKeyForMethod(method, type), new String[]{Util.getDescriptorName(type), methodDisplayName});
                } else {
                    this.addDelta(this.getElementType(type), 1, found ? 36 : 25, restrictionsForMethodAddition, 0, method.getModifiers(), this.type1, this.getKeyForMethod(method, type), new String[]{Util.getDescriptorName(type), methodDisplayName});
                }
            }
        } else {
            this.addDelta(this.getElementType(type), 1, method.isConstructor() ? 8 : 25, restrictionsForMethodAddition, 0, method.getModifiers(), this.type1, this.getKeyForMethod(method, type), new String[]{Util.getDescriptorName(type), methodDisplayName});
        }
    }

    private String getKeyForMethod(IApiMethod method, IApiType type) {
        StringBuffer buffer = new StringBuffer();
        if (method.isConstructor()) {
            String name = type.getName();
            int index = name.lastIndexOf(46);
            int dollarIndex = name.lastIndexOf(36);
            if (dollarIndex != -1 && type.isMemberType()) {
                buffer.append(type.getName().substring(dollarIndex + 1));
            } else {
                buffer.append(type.getName().substring(index + 1));
            }
        } else {
            buffer.append(method.getName());
        }
        String genericSignature = method.getGenericSignature();
        if (genericSignature != null) {
            buffer.append(genericSignature);
        } else {
            buffer.append(method.getSignature());
        }
        return String.valueOf(buffer);
    }

    private static boolean isAPI(int visibility, IApiType memberTypeDescriptor) {
        int access = memberTypeDescriptor.getModifiers();
        return VisibilityModifiers.isAPI(visibility) && (Flags.isPublic((int)access) || Flags.isProtected((int)access));
    }

    private IApiTypeRoot getType(String typeName, IApiComponent component, IApiBaseline baseline) throws CoreException {
        String packageName = Signatures.getPackageName(typeName);
        IApiComponent[] components = baseline.resolvePackage(component, packageName);
        if (components == null) {
            String msg = MessageFormat.format((String)ComparatorMessages.ClassFileComparator_1, (Object[])new String[]{packageName, baseline.getName(), component.getSymbolicName()});
            if (Debug) {
                System.err.println("TYPE LOOKUP: " + msg);
            }
            this.reportStatus((IStatus)new Status(4, component.getSymbolicName(), msg));
            return null;
        }
        IApiTypeRoot result = Util.getClassFile(components, typeName);
        if (result == null) {
            String msg = MessageFormat.format((String)ComparatorMessages.ClassFileComparator_2, (Object[])new String[]{typeName, baseline.getName(), component.getSymbolicName()});
            if (Debug) {
                System.err.println("TYPE LOOKUP: " + msg);
            }
            this.reportStatus((IStatus)new Status(4, component.getSymbolicName(), msg));
            return null;
        }
        return result;
    }

    private int getElementType(IApiType type) {
        if (type.isAnnotation()) {
            return 1;
        }
        if (type.isEnum()) {
            return 6;
        }
        if (type.isInterface()) {
            return 8;
        }
        return 4;
    }

    private int getElementType(IApiMethod method) {
        if (method.isConstructor()) {
            return 5;
        }
        return 9;
    }

    private int getTargetType(IApiMethod method) {
        if (method.isConstructor()) {
            return 8;
        }
        return 25;
    }

    private int getElementType(IApiMember member) {
        switch (member.getType()) {
            case 2: {
                return this.getElementType((IApiType)member);
            }
            case 6: {
                return this.getElementType((IApiMethod)member);
            }
        }
        return 7;
    }
}

