/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.net.proxy.unix;

import java.net.URI;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.core.internal.net.AbstractProxyProvider;
import org.eclipse.core.internal.net.Activator;
import org.eclipse.core.internal.net.Policy;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.StringUtil;
import org.eclipse.core.net.proxy.IProxyData;

public class UnixProxyProvider
extends AbstractProxyProvider {
    private static final String LIBRARY_GCONF2 = "gconf-2";
    private static final String LIBRARY_NAME = "gnomeproxy-1.0.0";
    private static final String ENABLE_GNOME = "org.eclipse.core.net.enableGnome";
    private static boolean isGnomeLibLoaded = false;

    static {
        String value = System.getProperty(ENABLE_GNOME);
        if ("".equals(value) || "true".equals(value)) {
            UnixProxyProvider.loadGnomeLib();
        }
    }

    public IProxyData[] getProxyData(URI uri) {
        if (uri.getScheme() != null) {
            IProxyData[] iProxyDataArray;
            ProxyData pd = this.getSystemProxyInfo(uri.getScheme());
            if (pd != null) {
                IProxyData[] iProxyDataArray2 = new IProxyData[1];
                iProxyDataArray = iProxyDataArray2;
                iProxyDataArray2[0] = pd;
            } else {
                iProxyDataArray = new IProxyData[]{};
            }
            return iProxyDataArray;
        }
        return this.getProxyData();
    }

    public IProxyData[] getProxyData() {
        String[] commonTypes = new String[]{"HTTP", "SOCKS", "HTTPS"};
        return this.getProxyForTypes(commonTypes);
    }

    private IProxyData[] getProxyForTypes(String[] types) {
        ArrayList<ProxyData> allData = new ArrayList<ProxyData>();
        int i = 0;
        while (i < types.length) {
            String type = types[i];
            ProxyData pd = this.getSystemProxyInfo(type);
            if (pd != null && pd.getHost() != null) {
                allData.add(pd);
            }
            ++i;
        }
        return allData.toArray(new IProxyData[0]);
    }

    public String[] getNonProxiedHosts() {
        String npEnv;
        if (Policy.DEBUG_SYSTEM_PROVIDERS) {
            Policy.debug("Getting no_proxy");
        }
        if ((npEnv = this.getEnv("no_proxy")) != null) {
            String[] npHosts = StringUtil.split(npEnv, new String[]{","});
            int i = 0;
            while (i < npHosts.length) {
                npHosts[i] = npHosts[i].trim();
                ++i;
            }
            if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                Policy.debug("Got Env no_proxy: " + npEnv);
                this.debugPrint(npHosts);
            }
            return npHosts;
        }
        if (isGnomeLibLoaded) {
            try {
                String[] npHosts = UnixProxyProvider.getGConfNonProxyHosts();
                if (npHosts != null && npHosts.length > 0) {
                    if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                        Policy.debug("Got Gnome no_proxy");
                        this.debugPrint(npHosts);
                    }
                    return npHosts;
                }
            }
            catch (UnsatisfiedLinkError e) {
                Activator.logError("Problem during accessing Gnome library", e);
            }
        }
        return new String[0];
    }

    protected ProxyData getSystemProxyInfo(String protocol) {
        ProxyData pd = null;
        String envName = null;
        if (Policy.DEBUG_SYSTEM_PROVIDERS) {
            Policy.debug("Getting proxies for: " + protocol);
        }
        try {
            protocol = protocol.toLowerCase(Locale.ENGLISH);
            envName = String.valueOf(protocol) + "_proxy";
            String proxyEnv = this.getEnv(envName);
            if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                Policy.debug("Got proxyEnv: " + proxyEnv);
            }
            if (proxyEnv != null) {
                URI uri = new URI(proxyEnv);
                pd = new ProxyData(protocol);
                pd.setHost(uri.getHost());
                pd.setPort(uri.getPort());
                String userInfo = uri.getUserInfo();
                if (userInfo != null) {
                    String user = null;
                    String password = null;
                    int pwInd = userInfo.indexOf(58);
                    if (pwInd >= 0) {
                        user = userInfo.substring(0, pwInd);
                        password = userInfo.substring(pwInd + 1);
                    } else {
                        user = userInfo;
                    }
                    pd.setUserid(user);
                    pd.setPassword(password);
                }
                pd.setSource("LINUX_ENV");
                if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                    Policy.debug("Got Env proxy: " + pd);
                }
                return pd;
            }
        }
        catch (Exception e) {
            Activator.logError("Problem during accessing system variable: " + envName, e);
        }
        if (isGnomeLibLoaded) {
            try {
                pd = UnixProxyProvider.getGConfProxyInfo(protocol);
                if (pd != null) {
                    if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                        Policy.debug("Got Gnome proxy: " + pd);
                    }
                    pd.setSource("LINUX_GNOME");
                    return pd;
                }
            }
            catch (UnsatisfiedLinkError e) {
                Activator.logError("Problem during accessing Gnome library", e);
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private synchronized String getEnv(String env) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 5[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void loadGnomeLib() {
        block6: {
            try {
                System.loadLibrary(LIBRARY_GCONF2);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                    Policy.debug("Could not load library: " + System.mapLibraryName(LIBRARY_GCONF2));
                }
                return;
            }
            try {
                System.loadLibrary(LIBRARY_NAME);
                isGnomeLibLoaded = true;
                if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                    Policy.debug("Loaded " + System.mapLibraryName(LIBRARY_NAME) + " library");
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (!Policy.DEBUG_SYSTEM_PROVIDERS) break block6;
                Policy.debug("Could not load library: " + System.mapLibraryName(LIBRARY_NAME));
            }
        }
    }

    private void debugPrint(String[] strs) {
        int i = 0;
        while (i < strs.length) {
            System.out.println(String.valueOf(i) + ": " + strs[i]);
            ++i;
        }
    }

    protected static native void gconfInit();

    protected static native ProxyData getGConfProxyInfo(String var0);

    protected static native String[] getGConfNonProxyHosts();
}

