/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.model;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.junit.JUnitCorePlugin;
import org.eclipse.jdt.internal.junit.JUnitMessages;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.launcher.JUnitLaunchConfigurationConstants;
import org.eclipse.jdt.internal.junit.model.ITestRunListener2;
import org.eclipse.jdt.internal.junit.model.ITestSessionListener;
import org.eclipse.jdt.internal.junit.model.JUnitModel;
import org.eclipse.jdt.internal.junit.model.RemoteTestRunnerClient;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestRoot;
import org.eclipse.jdt.internal.junit.model.TestRunListenerAdapter;
import org.eclipse.jdt.internal.junit.model.TestSuiteElement;
import org.eclipse.jdt.junit.model.ITestElement;
import org.eclipse.jdt.junit.model.ITestElementContainer;
import org.eclipse.jdt.junit.model.ITestRunSession;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class TestRunSession
implements ITestRunSession {
    private final ILaunch fLaunch;
    private final String fTestRunName;
    private final IJavaProject fProject;
    private final ITestKind fTestRunnerKind;
    private RemoteTestRunnerClient fTestRunnerClient;
    private final ListenerList fSessionListeners;
    private TestRoot fTestRoot;
    private ITestElement.Result fTestResult;
    private HashMap fIdToTest;
    private List fIncompleteTestSuites;
    private TestSuiteElement fUnrootedSuite;
    volatile int fStartedCount;
    volatile int fIgnoredCount;
    volatile int fErrorCount;
    volatile int fFailureCount;
    volatile int fTotalCount;
    volatile long fStartTime;
    volatile boolean fIsRunning;
    volatile boolean fIsStopped;

    public TestRunSession(String testRunName, IJavaProject project) {
        this.fLaunch = null;
        this.fProject = project;
        this.fStartTime = -System.currentTimeMillis();
        Assert.isNotNull((Object)testRunName);
        this.fTestRunName = testRunName;
        this.fTestRunnerKind = ITestKind.NULL;
        this.fTestRoot = new TestRoot(this);
        this.fIdToTest = new HashMap();
        this.fTestRunnerClient = null;
        this.fSessionListeners = new ListenerList();
    }

    public TestRunSession(ILaunch launch, IJavaProject project, int port) {
        Assert.isNotNull((Object)launch);
        this.fLaunch = launch;
        this.fProject = project;
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        if (launchConfiguration != null) {
            this.fTestRunName = launchConfiguration.getName();
            this.fTestRunnerKind = JUnitLaunchConfigurationConstants.getTestRunnerKind(launchConfiguration);
        } else {
            this.fTestRunName = project.getElementName();
            this.fTestRunnerKind = ITestKind.NULL;
        }
        this.fTestRoot = new TestRoot(this);
        this.fIdToTest = new HashMap();
        this.fTestRunnerClient = new RemoteTestRunnerClient();
        this.fTestRunnerClient.startListening(new ITestRunListener2[]{new TestSessionNotifier()}, port);
        final ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener((ILaunchesListener)new ILaunchesListener2(){

            public void launchesTerminated(ILaunch[] launches) {
                if (Arrays.asList(launches).contains(TestRunSession.this.fLaunch)) {
                    if (TestRunSession.this.fTestRunnerClient != null) {
                        TestRunSession.this.fTestRunnerClient.stopWaiting();
                    }
                    launchManager.removeLaunchListener((ILaunchesListener)this);
                }
            }

            public void launchesRemoved(ILaunch[] launches) {
                if (Arrays.asList(launches).contains(TestRunSession.this.fLaunch)) {
                    if (TestRunSession.this.fTestRunnerClient != null) {
                        TestRunSession.this.fTestRunnerClient.stopWaiting();
                    }
                    launchManager.removeLaunchListener((ILaunchesListener)this);
                }
            }

            public void launchesChanged(ILaunch[] launches) {
            }

            public void launchesAdded(ILaunch[] launches) {
            }
        });
        this.fSessionListeners = new ListenerList();
        this.addTestSessionListener(new TestRunListenerAdapter(this));
    }

    void reset() {
        this.fStartedCount = 0;
        this.fFailureCount = 0;
        this.fErrorCount = 0;
        this.fIgnoredCount = 0;
        this.fTotalCount = 0;
        this.fTestRoot = new TestRoot(this);
        this.fTestResult = null;
        this.fIdToTest = new HashMap();
    }

    public ITestElement.ProgressState getProgressState() {
        if (this.isRunning()) {
            return ITestElement.ProgressState.RUNNING;
        }
        if (this.isStopped()) {
            return ITestElement.ProgressState.STOPPED;
        }
        return ITestElement.ProgressState.COMPLETED;
    }

    public ITestElement.Result getTestResult(boolean includeChildren) {
        if (this.fTestRoot != null) {
            return this.fTestRoot.getTestResult(true);
        }
        return this.fTestResult;
    }

    public ITestElement[] getChildren() {
        return this.getTestRoot().getChildren();
    }

    public ITestElement.FailureTrace getFailureTrace() {
        return null;
    }

    public ITestElementContainer getParentContainer() {
        return null;
    }

    public ITestRunSession getTestRunSession() {
        return this;
    }

    public synchronized TestRoot getTestRoot() {
        this.swapIn();
        return this.fTestRoot;
    }

    public IJavaProject getLaunchedProject() {
        return this.fProject;
    }

    public ITestKind getTestRunnerKind() {
        return this.fTestRunnerKind;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public String getTestRunName() {
        return this.fTestRunName;
    }

    public int getErrorCount() {
        return this.fErrorCount;
    }

    public int getFailureCount() {
        return this.fFailureCount;
    }

    public int getStartedCount() {
        return this.fStartedCount;
    }

    public int getIgnoredCount() {
        return this.fIgnoredCount;
    }

    public int getTotalCount() {
        return this.fTotalCount;
    }

    public long getStartTime() {
        return this.fStartTime;
    }

    public boolean isStopped() {
        return this.fIsStopped;
    }

    public synchronized void addTestSessionListener(ITestSessionListener listener) {
        this.swapIn();
        this.fSessionListeners.add((Object)listener);
    }

    public void removeTestSessionListener(ITestSessionListener listener) {
        this.fSessionListeners.remove((Object)listener);
    }

    public synchronized void swapOut() {
        if (this.fTestRoot == null) {
            return;
        }
        if (this.isRunning() || this.isStarting() || this.isKeptAlive()) {
            return;
        }
        Object[] listeners = this.fSessionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ITestSessionListener registered = (ITestSessionListener)listeners[i];
            if (!registered.acceptsSwapToDisk()) {
                return;
            }
            ++i;
        }
        try {
            File swapFile = this.getSwapFile();
            JUnitModel.exportTestRunSession(this, swapFile);
            this.fTestResult = this.fTestRoot.getTestResult(true);
            this.fTestRoot = null;
            this.fTestRunnerClient = null;
            this.fIdToTest = new HashMap();
            this.fIncompleteTestSuites = null;
            this.fUnrootedSuite = null;
        }
        catch (IllegalStateException e) {
            JUnitCorePlugin.log(e);
        }
        catch (CoreException e) {
            JUnitCorePlugin.log(e);
        }
    }

    public boolean isStarting() {
        return this.getStartTime() == 0L && this.fLaunch != null && !this.fLaunch.isTerminated();
    }

    public void removeSwapFile() {
        File swapFile = this.getSwapFile();
        if (swapFile.exists()) {
            swapFile.delete();
        }
    }

    private File getSwapFile() throws IllegalStateException {
        File historyDir = JUnitCorePlugin.getHistoryDirectory();
        String isoTime = new SimpleDateFormat("yyyyMMdd-HHmmss.SSS").format(new Date(this.getStartTime()));
        String swapFileName = String.valueOf(isoTime) + ".xml";
        return new File(historyDir, swapFileName);
    }

    public synchronized void swapIn() {
        if (this.fTestRoot != null) {
            return;
        }
        try {
            JUnitModel.importIntoTestRunSession(this.getSwapFile(), this);
        }
        catch (IllegalStateException e) {
            JUnitCorePlugin.log(e);
            this.fTestRoot = new TestRoot(this);
            this.fTestResult = null;
        }
        catch (CoreException e) {
            JUnitCorePlugin.log(e);
            this.fTestRoot = new TestRoot(this);
            this.fTestResult = null;
        }
    }

    public void stopTestRun() {
        if (this.isRunning() || !this.isKeptAlive()) {
            this.fIsStopped = true;
        }
        if (this.fTestRunnerClient != null) {
            this.fTestRunnerClient.stopTest();
        }
    }

    public boolean isKeptAlive() {
        if (this.fTestRunnerClient != null && this.fLaunch != null && this.fTestRunnerClient.isRunning() && "debug".equals(this.fLaunch.getLaunchMode())) {
            ILaunchConfiguration config = this.fLaunch.getLaunchConfiguration();
            try {
                return config != null && config.getAttribute("org.eclipse.jdt.junit.KEEPRUNNING_ATTR", false);
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return false;
    }

    public boolean isRunning() {
        return this.fIsRunning;
    }

    public boolean rerunTest(String testId, String className, String testName, String launchMode, boolean buildBeforeLaunch) throws CoreException {
        ILaunchConfiguration launchConfiguration;
        if (this.isKeptAlive()) {
            TestElement.Status status = ((TestCaseElement)this.getTestElement(testId)).getStatus();
            if (status == TestElement.Status.ERROR) {
                --this.fErrorCount;
            } else if (status == TestElement.Status.FAILURE) {
                --this.fFailureCount;
            }
            this.fTestRunnerClient.rerunTest(testId, className, testName);
            return true;
        }
        if (this.fLaunch != null && (launchConfiguration = this.fLaunch.getLaunchConfiguration()) != null) {
            String name = className;
            if (testName != null) {
                name = String.valueOf(name) + "." + testName;
            }
            String configName = Messages.format(JUnitMessages.TestRunnerViewPart_configName, name);
            ILaunchConfigurationWorkingCopy tmp = launchConfiguration.copy(configName);
            tmp.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, className);
            tmp.setAttribute("org.eclipse.jdt.junit.CONTAINER", "");
            if (testName != null) {
                tmp.setAttribute("org.eclipse.jdt.junit.TESTNAME", testName);
            }
            tmp.launch(launchMode, null, buildBeforeLaunch);
            return true;
        }
        return false;
    }

    public TestElement getTestElement(String id) {
        return (TestElement)this.fIdToTest.get(id);
    }

    private TestElement addTreeEntry(String treeEntry) {
        int index0 = treeEntry.indexOf(44);
        String id = treeEntry.substring(0, index0);
        StringBuffer testNameBuffer = new StringBuffer(100);
        int index1 = this.scanTestName(treeEntry, index0 + 1, testNameBuffer);
        String testName = testNameBuffer.toString().trim();
        int index2 = treeEntry.indexOf(44, index1 + 1);
        boolean isSuite = treeEntry.substring(index1 + 1, index2).equals("true");
        int testCount = Integer.parseInt(treeEntry.substring(index2 + 1));
        if (this.fIncompleteTestSuites.isEmpty()) {
            return this.createTestElement(this.fTestRoot, id, testName, isSuite, testCount);
        }
        int suiteIndex = this.fIncompleteTestSuites.size() - 1;
        IncompleteTestSuite openSuite = (IncompleteTestSuite)this.fIncompleteTestSuites.get(suiteIndex);
        --openSuite.fOutstandingChildren;
        if (openSuite.fOutstandingChildren <= 0) {
            this.fIncompleteTestSuites.remove(suiteIndex);
        }
        return this.createTestElement(openSuite.fTestSuiteElement, id, testName, isSuite, testCount);
    }

    public TestElement createTestElement(TestSuiteElement parent, String id, String testName, boolean isSuite, int testCount) {
        TestElement testElement;
        if (isSuite) {
            TestSuiteElement testSuiteElement = new TestSuiteElement(parent, id, testName, testCount);
            testElement = testSuiteElement;
            if (testCount > 0) {
                this.fIncompleteTestSuites.add(new IncompleteTestSuite(testSuiteElement, testCount));
            }
        } else {
            testElement = new TestCaseElement(parent, id, testName);
        }
        this.fIdToTest.put(id, testElement);
        return testElement;
    }

    private int scanTestName(String s, int start, StringBuffer testName) {
        boolean inQuote = false;
        int i = start;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\\' && !inQuote) {
                inQuote = true;
            } else if (inQuote) {
                inQuote = false;
                testName.append(c);
            } else {
                if (c == ',') break;
                testName.append(c);
            }
            ++i;
        }
        return i;
    }

    public void registerTestFailureStatus(TestElement testElement, TestElement.Status status, String trace, String expected, String actual) {
        testElement.setStatus(status, trace, expected, actual);
        if (status.isError()) {
            ++this.fErrorCount;
        } else if (status.isFailure()) {
            ++this.fFailureCount;
        }
    }

    public void registerTestEnded(TestElement testElement, boolean completed) {
        if (testElement instanceof TestCaseElement) {
            ++this.fTotalCount;
            if (!completed) {
                return;
            }
            ++this.fStartedCount;
            if (((TestCaseElement)testElement).isIgnored()) {
                ++this.fIgnoredCount;
            }
            if (!testElement.getStatus().isErrorOrFailure()) {
                this.setStatus(testElement, TestElement.Status.OK);
            }
        }
    }

    private void setStatus(TestElement testElement, TestElement.Status status) {
        testElement.setStatus(status);
    }

    public TestElement[] getAllFailedTestElements() {
        ArrayList failures = new ArrayList();
        this.addFailures(failures, this.getTestRoot());
        return failures.toArray(new TestElement[failures.size()]);
    }

    private void addFailures(ArrayList failures, ITestElement testElement) {
        ITestElement.Result testResult = testElement.getTestResult(true);
        if (testResult == ITestElement.Result.ERROR || testResult == ITestElement.Result.FAILURE) {
            failures.add(testElement);
        }
        if (testElement instanceof TestSuiteElement) {
            TestSuiteElement testSuiteElement = (TestSuiteElement)testElement;
            ITestElement[] children = testSuiteElement.getChildren();
            int i = 0;
            while (i < children.length) {
                this.addFailures(failures, children[i]);
                ++i;
            }
        }
    }

    public double getElapsedTimeInSeconds() {
        if (this.fTestRoot == null) {
            return Double.NaN;
        }
        return this.fTestRoot.getElapsedTimeInSeconds();
    }

    public String toString() {
        return String.valueOf(this.fTestRunName) + " " + DateFormat.getDateTimeInstance().format(new Date(this.fStartTime));
    }

    private static class IncompleteTestSuite {
        public TestSuiteElement fTestSuiteElement;
        public int fOutstandingChildren;

        public IncompleteTestSuite(TestSuiteElement testSuiteElement, int outstandingChildren) {
            this.fTestSuiteElement = testSuiteElement;
            this.fOutstandingChildren = outstandingChildren;
        }
    }

    private class TestSessionNotifier
    implements ITestRunListener2 {
        private TestSessionNotifier() {
        }

        public void testRunStarted(int testCount) {
            TestRunSession.this.fIncompleteTestSuites = new ArrayList();
            TestRunSession.this.fStartedCount = 0;
            TestRunSession.this.fIgnoredCount = 0;
            TestRunSession.this.fFailureCount = 0;
            TestRunSession.this.fErrorCount = 0;
            TestRunSession.this.fTotalCount = testCount;
            TestRunSession.this.fStartTime = System.currentTimeMillis();
            TestRunSession.this.fIsRunning = true;
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).sessionStarted();
                ++i;
            }
        }

        public void testRunEnded(long elapsedTime) {
            TestRunSession.this.fIsRunning = false;
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).sessionEnded(elapsedTime);
                ++i;
            }
        }

        public void testRunStopped(long elapsedTime) {
            TestRunSession.this.fIsRunning = false;
            TestRunSession.this.fIsStopped = true;
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).sessionStopped(elapsedTime);
                ++i;
            }
        }

        public void testRunTerminated() {
            TestRunSession.this.fIsRunning = false;
            TestRunSession.this.fIsStopped = true;
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).sessionTerminated();
                ++i;
            }
        }

        public void testTreeEntry(String description) {
            TestElement testElement = TestRunSession.this.addTreeEntry(description);
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).testAdded(testElement);
                ++i;
            }
        }

        private TestElement createUnrootedTestElement(String testId, String testName) {
            TestSuiteElement unrootedSuite = this.getUnrootedSuite();
            TestElement testElement = TestRunSession.this.createTestElement(unrootedSuite, testId, testName, false, 1);
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).testAdded(testElement);
                ++i;
            }
            return testElement;
        }

        private TestSuiteElement getUnrootedSuite() {
            if (TestRunSession.this.fUnrootedSuite == null) {
                TestRunSession.this.fUnrootedSuite = (TestSuiteElement)TestRunSession.this.createTestElement(TestRunSession.this.fTestRoot, "-2", JUnitMessages.TestRunSession_unrootedTests, true, 0);
            }
            return TestRunSession.this.fUnrootedSuite;
        }

        public void testStarted(String testId, String testName) {
            TestElement testElement;
            if (TestRunSession.this.fStartedCount == 0) {
                Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    ((ITestSessionListener)listeners[i]).runningBegins();
                    ++i;
                }
            }
            if ((testElement = TestRunSession.this.getTestElement(testId)) == null) {
                testElement = this.createUnrootedTestElement(testId, testName);
            } else if (!(testElement instanceof TestCaseElement)) {
                this.logUnexpectedTest(testId, testElement);
                return;
            }
            TestCaseElement testCaseElement = (TestCaseElement)testElement;
            TestRunSession.this.setStatus(testCaseElement, TestElement.Status.RUNNING);
            ++TestRunSession.this.fStartedCount;
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).testStarted(testCaseElement);
                ++i;
            }
        }

        public void testEnded(String testId, String testName) {
            TestElement testElement = TestRunSession.this.getTestElement(testId);
            if (testElement == null) {
                testElement = this.createUnrootedTestElement(testId, testName);
            } else if (!(testElement instanceof TestCaseElement)) {
                this.logUnexpectedTest(testId, testElement);
                return;
            }
            TestCaseElement testCaseElement = (TestCaseElement)testElement;
            if (testName.startsWith("@Ignore: ")) {
                testCaseElement.setIgnored(true);
                ++TestRunSession.this.fIgnoredCount;
            }
            if (testCaseElement.getStatus() == TestElement.Status.RUNNING) {
                TestRunSession.this.setStatus(testCaseElement, TestElement.Status.OK);
            }
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).testEnded(testCaseElement);
                ++i;
            }
        }

        public void testFailed(int statusCode, String testId, String testName, String trace, String expected, String actual) {
            TestElement testElement = TestRunSession.this.getTestElement(testId);
            if (testElement == null) {
                testElement = this.createUnrootedTestElement(testId, testName);
            }
            TestElement.Status status = TestElement.Status.convert(statusCode);
            TestRunSession.this.registerTestFailureStatus(testElement, status, trace, expected, actual);
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).testFailed(testElement, status, trace, expected, actual);
                ++i;
            }
        }

        public void testReran(String testId, String className, String testName, int statusCode, String trace, String expectedResult, String actualResult) {
            TestElement testElement = TestRunSession.this.getTestElement(testId);
            if (testElement == null) {
                testElement = this.createUnrootedTestElement(testId, testName);
            } else if (!(testElement instanceof TestCaseElement)) {
                this.logUnexpectedTest(testId, testElement);
                return;
            }
            TestCaseElement testCaseElement = (TestCaseElement)testElement;
            TestElement.Status status = TestElement.Status.convert(statusCode);
            TestRunSession.this.registerTestFailureStatus(testElement, status, trace, expectedResult, actualResult);
            Object[] listeners = TestRunSession.this.fSessionListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((ITestSessionListener)listeners[i]).testReran(testCaseElement, status, trace, expectedResult, actualResult);
                ++i;
            }
        }

        private void logUnexpectedTest(String testId, TestElement testElement) {
            JUnitCorePlugin.log(new Exception("Unexpected TestElement type for testId '" + testId + "': " + testElement));
        }
    }
}

