/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.pde.internal.launching.launcher.LaunchArgumentsHelper;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.BaseBlock;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class WorkspaceDataBlock
extends BaseBlock {
    private static final String ATTR_IS_NEWLY_CREATED = "isNewlyCreated";
    private Button fClearWorkspaceCheck;
    private Button fAskClearCheck;
    private Button fClearWorkspaceRadio;
    private Button fClearWorkspaceLogRadio;
    private String fLastKnownName;
    private String fLastKnownLocation;
    private boolean fIsCreatedLaunchConfiguration;

    public WorkspaceDataBlock(AbstractLauncherTab tab) {
        super(tab);
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PDEUIMessages.WorkspaceDataBlock_workspace);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.createText((Composite)group, PDEUIMessages.WorkspaceDataBlock_location, 0);
        Composite buttons = new Composite((Composite)group, 0);
        layout = new GridLayout(7, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        buttons.setLayoutData((Object)gd);
        this.fClearWorkspaceCheck = new Button(buttons, 32);
        this.fClearWorkspaceCheck.setText(PDEUIMessages.WorkspaceDataBlock_clear);
        this.fClearWorkspaceCheck.setLayoutData((Object)new GridData(32));
        this.fClearWorkspaceCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceDataBlock.this.fAskClearCheck.setEnabled(WorkspaceDataBlock.this.fClearWorkspaceCheck.getSelection());
                WorkspaceDataBlock.this.fClearWorkspaceRadio.setEnabled(WorkspaceDataBlock.this.fClearWorkspaceCheck.getSelection());
                WorkspaceDataBlock.this.fClearWorkspaceLogRadio.setEnabled(WorkspaceDataBlock.this.fClearWorkspaceCheck.getSelection());
                WorkspaceDataBlock.this.fTab.updateLaunchConfigurationDialog();
            }
        });
        this.fClearWorkspaceRadio = new Button(buttons, 16);
        this.fClearWorkspaceRadio.setText(PDEUIMessages.WorkspaceDataBlock_clearWorkspace);
        this.fClearWorkspaceRadio.setLayoutData((Object)new GridData(32));
        this.fClearWorkspaceRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceDataBlock.this.fTab.updateLaunchConfigurationDialog();
            }
        });
        this.fClearWorkspaceLogRadio = new Button(buttons, 16);
        this.fClearWorkspaceLogRadio.setText(PDEUIMessages.WorkspaceDataBlock_clearLog);
        this.fClearWorkspaceLogRadio.setLayoutData((Object)new GridData(768));
        this.fClearWorkspaceLogRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspaceDataBlock.this.fTab.updateLaunchConfigurationDialog();
            }
        });
        this.createButtons(buttons, new String[]{PDEUIMessages.BaseBlock_workspace, PDEUIMessages.BaseBlock_filesystem, PDEUIMessages.BaseBlock_variables});
        Composite buttons2 = new Composite((Composite)group, 0);
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons2.setLayout((Layout)layout);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        buttons2.setLayoutData((Object)gd);
        this.fAskClearCheck = new Button(buttons2, 32);
        this.fAskClearCheck.setText(PDEUIMessages.WorkspaceDataBlock_askClear);
        this.fAskClearCheck.addSelectionListener((SelectionListener)this.fListener);
        final Link configureDefaults = new Link(buttons2, 0);
        configureDefaults.setLayoutData((Object)new GridData(0x1000008, 4, true, false));
        configureDefaults.setText("<A>" + PDEUIMessages.WorkspaceDataBlock_configureDefaults + "</A>");
        configureDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)configureDefaults.getShell(), (String)"org.eclipse.pde.ui.MainPreferencePage", (String[])new String[]{"org.eclipse.pde.ui.MainPreferencePage"}, null).open();
            }
        });
    }

    public void performApply(ILaunchConfigurationWorkingCopy config, boolean isJUnit) {
        String currentLocation = this.getLocation();
        String currentName = config.getName();
        if (this.fLastKnownName != null && !this.fLastKnownName.equals(currentName) && currentLocation.equals(this.fLastKnownLocation) && this.fIsCreatedLaunchConfiguration) {
            currentLocation = LaunchArgumentsHelper.getDefaultWorkspaceLocation((String)currentName, (boolean)isJUnit);
            this.fLocationText.setText(currentLocation);
            this.fLastKnownName = currentName;
            this.fLastKnownLocation = currentLocation;
        }
        config.setAttribute("location", currentLocation);
        config.setAttribute("clearws", this.fClearWorkspaceCheck.getSelection());
        config.setAttribute("askclear", this.fAskClearCheck.getSelection());
        config.setAttribute("clearwslog", this.fClearWorkspaceLogRadio.getSelection());
    }

    public void initializeFrom(ILaunchConfiguration configuration, boolean isJUnit) throws CoreException {
        this.fLastKnownName = configuration.getName();
        this.fLastKnownLocation = configuration.getAttribute("location", LaunchArgumentsHelper.getDefaultWorkspaceLocation((String)this.fLastKnownName, (boolean)isJUnit));
        this.fLocationText.setText(this.fLastKnownLocation);
        this.fClearWorkspaceCheck.setSelection(configuration.getAttribute("clearws", false));
        this.fAskClearCheck.setSelection(configuration.getAttribute("askclear", true));
        this.fAskClearCheck.setEnabled(this.fClearWorkspaceCheck.getSelection());
        this.fClearWorkspaceLogRadio.setEnabled(this.fClearWorkspaceCheck.getSelection());
        this.fClearWorkspaceLogRadio.setSelection(configuration.getAttribute("clearwslog", false));
        this.fClearWorkspaceRadio.setEnabled(this.fClearWorkspaceCheck.getSelection());
        this.fClearWorkspaceRadio.setSelection(!configuration.getAttribute("clearwslog", false));
        this.fIsCreatedLaunchConfiguration = configuration instanceof ILaunchConfigurationWorkingCopy ? ((ILaunchConfigurationWorkingCopy)configuration).removeAttribute(ATTR_IS_NEWLY_CREATED) != null : configuration.getAttribute(ATTR_IS_NEWLY_CREATED, false);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration, boolean isJUnit) {
        this.fLastKnownName = configuration.getName();
        this.fLastKnownLocation = LaunchArgumentsHelper.getDefaultWorkspaceLocation((String)this.fLastKnownName, (boolean)isJUnit);
        configuration.setAttribute("location", this.fLastKnownLocation);
        configuration.setAttribute("clearws", isJUnit);
        configuration.setAttribute("askclear", !isJUnit);
        configuration.setAttribute("clearwslog", false);
        configuration.setAttribute(ATTR_IS_NEWLY_CREATED, true);
    }

    protected String getName() {
        return PDEUIMessages.WorkspaceDataBlock_name;
    }

    protected boolean isFile() {
        return false;
    }

    protected void handleBrowseWorkspace() {
        super.handleBrowseWorkspace();
    }

    protected void handleBrowseFileSystem() {
        super.handleBrowseFileSystem();
    }

    public String validate() {
        int length = this.getLocation().length();
        this.fClearWorkspaceCheck.setEnabled(length > 0);
        this.fAskClearCheck.setEnabled(this.fClearWorkspaceCheck.getSelection() && length > 0);
        if (length == 0) {
            this.fClearWorkspaceCheck.setSelection(false);
        }
        return null;
    }

    public void selectWorkspaceLocation() {
        this.fLocationText.setFocus();
        this.fLocationText.selectAll();
    }
}

