/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.preferences.ViewSettingsDialog;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class MarkerViewPreferenceDialog
extends ViewSettingsDialog {
    String enablementKey;
    String limitKey;
    String dialogTitle;
    private IntegerFieldEditor limitEditor;
    private Button enablementButton;
    private Composite editArea;

    public MarkerViewPreferenceDialog(Shell parentShell, String enablementPreference, String limitPreference, String title) {
        super(parentShell);
        this.enablementKey = enablementPreference;
        this.limitKey = limitPreference;
        this.dialogTitle = title;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.dialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite topComposite = (Composite)super.createDialogArea(parent);
        boolean checked = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean(this.enablementKey);
        this.enablementButton = new Button(topComposite, 32);
        this.enablementButton.setText(MarkerMessages.MarkerPreferences_MarkerLimits);
        this.enablementButton.setSelection(checked);
        this.editArea = new Composite(topComposite, 0);
        this.editArea.setLayout((Layout)new GridLayout());
        GridData editData = new GridData(1808);
        editData.horizontalIndent = 10;
        this.editArea.setLayoutData((Object)editData);
        this.limitEditor = new IntegerFieldEditor("limit", MarkerMessages.MarkerPreferences_VisibleItems, this.editArea){

            protected boolean checkState() {
                boolean state = super.checkState();
                Button okButton = MarkerViewPreferenceDialog.this.getButton(0);
                if (okButton != null) {
                    okButton.setEnabled(state);
                }
                return state;
            }
        };
        this.limitEditor.setPreferenceStore(IDEWorkbenchPlugin.getDefault().getPreferenceStore());
        this.limitEditor.setPreferenceName(this.limitKey);
        this.limitEditor.load();
        GridData checkedData = new GridData(4, 0, true, false);
        checkedData.horizontalSpan = this.limitEditor.getNumberOfControls();
        this.enablementButton.setLayoutData((Object)checkedData);
        this.enablementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarkerViewPreferenceDialog.this.setLimitEditorEnablement(MarkerViewPreferenceDialog.this.editArea, MarkerViewPreferenceDialog.this.enablementButton.getSelection());
            }
        });
        this.setLimitEditorEnablement(this.editArea, checked);
        return topComposite;
    }

    private void setLimitEditorEnablement(Composite control, boolean checked) {
        this.limitEditor.setEnabled(checked, control);
    }

    protected void okPressed() {
        this.limitEditor.store();
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue(this.enablementKey, this.enablementButton.getSelection());
        IDEWorkbenchPlugin.getDefault().savePluginPreferences();
        super.okPressed();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.limitEditor.loadDefault();
        boolean checked = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getDefaultBoolean(this.enablementKey);
        this.enablementButton.setSelection(checked);
        this.setLimitEditorEnablement(this.editArea, checked);
    }
}

