/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.IResourceUtilities;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.swt.util.ISWTResourceUtilities;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.BasicPartList;
import org.eclipse.ui.internal.WorkbenchPage;

public class WorkbookEditorsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow workbenchWindow = HandlerUtil.getActiveWorkbenchWindowChecked(event);
        WorkbenchPage page = (WorkbenchPage)workbenchWindow.getActivePage();
        if (page != null) {
            MPartStack activeStack;
            MUIElement area = page.findSharedArea();
            if (area instanceof MPlaceholder) {
                area = ((MPlaceholder)area).getRef();
            }
            if ((activeStack = this.getActiveStack(area)) != null) {
                ISWTResourceUtilities utils = (ISWTResourceUtilities)HandlerUtil.getVariableChecked(event, IResourceUtilities.class.getName());
                EPartService partService = (EPartService)HandlerUtil.getVariableChecked(event, EPartService.class.getName());
                final BasicPartList editorList = new BasicPartList(workbenchWindow.getShell(), 16384, 768, partService, activeStack, utils);
                editorList.setInput();
                Point size = editorList.computeSizeHint();
                editorList.setSize(size.x, size.y);
                Rectangle bounds = workbenchWindow.getShell().getBounds();
                int x = bounds.width / 2 + bounds.x;
                int y = bounds.height / 2 + bounds.y;
                editorList.setLocation(new Point(x -= size.x / 2, y -= size.y / 2));
                editorList.setVisible(true);
                editorList.setFocus();
                editorList.getShell().addListener(27, new Listener(){

                    public void handleEvent(Event event) {
                        editorList.getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                editorList.dispose();
                            }
                        });
                    }
                });
            }
        }
        return null;
    }

    private MPartStack getActiveStack(Object element) {
        if (element instanceof MPartStack) {
            return (MPartStack)element;
        }
        if (element instanceof MElementContainer) {
            return this.getActiveStack(((MElementContainer)element).getSelectedElement());
        }
        return null;
    }
}

