/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.perspectiveswitcher;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.SelectPerspectiveDialog;
import org.eclipse.ui.internal.e4.compatibility.E4Util;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.service.event.EventHandler;

public class PerspectiveSwitcher {
    public static final String PERSPECTIVE_SWITCHER_ID = "org.eclipse.e4.ui.PerspectiveSwitcher";
    @Inject
    protected IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    @Inject
    private MWindow window;
    private MToolControl psME;
    private ToolBar psTB;
    private Composite comp;
    private Image backgroundImage;
    private Image perspectiveImage;
    Color borderColor;
    Color curveColor;
    Control toolParent;
    private EventHandler selectionHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            MWindow switcherWin;
            if (PerspectiveSwitcher.this.psTB.isDisposed()) {
                return;
            }
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (PerspectiveSwitcher.this.psME == null || !(changedElement instanceof MPerspectiveStack)) {
                return;
            }
            MWindow perspWin = PerspectiveSwitcher.this.modelService.getTopLevelWindowFor(changedElement);
            if (perspWin != (switcherWin = PerspectiveSwitcher.this.modelService.getTopLevelWindowFor((MUIElement)PerspectiveSwitcher.this.psME))) {
                return;
            }
            MPerspectiveStack perspStack = (MPerspectiveStack)changedElement;
            if (!perspStack.isToBeRendered()) {
                return;
            }
            MPerspective selElement = (MPerspective)perspStack.getSelectedElement();
            ToolItem[] toolItemArray = PerspectiveSwitcher.this.psTB.getItems();
            int n = toolItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                ToolItem ti;
                ti.setSelection((ti = toolItemArray[n2]).getData() == selElement);
                ++n2;
            }
        }
    };
    private EventHandler toBeRenderedHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            MWindow switcherWin;
            if (PerspectiveSwitcher.this.psTB.isDisposed()) {
                return;
            }
            MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
            if (PerspectiveSwitcher.this.psME == null || !(changedElement instanceof MPerspective)) {
                return;
            }
            MWindow perspWin = PerspectiveSwitcher.this.modelService.getTopLevelWindowFor(changedElement);
            if (perspWin != (switcherWin = PerspectiveSwitcher.this.modelService.getTopLevelWindowFor((MUIElement)PerspectiveSwitcher.this.psME))) {
                return;
            }
            MPerspective persp = (MPerspective)changedElement;
            if (!persp.getParent().isToBeRendered()) {
                return;
            }
            if (changedElement.isToBeRendered()) {
                PerspectiveSwitcher.this.addPerspectiveItem(persp);
            } else {
                PerspectiveSwitcher.this.removePerspectiveItem(persp);
            }
        }
    };
    private EventHandler childrenHandler = new EventHandler(){

        public void handleEvent(org.osgi.service.event.Event event) {
            MWindow switcherWin;
            if (PerspectiveSwitcher.this.psTB.isDisposed()) {
                return;
            }
            Object changedObj = event.getProperty("ChangedElement");
            String eventType = (String)event.getProperty("EventType");
            if (changedObj instanceof MWindow && "ADD".equals(eventType)) {
                MUIElement added = (MUIElement)event.getProperty("NewValue");
                boolean cfr_ignored_0 = added instanceof MPerspectiveStack;
            }
            if (PerspectiveSwitcher.this.psME == null || !(changedObj instanceof MPerspectiveStack)) {
                return;
            }
            MWindow perspWin = PerspectiveSwitcher.this.modelService.getTopLevelWindowFor((MUIElement)changedObj);
            if (perspWin != (switcherWin = PerspectiveSwitcher.this.modelService.getTopLevelWindowFor((MUIElement)PerspectiveSwitcher.this.psME))) {
                return;
            }
            if ("ADD".equals(eventType)) {
                MPerspective added = (MPerspective)event.getProperty("NewValue");
                if (!added.isToBeRendered()) {
                    return;
                }
                PerspectiveSwitcher.this.addPerspectiveItem(added);
            } else if ("REMOVE".equals(eventType)) {
                MPerspective removed = (MPerspective)event.getProperty("OldValue");
                if (!removed.isToBeRendered()) {
                    return;
                }
                PerspectiveSwitcher.this.removePerspectiveItem(removed);
            }
        }
    };

    @PostConstruct
    void init() {
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"children"), this.childrenHandler);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/UIElement", (String)"toBeRendered"), this.toBeRenderedHandler);
        this.eventBroker.subscribe(UIEvents.buildTopic((String)"org/eclipse/e4/ui/model/ui/ElementContainer", (String)"selectedElement"), this.selectionHandler);
    }

    @PreDestroy
    void cleanUp() {
        if (this.perspectiveImage != null) {
            this.perspectiveImage.dispose();
            this.perspectiveImage = null;
        }
        this.eventBroker.unsubscribe(this.toBeRenderedHandler);
        this.eventBroker.unsubscribe(this.childrenHandler);
        this.eventBroker.unsubscribe(this.selectionHandler);
    }

    @PostConstruct
    void createWidget(Composite parent, MToolControl toolControl) {
        this.psME = toolControl;
        this.comp = new Composite(parent, 0);
        RowLayout layout = new RowLayout(256);
        layout.marginRight = 8;
        layout.marginLeft = 8;
        layout.marginBottom = 4;
        layout.marginTop = 6;
        this.comp.setLayout((Layout)layout);
        this.psTB = new ToolBar(this.comp, 8519744);
        this.comp.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                PerspectiveSwitcher.this.paint(e);
            }
        });
        this.toolParent = (Control)toolControl.getParent().getWidget();
        this.toolParent.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (PerspectiveSwitcher.this.borderColor == null) {
                    PerspectiveSwitcher.this.borderColor = e.display.getSystemColor(2);
                }
                e.gc.setForeground(PerspectiveSwitcher.this.borderColor);
                Rectangle bounds = ((Control)e.widget).getBounds();
                e.gc.drawLine(0, bounds.height - 1, bounds.width, bounds.height - 1);
            }
        });
        this.comp.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PerspectiveSwitcher.this.dispose();
            }
        });
        this.psTB.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                ToolBar tb = (ToolBar)e.widget;
                Point p = new Point(e.x, e.y);
                p = PerspectiveSwitcher.this.psTB.getDisplay().map(null, (Control)PerspectiveSwitcher.this.psTB, p);
                ToolItem item = tb.getItem(p);
                if (item == null) {
                    E4Util.message("  ToolBar menu");
                } else {
                    MPerspective persp = (MPerspective)item.getData();
                    if (persp == null) {
                        E4Util.message("  Add button Menu");
                    } else {
                        PerspectiveSwitcher.this.openMenuFor(item, persp);
                    }
                }
            }
        });
        this.psTB.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PerspectiveSwitcher.this.disposeTBImages();
            }
        });
        ToolItem createItem = new ToolItem(this.psTB, 8);
        createItem.setImage(this.getOpenPerspectiveImage());
        createItem.setToolTipText(WorkbenchMessages.OpenPerspectiveDialogAction_tooltip);
        createItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PerspectiveSwitcher.this.selectPerspective();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PerspectiveSwitcher.this.selectPerspective();
            }
        });
        new ToolItem(this.psTB, 2);
        MPerspectiveStack stack = this.getPerspectiveStack();
        if (stack != null) {
            for (MPerspective persp : stack.getChildren()) {
                if (!persp.isToBeRendered()) continue;
                this.addPerspectiveItem(persp);
            }
        }
    }

    private Image getOpenPerspectiveImage() {
        if (this.perspectiveImage == null || this.perspectiveImage.isDisposed()) {
            ImageDescriptor desc = WorkbenchImages.getImageDescriptor("IMG_ETOOL_NEW_PAGE");
            this.perspectiveImage = desc.createImage();
        }
        return this.perspectiveImage;
    }

    MPerspectiveStack getPerspectiveStack() {
        List psList = this.modelService.findElements((MUIElement)this.window, null, MPerspectiveStack.class, null);
        if (psList.size() > 0) {
            return (MPerspectiveStack)psList.get(0);
        }
        return null;
    }

    private ToolItem addPerspectiveItem(MPerspective persp) {
        ImageDescriptor desc;
        final ToolItem psItem = new ToolItem(this.psTB, 16);
        psItem.setData((Object)persp);
        IPerspectiveDescriptor descriptor = this.getDescriptorFor(persp.getElementId());
        boolean foundImage = false;
        if (descriptor != null && (desc = descriptor.getImageDescriptor()) != null) {
            psItem.setImage(desc.createImage(false));
            foundImage = true;
            psItem.setToolTipText(persp.getLocalizedLabel());
        }
        if (!foundImage || PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR")) {
            psItem.setText(persp.getLocalizedLabel());
            psItem.setToolTipText(persp.getLocalizedTooltip());
        }
        psItem.setSelection(persp == persp.getParent().getSelectedElement());
        psItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MPerspective persp = (MPerspective)e.widget.getData();
                persp.getParent().setSelectedElement((MUIElement)persp);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                MPerspective persp = (MPerspective)e.widget.getData();
                persp.getParent().setSelectedElement((MUIElement)persp);
            }
        });
        psItem.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                MPerspective persp = (MPerspective)event.widget.getData();
                PerspectiveSwitcher.this.openMenuFor(psItem, persp);
            }
        });
        this.psTB.pack();
        this.psTB.getShell().layout(new Control[]{this.psTB}, 4);
        return psItem;
    }

    private IPerspectiveDescriptor getDescriptorFor(String id) {
        return PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(id);
    }

    private MPerspective getPerspectiveFor(IPerspectiveDescriptor desc) {
        MPerspectiveStack stack = this.getPerspectiveStack();
        if (stack != null) {
            for (MPerspective persp : stack.getChildren()) {
                if (!persp.getElementId().equals(desc.getId())) continue;
                return persp;
            }
        }
        return null;
    }

    private void openPerspective(PerspectiveDescriptor desc) {
        IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)this.window.getContext().get(IWorkbenchWindow.class);
        IWorkbenchPage page = workbenchWindow.getActivePage();
        if (page == null) {
            try {
                workbenchWindow.openPage(desc.getId(), ((Workbench)workbenchWindow.getWorkbench()).getDefaultPageInput());
            }
            catch (WorkbenchException e) {
                Status errorStatus = new Status(4, WorkbenchPlugin.PI_WORKBENCH, NLS.bind((String)WorkbenchMessages.Workbench_showPerspectiveError, (Object)desc.getLabel()), (Throwable)((Object)e));
                StatusManager.getManager().handle((IStatus)errorStatus, 2);
            }
        } else {
            page.setPerspective(desc);
        }
    }

    private void selectPerspective() {
        SelectPerspectiveDialog dialog = new SelectPerspectiveDialog(this.psTB.getShell(), PlatformUI.getWorkbench().getPerspectiveRegistry());
        dialog.open();
        if (dialog.getReturnCode() == 1) {
            return;
        }
        IPerspectiveDescriptor descriptor = dialog.getSelection();
        if (descriptor != null) {
            MPerspective persp = this.getPerspectiveFor(descriptor);
            if (persp != null) {
                if (!persp.isToBeRendered()) {
                    persp.setToBeRendered(true);
                }
                persp.getParent().setSelectedElement((MUIElement)persp);
            } else {
                this.openPerspective((PerspectiveDescriptor)descriptor);
            }
        }
    }

    private void openMenuFor(ToolItem item, MPerspective persp) {
        final Menu menu = new Menu((Control)this.psTB);
        menu.setData((Object)persp);
        if (persp.isVisible()) {
            this.addCloseItem(menu);
        }
        if (persp.getParent().getSelectedElement() == persp) {
            this.addResetItem(menu);
        }
        new MenuItem(menu, 2);
        this.addShowTextItem(menu);
        Rectangle bounds = item.getBounds();
        Point point = this.psTB.toDisplay(bounds.x, bounds.y + bounds.height);
        menu.setLocation(point.x, point.y);
        menu.setVisible(true);
        menu.addMenuListener(new MenuListener(){

            public void menuHidden(MenuEvent e) {
                PerspectiveSwitcher.this.psTB.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        menu.dispose();
                    }
                });
            }

            public void menuShown(MenuEvent e) {
            }
        });
    }

    private void addCloseItem(final Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(WorkbenchMessages.WorkbenchWindow_close);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MPerspective persp = (MPerspective)menu.getData();
                if (persp != null) {
                    PerspectiveSwitcher.this.closePerspective(persp);
                }
            }
        });
    }

    private void closePerspective(MPerspective persp) {
        MWindow win = this.modelService.getTopLevelWindowFor((MUIElement)persp);
        WorkbenchPage page = (WorkbenchPage)win.getContext().get(IWorkbenchPage.class);
        String perspectiveId = persp.getElementId();
        IPerspectiveDescriptor desc = this.getDescriptorFor(perspectiveId);
        page.closePerspective(desc, perspectiveId, true, false);
    }

    private void addResetItem(final Menu menu) {
        MenuItem menuItem = new MenuItem(menu, 0);
        menuItem.setText(WorkbenchMessages.PerspectiveBar_reset);
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MPerspective persp = (MPerspective)menu.getData();
                if (persp == null) {
                    return;
                }
                IWorkbenchPage page = (IWorkbenchPage)persp.getContext().get(IWorkbenchPage.class);
                String message = NLS.bind((String)WorkbenchMessages.ResetPerspective_message, (Object)persp.getLocalizedLabel());
                if (MessageDialog.openConfirm((Shell)page.getWorkbenchWindow().getShell(), (String)WorkbenchMessages.ResetPerspective_title, (String)message)) {
                    page.resetPerspective();
                }
            }
        });
    }

    private void addShowTextItem(Menu menu) {
        final MenuItem showtextMenuItem = new MenuItem(menu, 32);
        showtextMenuItem.setText(WorkbenchMessages.PerspectiveBar_showText);
        showtextMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean preference = showtextMenuItem.getSelection();
                if (preference != PrefUtil.getAPIPreferenceStore().getDefaultBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR")) {
                    PrefUtil.getInternalPreferenceStore().setValue("overridepresentation", true);
                }
                PrefUtil.getAPIPreferenceStore().setValue("SHOW_TEXT_ON_PERSPECTIVE_BAR", preference);
                PerspectiveSwitcher.this.changeShowText(preference);
            }
        });
        showtextMenuItem.setSelection(PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_TEXT_ON_PERSPECTIVE_BAR"));
    }

    private void changeShowText(boolean showText) {
        ToolItem[] items = this.psTB.getItems();
        int i = 0;
        while (i < items.length) {
            MPerspective persp = (MPerspective)items[i].getData();
            if (persp != null) {
                if (showText) {
                    if (persp.getLabel() != null) {
                        items[i].setText(persp.getLocalizedLabel());
                    }
                    items[i].setToolTipText(persp.getLocalizedTooltip());
                } else {
                    Image image = items[i].getImage();
                    if (image != null) {
                        items[i].setText("");
                        items[i].setToolTipText(persp.getLocalizedLabel());
                    }
                }
            }
            ++i;
        }
        this.psTB.pack();
        this.psTB.getShell().layout(new Control[]{this.psTB}, 4);
    }

    private void removePerspectiveItem(MPerspective toRemove) {
        ToolItem psItem = this.getItemFor(toRemove);
        if (psItem != null) {
            psItem.dispose();
        }
        this.psTB.pack();
        this.psTB.getShell().layout(new Control[]{this.psTB}, 4);
    }

    protected ToolItem getItemFor(MPerspective persp) {
        if (this.psTB == null) {
            return null;
        }
        ToolItem[] toolItemArray = this.psTB.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem ti = toolItemArray[n2];
            if (ti.getData() == persp) {
                return ti;
            }
            ++n2;
        }
        return null;
    }

    void paint(PaintEvent e) {
        GC gc = e.gc;
        Point size = this.comp.getSize();
        if (this.curveColor == null) {
            this.curveColor = e.display.getSystemColor(2);
        }
        int h = size.y;
        int[] nArray = new int[10];
        nArray[1] = h - 1;
        nArray[2] = 1;
        nArray[3] = h - 1;
        nArray[4] = 2;
        nArray[5] = h - 2;
        nArray[6] = 2;
        nArray[7] = 1;
        nArray[8] = 3;
        int[] simpleCurve = nArray;
        gc.setForeground(this.curveColor);
        gc.setAdvanced(true);
        if (gc.getAdvanced()) {
            gc.setAntialias(1);
        }
        gc.drawPolyline(simpleCurve);
        Rectangle bounds = ((Control)e.widget).getBounds();
        bounds.y = 0;
        bounds.x = 0;
        Region r = new Region();
        r.add(bounds);
        int[] simpleCurveClose = new int[simpleCurve.length + 4];
        System.arraycopy(simpleCurve, 0, simpleCurveClose, 0, simpleCurve.length);
        int index = simpleCurve.length;
        simpleCurveClose[index++] = bounds.width;
        simpleCurveClose[index++] = 0;
        simpleCurveClose[index++] = bounds.width;
        simpleCurveClose[index++] = bounds.height;
        r.subtract(simpleCurveClose);
        Region clipping = new Region();
        gc.getClipping(clipping);
        r.intersect(clipping);
        gc.setClipping(r);
        Image b = this.toolParent.getBackgroundImage();
        if (b != null && !b.isDisposed()) {
            gc.drawImage(b, 0, 0);
        }
        r.dispose();
        clipping.dispose();
    }

    void resize() {
        Point size = this.comp.getSize();
        Image oldBackgroundImage = this.backgroundImage;
        this.backgroundImage = new Image((Device)this.comp.getDisplay(), size.x, size.y);
        GC gc = new GC((Drawable)this.backgroundImage);
        this.comp.getParent().drawBackground(gc, 0, 0, size.x, size.y, 0, 0);
        Color background = this.comp.getBackground();
        Color border = this.comp.getDisplay().getSystemColor(18);
        RGB backgroundRGB = background.getRGB();
        Color gradientTop = new Color((Device)this.comp.getDisplay(), backgroundRGB.red + 12, backgroundRGB.green + 10, backgroundRGB.blue + 10);
        int h = size.y;
        int curveStart = 0;
        int curve_width = 5;
        int[] nArray = new int[14];
        nArray[1] = h;
        nArray[2] = 1;
        nArray[3] = h;
        nArray[4] = 2;
        nArray[5] = h - 1;
        nArray[6] = 3;
        nArray[7] = h - 2;
        nArray[8] = 3;
        nArray[9] = 2;
        nArray[10] = 4;
        nArray[11] = 1;
        nArray[12] = 5;
        int[] curve = nArray;
        int[] line1 = new int[curve.length + 4];
        int index = 0;
        int x = curveStart;
        line1[index++] = x + 1;
        line1[index++] = h;
        int i = 0;
        while (i < curve.length / 2) {
            line1[index++] = x + curve[2 * i];
            line1[index++] = curve[2 * i + 1];
            ++i;
        }
        line1[index++] = x + curve_width;
        line1[index++] = 0;
        int[] line2 = new int[line1.length];
        index = 0;
        int i2 = 0;
        while (i2 < line1.length / 2) {
            line2[index] = line1[index++] - 1;
            line2[index] = line1[index++];
            ++i2;
        }
        gc.setForeground(gradientTop);
        gc.setBackground(background);
        gc.drawLine(4, 0, size.x, 0);
        gc.drawLine(3, 1, size.x, 1);
        gc.fillGradientRectangle(2, 2, size.x - 2, size.y - 3, true);
        gc.setForeground(background);
        gc.drawLine(2, size.y - 1, size.x, size.y - 1);
        gradientTop.dispose();
        gc.setForeground(border);
        gc.drawPolyline(line2);
        gc.dispose();
        this.comp.setBackgroundImage(this.backgroundImage);
        if (oldBackgroundImage != null) {
            oldBackgroundImage.dispose();
        }
    }

    void dispose() {
        this.cleanUp();
        if (this.backgroundImage != null) {
            this.comp.setBackgroundImage(null);
            this.backgroundImage.dispose();
            this.backgroundImage = null;
        }
    }

    void disposeTBImages() {
        ToolItem[] items = this.psTB.getItems();
        int i = 0;
        while (i < items.length) {
            Image image = items[i].getImage();
            if (image != null) {
                items[i].setImage(null);
                image.dispose();
            }
            ++i;
        }
    }

    public void setKeylineColor(Color borderColor, Color curveColor) {
        this.borderColor = borderColor;
        this.curveColor = curveColor;
    }
}

