/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.custom;

import java.lang.reflect.Constructor;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.helpers.URI;
import org.eclipse.e4.ui.css.swt.properties.AbstractCSSPropertySWTHandler;
import org.eclipse.e4.ui.internal.css.swt.CSSActivator;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.widgets.CTabFolderRenderer;
import org.eclipse.swt.widgets.Control;
import org.osgi.framework.Bundle;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyTabRendererSWTHandler
extends AbstractCSSPropertySWTHandler {
    public static final ICSSPropertyHandler INSTANCE = new CSSPropertyTabRendererSWTHandler();

    protected void applyCSSProperty(Control control, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (!(control instanceof CTabFolder)) {
            return;
        }
        if (value.getCssValueType() == 1) {
            if (((CSSPrimitiveValue)value).getPrimitiveType() == 20) {
                String rendURL = ((CSSPrimitiveValue)value).getStringValue();
                URI uri = URI.createURI(rendURL);
                Bundle bundle = CSSActivator.getDefault().getBundleForName(uri.segment(1));
                if (bundle != null && uri.segmentCount() <= 3) {
                    String clazz = uri.segment(2);
                    try {
                        Object rend;
                        Class targetClass = bundle.loadClass(clazz);
                        CTabFolderRenderer renderer = ((CTabFolder)control).getRenderer();
                        if (renderer != null && renderer.getClass() == targetClass) {
                            return;
                        }
                        Constructor constructor = targetClass.getConstructor(CTabFolder.class);
                        if (constructor != null && (rend = constructor.newInstance(control)) != null && rend instanceof CTabFolderRenderer) {
                            ((CTabFolder)control).setRenderer((CTabFolderRenderer)rend);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        String message = "Unable to load class '" + clazz + "' from bundle '" + bundle.getBundleId() + "'";
                        System.err.println(message);
                        if (e != null) {
                            e.printStackTrace(System.err);
                        }
                    }
                }
            } else {
                ((CTabFolder)control).setRenderer(null);
            }
        }
    }

    protected String retrieveCSSProperty(Control control, String property, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }
}

