/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.core.identity;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.IIDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.PlatformHelper;
import org.eclipse.ecf.core.util.SystemLogService;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.identity";
    protected static final String NAMESPACE_NAME = "namespace";
    protected static final String NAMESPACE_EPOINT = "org.eclipse.ecf.identity.namespace";
    protected static final String NAME_ATTRIBUTE = "name";
    protected static final String CLASS_ATTRIBUTE = "class";
    protected static final int REMOVE_NAMESPACE_ERRORCODE = 100;
    protected static final int FACTORY_NAME_COLLISION_ERRORCODE = 200;
    protected static final String DESCRIPTION_ATTRIBUTE = "description";
    private static Activator plugin;
    private BundleContext context = null;
    private IRegistryChangeListener registryManager = null;
    private ServiceRegistration idFactoryServiceRegistration = null;
    private ServiceTracker extensionRegistryTracker = null;
    private ServiceTracker debugOptionsTracker = null;
    private ServiceTracker logServiceTracker = null;
    private LogService logService = null;
    private ServiceTracker adapterManagerTracker = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public synchronized IAdapterManager getAdapterManager() {
        IAdapterManager adapterManager;
        if (this.context == null) {
            return null;
        }
        if (this.adapterManagerTracker == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.runtime.IAdapterManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.adapterManagerTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.adapterManagerTracker.open();
        }
        if ((adapterManager = (IAdapterManager)this.adapterManagerTracker.getService()) == null) {
            adapterManager = PlatformHelper.getPlatformAdapterManager();
        }
        if (adapterManager == null) {
            Activator.getDefault().log((IStatus)new Status(4, PLUGIN_ID, 4, "Cannot get adapter manager", null));
        }
        return adapterManager;
    }

    public synchronized IExtensionRegistry getExtensionRegistry() {
        if (this.context == null) {
            return null;
        }
        if (this.extensionRegistryTracker == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.runtime.IExtensionRegistry");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.extensionRegistryTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.extensionRegistryTracker.open();
        }
        return (IExtensionRegistry)this.extensionRegistryTracker.getService();
    }

    public synchronized DebugOptions getDebugOptions() {
        if (this.context == null) {
            return null;
        }
        if (this.debugOptionsTracker == null) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.osgi.service.debug.DebugOptions");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.debugOptionsTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.debugOptionsTracker.open();
        }
        return (DebugOptions)this.debugOptionsTracker.getService();
    }

    public void start(BundleContext ctxt) throws Exception {
        plugin = this;
        this.context = ctxt;
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.ecf.core.identity.IIDFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.idFactoryServiceRegistration = this.context.registerService(clazz.getName(), (Object)IDFactory.getDefault(), null);
        IExtensionRegistry reg = this.getExtensionRegistry();
        if (reg != null) {
            this.registryManager = new IdentityRegistryManager();
            reg.addRegistryChangeListener(this.registryManager);
        }
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    protected void removeNamespaceExtensions(IConfigurationElement[] members) {
        int m = 0;
        while (m < members.length) {
            IConfigurationElement member = members[m];
            String name = null;
            try {
                IIDFactory factory;
                Namespace n;
                name = member.getAttribute(NAME_ATTRIBUTE);
                if (name == null) {
                    name = member.getAttribute(CLASS_ATTRIBUTE);
                }
                if (name != null && (n = (factory = IDFactory.getDefault()).getNamespaceByName(name)) != null && factory.containsNamespace(n)) {
                    factory.removeNamespace(n);
                }
            }
            catch (Exception e) {
                Activator.getDefault().log((IStatus)new Status(4, PLUGIN_ID, 100, "Exception removing namespace", (Throwable)e));
            }
            ++m;
        }
    }

    public Bundle getBundle() {
        if (this.context == null) {
            return null;
        }
        return this.context.getBundle();
    }

    protected synchronized LogService getLogService() {
        if (this.context == null) {
            if (this.logService == null) {
                this.logService = new SystemLogService(PLUGIN_ID);
            }
            return this.logService;
        }
        if (this.logServiceTracker == null) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.osgi.service.log.LogService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.logServiceTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.logServiceTracker.open();
        }
        this.logService = (LogService)this.logServiceTracker.getService();
        if (this.logService == null) {
            this.logService = new SystemLogService(PLUGIN_ID);
        }
        return this.logService;
    }

    public void log(IStatus status) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(LogHelper.getLogCode(status), LogHelper.getLogMessage(status), status.getException());
        }
    }

    protected void addNamespaceExtensions(IConfigurationElement[] members) {
        String bundleName = Activator.getDefault().getBundle().getSymbolicName();
        int m = 0;
        while (m < members.length) {
            IConfigurationElement member = members[m];
            IExtension extension = member.getDeclaringExtension();
            String nsName = null;
            try {
                Namespace ns = (Namespace)member.createExecutableExtension(CLASS_ATTRIBUTE);
                String clazz = ns.getClass().getName();
                nsName = member.getAttribute(NAME_ATTRIBUTE);
                if (nsName == null) {
                    nsName = clazz;
                }
                String nsDescription = member.getAttribute(DESCRIPTION_ATTRIBUTE);
                ns.initialize(nsName, nsDescription);
                if (!IDFactory.containsNamespace0(ns)) {
                    IDFactory.addNamespace0(ns);
                }
            }
            catch (CoreException e) {
                Activator.getDefault().log(e.getStatus());
            }
            catch (Exception e) {
                Activator.getDefault().log((IStatus)new Status(4, bundleName, 200, "name=" + nsName + ";extension point id=" + extension.getExtensionPointUniqueIdentifier(), null));
            }
            ++m;
        }
    }

    public void setupNamespaceExtensionPoint() {
        IExtensionRegistry reg = this.getExtensionRegistry();
        if (reg != null) {
            IExtensionPoint extensionPoint = reg.getExtensionPoint(NAMESPACE_EPOINT);
            if (extensionPoint == null) {
                return;
            }
            this.addNamespaceExtensions(extensionPoint.getConfigurationElements());
        }
    }

    public void stop(BundleContext ctxt) throws Exception {
        IExtensionRegistry reg = this.getExtensionRegistry();
        if (reg != null) {
            reg.removeRegistryChangeListener(this.registryManager);
        }
        this.registryManager = null;
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
            this.logService = null;
        }
        if (this.debugOptionsTracker != null) {
            this.debugOptionsTracker.close();
            this.debugOptionsTracker = null;
        }
        if (this.extensionRegistryTracker != null) {
            this.extensionRegistryTracker.close();
            this.extensionRegistryTracker = null;
        }
        if (this.idFactoryServiceRegistration != null) {
            this.idFactoryServiceRegistration.unregister();
            this.idFactoryServiceRegistration = null;
        }
        if (this.adapterManagerTracker != null) {
            this.adapterManagerTracker.close();
            this.adapterManagerTracker = null;
        }
        this.context = null;
        plugin = null;
    }

    public static synchronized Activator getDefault() {
        if (plugin == null) {
            plugin = new Activator();
        }
        return plugin;
    }

    protected class IdentityRegistryManager
    implements IRegistryChangeListener {
        protected IdentityRegistryManager() {
        }

        public void registryChanged(IRegistryChangeEvent event) {
            IExtensionDelta[] delta = event.getExtensionDeltas(Activator.PLUGIN_ID, Activator.NAMESPACE_NAME);
            int i = 0;
            while (i < delta.length) {
                switch (delta[i].getKind()) {
                    case 1: {
                        Activator.this.addNamespaceExtensions(delta[i].getExtension().getConfigurationElements());
                        break;
                    }
                    case 2: {
                        Activator.this.removeNamespaceExtensions(delta[i].getExtension().getConfigurationElements());
                    }
                }
                ++i;
            }
        }
    }
}

