/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.internal.workbench.PartActivationHistory;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericStack;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MInputPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.IPartListener;
import org.eclipse.e4.ui.workbench.modeling.ISaveHandler;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartServiceImpl
implements EPartService {
    private EventHandler selectedHandler = new EventHandler(){

        public void handleEvent(Event event) {
            if (!PartServiceImpl.this.listeners.isEmpty()) {
                MPart selectedPart;
                Object selected;
                Object oldSelected = event.getProperty("OldValue");
                if (oldSelected instanceof MPlaceholder) {
                    oldSelected = ((MPlaceholder)oldSelected).getRef();
                }
                if ((selected = event.getProperty("NewValue")) instanceof MPlaceholder) {
                    selected = ((MPlaceholder)selected).getRef();
                }
                MPart oldSelectedPart = oldSelected instanceof MPart ? (MPart)oldSelected : null;
                MPart mPart = selectedPart = selected instanceof MPart ? (MPart)selected : null;
                if (oldSelectedPart != null && PartServiceImpl.this.getParts().contains(selectedPart)) {
                    PartServiceImpl.this.firePartHidden(oldSelectedPart);
                }
                if (selectedPart != null && selectedPart.isToBeRendered() && PartServiceImpl.this.getParts().contains(selectedPart)) {
                    MPlaceholder placeholder = selectedPart.getCurSharedRef();
                    if (placeholder == null) {
                        if (selectedPart.getParent().getRenderer() != null) {
                            PartServiceImpl.this.engine.createGui((MUIElement)selectedPart);
                            PartServiceImpl.this.firePartVisible(selectedPart);
                            PartServiceImpl.this.firePartBroughtToTop(selectedPart);
                        }
                    } else if (placeholder.getParent().getRenderer() != null) {
                        PartServiceImpl.this.engine.createGui((MUIElement)placeholder);
                        PartServiceImpl.this.firePartVisible(selectedPart);
                        PartServiceImpl.this.firePartBroughtToTop(selectedPart);
                    }
                }
            }
        }
    };
    private MApplication application;
    private MWindow workbenchWindow;
    @Inject
    private IPresentationEngine engine;
    @Inject
    private EModelService modelService;
    @Inject
    private Logger logger;
    @Inject
    @Optional
    private ISaveHandler saveHandler;
    @Inject
    private IEventBroker eventBroker;
    private PartActivationHistory partActivationHistory;
    private MPart activePart;
    private ListenerList listeners = new ListenerList();
    private boolean constructed = false;

    @Inject
    public PartServiceImpl(MApplication application, @Optional MWindow window) {
        this.application = application;
        this.workbenchWindow = window;
    }

    private void log(String unidentifiedMessage, String identifiedMessage, String id, Exception e) {
        if (id == null || id.length() == 0) {
            this.logger.error((Throwable)e, unidentifiedMessage);
        } else {
            this.logger.error((Throwable)e, NLS.bind((String)identifiedMessage, (Object)id));
        }
    }

    @Inject
    void setPart(@Optional @Named(value="e4ActivePart") MPart p) {
        if (this.activePart != p) {
            MPart lastActivePart = this.activePart;
            this.activePart = p;
            if (this.constructed && !this.listeners.isEmpty()) {
                if (lastActivePart != null && lastActivePart != this.activePart) {
                    this.firePartDeactivated(lastActivePart);
                }
                if (this.activePart != null) {
                    this.firePartActivated(this.activePart);
                }
            }
        }
    }

    @PostConstruct
    void postConstruct() {
        this.eventBroker.subscribe(UIEvents.buildTopic("org/eclipse/e4/ui/model/ui/ElementContainer", "selectedElement"), this.selectedHandler);
        this.constructed = true;
        this.partActivationHistory = new PartActivationHistory(this, this.modelService);
        if (this.activePart != null) {
            this.partActivationHistory.prepend(this.activePart);
        }
    }

    @PreDestroy
    void preDestroy() {
        this.constructed = false;
        this.eventBroker.unsubscribe(this.selectedHandler);
        this.partActivationHistory.clear();
    }

    private void firePartActivated(final MPart part) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ((IPartListener)listener).partActivated(part);
                }

                public void handleException(Throwable throwable) {
                    PartServiceImpl.this.logger.error(throwable, "An exception occurred while notifying part listeners");
                }
            });
            ++n2;
        }
    }

    private void firePartDeactivated(final MPart part) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ((IPartListener)listener).partDeactivated(part);
                }

                public void handleException(Throwable throwable) {
                    PartServiceImpl.this.logger.error(throwable, "An exception occurred while notifying part listeners");
                }
            });
            ++n2;
        }
    }

    private void firePartHidden(final MPart part) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ((IPartListener)listener).partHidden(part);
                }

                public void handleException(Throwable throwable) {
                    PartServiceImpl.this.logger.error(throwable, "An exception occurred while notifying part listeners");
                }
            });
            ++n2;
        }
    }

    private void firePartVisible(final MPart part) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ((IPartListener)listener).partVisible(part);
                }

                public void handleException(Throwable throwable) {
                    PartServiceImpl.this.logger.error(throwable, "An exception occurred while notifying part listeners");
                }
            });
            ++n2;
        }
    }

    private void firePartBroughtToTop(final MPart part) {
        Object[] objectArray = this.listeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object listener = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    ((IPartListener)listener).partBroughtToTop(part);
                }

                public void handleException(Throwable throwable) {
                    PartServiceImpl.this.logger.error(throwable, "An exception occurred while notifying part listeners");
                }
            });
            ++n2;
        }
    }

    @Override
    public void addPartListener(IPartListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removePartListener(IPartListener listener) {
        this.listeners.remove((Object)listener);
    }

    private MWindow getWindow() {
        if (this.workbenchWindow != null) {
            return this.workbenchWindow;
        }
        if (this.application.getSelectedElement() != null) {
            return (MWindow)this.application.getSelectedElement();
        }
        List windows = this.application.getChildren();
        if (windows.size() != 0) {
            return (MWindow)windows.get(0);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private MContext getParentWithContext(MUIElement part) {
        block4: {
            parent = part.getParent();
            intermediate = parent;
            if (intermediate != null) ** GOTO lbl10
            intermediate = part;
            break block4;
lbl-1000:
            // 1 sources

            {
                if (parent instanceof MContext && ((MContext)parent).getContext() != null) {
                    return (MContext)parent;
                }
                intermediate = parent;
                parent = parent.getParent();
lbl10:
                // 2 sources

                ** while (parent != null)
            }
        }
        placeholder = this.modelService.findPlaceholderFor(this.getWindow(), (MUIElement)intermediate);
        parent = placeholder.getParent();
        while (parent != null) {
            if (parent instanceof MContext && ((MContext)parent).getContext() != null) {
                return (MContext)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @Override
    public void bringToTop(MPart part) {
        if (this.isInContainer((MUIElement)part)) {
            MPart currentElement = part;
            MElementContainer parent = part.getParent();
            if (parent == null) {
                currentElement = this.modelService.findPlaceholderFor(this.getWindow(), (MUIElement)part);
                parent = currentElement.getParent();
            }
            MUIElement oldSelectedElement = parent.getSelectedElement();
            this.modelService.bringToTop((MUIElement)part);
            if (oldSelectedElement != currentElement && parent.getChildren().contains(oldSelectedElement) && parent instanceof MGenericStack) {
                if (oldSelectedElement instanceof MPlaceholder) {
                    oldSelectedElement = ((MPlaceholder)oldSelectedElement).getRef();
                }
                this.internalFixContext(part, oldSelectedElement);
            }
        }
    }

    private IEclipseContext getSubContext(MUIElement element) {
        if (element instanceof MContext) {
            return ((MContext)element).getContext();
        }
        if (element instanceof MElementContainer) {
            MUIElement selectedElement = ((MElementContainer)element).getSelectedElement();
            if (selectedElement instanceof MContext) {
                return ((MContext)selectedElement).getContext();
            }
            if (selectedElement instanceof MElementContainer) {
                return this.getSubContext(selectedElement);
            }
        }
        return null;
    }

    private void internalFixContext(MPart part, MUIElement oldSelectedElement) {
        if (oldSelectedElement == null) {
            return;
        }
        MContext parentPart = this.getParentWithContext(oldSelectedElement);
        if (parentPart == null) {
            return;
        }
        IEclipseContext parentContext = parentPart.getContext();
        IEclipseContext oldContext = this.getSubContext(oldSelectedElement);
        IEclipseContext child = parentContext.getActiveChild();
        if (child == null || oldContext == null || child == oldContext) {
            if (part == null) {
                IEclipseContext currentActive = parentContext.getActiveChild();
                if (currentActive != null) {
                    currentActive.deactivate();
                }
            } else {
                part.getContext().activate();
            }
        }
    }

    @Override
    public MPart findPart(String id) {
        List<MPart> parts = this.getParts(MPart.class, id);
        return parts.size() > 0 ? parts.get(0) : null;
    }

    private <T> List<T> getParts(Class<T> cls, String id) {
        return this.modelService.findElements((MUIElement)this.workbenchWindow, id, cls, null, 11);
    }

    @Override
    public Collection<MPart> getParts() {
        return this.getParts(MPart.class, null);
    }

    @Override
    public boolean isPartVisible(MPart part) {
        if (this.isInContainer((MUIElement)part)) {
            MPart element = part;
            MElementContainer parent = part.getParent();
            if (parent == null) {
                element = part.getCurSharedRef();
                if (element == null) {
                    return false;
                }
                parent = element.getParent();
                if (parent == null) {
                    return false;
                }
            }
            if (parent instanceof MPartStack) {
                return parent.getSelectedElement() == element;
            }
            return element.isVisible();
        }
        return false;
    }

    private boolean isInContainer(MUIElement element) {
        List<MUIElement> allPerspectiveElements = this.modelService.findElements((MUIElement)this.workbenchWindow, null, MUIElement.class, null, 11);
        return allPerspectiveElements.contains(element);
    }

    boolean isInContainer(MElementContainer<?> container, MUIElement element) {
        for (Object object : container.getChildren()) {
            if (object == element) {
                return true;
            }
            if (object instanceof MElementContainer) {
                if (!this.isInContainer((MElementContainer)object, element)) continue;
                return true;
            }
            if (object instanceof MPlaceholder) {
                MUIElement ref = ((MPlaceholder)object).getRef();
                if (ref == element) {
                    return true;
                }
                if (!(ref instanceof MElementContainer) || !this.isInContainer((MElementContainer)ref, element)) continue;
                return true;
            }
            if (object instanceof MPerspective) {
                MPerspective persp = (MPerspective)object;
                for (MWindow dw : persp.getWindows()) {
                    if (!this.isInContainer((MElementContainer<?>)dw, element)) continue;
                    return true;
                }
                continue;
            }
            if (!(object instanceof MWindow)) continue;
            MWindow win = (MWindow)object;
            for (MWindow dw : win.getWindows()) {
                if (!this.isInContainer((MElementContainer<?>)dw, element)) continue;
                return true;
            }
        }
        if (container instanceof MWindow) {
            MWindow win = (MWindow)container;
            for (MWindow dw : win.getWindows()) {
                if (!this.isInContainer((MElementContainer<?>)dw, element)) continue;
                return true;
            }
        }
        if (container instanceof MPerspective) {
            MPerspective persp = (MPerspective)container;
            for (MWindow dw : persp.getWindows()) {
                if (!this.isInContainer((MElementContainer<?>)dw, element)) continue;
                return true;
            }
        }
        return false;
    }

    MPlaceholder getLocalPlaceholder(MUIElement part) {
        return this.modelService.findPlaceholderFor(this.getWindow(), part);
    }

    @Override
    public void switchPerspective(MPerspective perspective) {
        Assert.isNotNull((Object)perspective);
        MWindow window = this.getWindow();
        if (window != null && this.isInContainer((MElementContainer<?>)window, (MUIElement)perspective)) {
            MPart candidate;
            perspective.getParent().setSelectedElement((MUIElement)perspective);
            List<MPart> newPerspectiveParts = this.modelService.findElements((MUIElement)perspective, null, MPart.class, null);
            if (newPerspectiveParts.contains(this.activePart) && this.partActivationHistory.isValid(perspective, (MUIElement)this.activePart)) {
                MPart target = this.activePart;
                IEclipseContext activeChild = this.activePart.getContext().getParent().getActiveChild();
                if (activeChild != null) {
                    activeChild.deactivate();
                }
                perspective.getContext().activate();
                this.modelService.bringToTop((MUIElement)target);
                this.activate(target, true, false);
                return;
            }
            MPart newActivePart = (MPart)perspective.getContext().getActiveLeaf().get(MPart.class);
            if (newActivePart == null && (candidate = this.partActivationHistory.getActivationCandidate(perspective)) != null) {
                this.modelService.bringToTop((MUIElement)candidate);
                this.partActivationHistory.activate(candidate, false);
                return;
            }
            if (newActivePart == null) {
                this.modelService.bringToTop((MUIElement)perspective);
                perspective.getContext().activate();
            } else {
                this.activate(newActivePart, true, false);
            }
        }
    }

    @Override
    public void activate(MPart part) {
        this.activate(part, true);
    }

    @Override
    public void activate(MPart part, boolean requiresFocus) {
        this.activate(part, requiresFocus, true);
    }

    private void activate(MPart part, boolean requiresFocus, boolean activateBranch) {
        if (!this.isInContainer((MUIElement)part)) {
            return;
        }
        MWindow window = this.getWindow();
        IEclipseContext windowContext = window.getContext();
        if (windowContext.getParent().getActiveChild() == windowContext && part == this.activePart) {
            this.partActivationHistory.prepend(part);
            return;
        }
        this.recordStackActivation(part);
        this.modelService.bringToTop((MUIElement)part);
        window.getParent().setSelectedElement((MUIElement)window);
        Object object = part.getObject();
        if (object != null && requiresFocus) {
            try {
                ContextInjectionFactory.invoke((Object)object, Focus.class, (IEclipseContext)part.getContext(), null);
            }
            catch (InjectionException e) {
                this.log("Failed to grant focus to part", "Failed to grant focus to part ({0})", part.getElementId(), (Exception)((Object)e));
            }
            catch (RuntimeException e) {
                this.log("Failed to grant focus to part via DI", "Failed to grant focus via DI to part ({0})", part.getElementId(), e);
            }
        }
        this.partActivationHistory.activate(part, activateBranch);
    }

    private void recordStackActivation(MPart part) {
        MPlaceholder placeholder;
        MElementContainer parent = part.getParent();
        if (parent instanceof MGenericStack) {
            this.recordSelectedActivation((MElementContainer<? extends MUIElement>)parent);
        } else if (parent == null && (placeholder = part.getCurSharedRef()) != null && (parent = placeholder.getParent()) instanceof MGenericStack) {
            this.recordSelectedActivation((MElementContainer<? extends MUIElement>)parent);
        }
    }

    private void recordSelectedActivation(MElementContainer<? extends MUIElement> parent) {
        MUIElement ref;
        MUIElement selectedElement = parent.getSelectedElement();
        if (selectedElement instanceof MPart) {
            this.partActivationHistory.append((MPart)selectedElement);
        } else if (selectedElement instanceof MPlaceholder && (ref = ((MPlaceholder)selectedElement).getRef()) instanceof MPart) {
            this.partActivationHistory.append((MPart)ref);
        }
    }

    @Override
    public MPart getActivePart() {
        return this.activePart;
    }

    private MPartDescriptor findDescriptor(String id) {
        for (MPartDescriptor descriptor : this.application.getDescriptors()) {
            if (!descriptor.getElementId().equals(id)) continue;
            return descriptor;
        }
        return null;
    }

    private MPart createPart(MPartDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setElementId(descriptor.getElementId());
        part.getMenus().addAll(EcoreUtil.copyAll((Collection)descriptor.getMenus()));
        if (descriptor.getToolbar() != null) {
            part.setToolbar((MToolBar)EcoreUtil.copy((EObject)((EObject)descriptor.getToolbar())));
        }
        part.setContributorURI(descriptor.getContributorURI());
        part.setCloseable(descriptor.isCloseable());
        part.setContributionURI(descriptor.getContributionURI());
        part.setLabel(descriptor.getLabel());
        part.setIconURI(descriptor.getIconURI());
        part.setTooltip(descriptor.getTooltip());
        part.getHandlers().addAll(EcoreUtil.copyAll((Collection)descriptor.getHandlers()));
        part.getTags().addAll(descriptor.getTags());
        part.getBindingContexts().addAll(descriptor.getBindingContexts());
        return part;
    }

    @Override
    public MPart createPart(String id) {
        MPartDescriptor descriptor = this.findDescriptor(id);
        return this.createPart(descriptor);
    }

    @Override
    public MPlaceholder createSharedPart(String id) {
        return this.createSharedPart(id, false);
    }

    @Override
    public MPlaceholder createSharedPart(String id, boolean force) {
        MWindow sharedWindow = this.getWindow();
        MPart sharedPart = null;
        if (!force) {
            for (MUIElement element : sharedWindow.getSharedElements()) {
                if (!element.getElementId().equals(id)) continue;
                sharedPart = (MPart)element;
                break;
            }
        }
        if (sharedPart == null) {
            MPartDescriptor descriptor = this.findDescriptor(id);
            sharedPart = this.createPart(descriptor);
            if (sharedPart == null) {
                return null;
            }
            sharedWindow.getSharedElements().add(sharedPart);
        }
        return this.createSharedPart(sharedPart);
    }

    private MPlaceholder createSharedPart(MPart sharedPart) {
        MPlaceholder sharedPartRef = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        sharedPartRef.setElementId(sharedPart.getElementId());
        sharedPartRef.setRef((MUIElement)sharedPart);
        return sharedPartRef;
    }

    private MPart addPart(MPart providedPart, MPart localPart) {
        MPartDescriptor descriptor = this.findDescriptor(providedPart.getElementId());
        if (descriptor == null) {
            if (!this.isInContainer((MUIElement)providedPart)) {
                this.adjustPlaceholder(providedPart);
                this.addToLastContainer(null, providedPart);
            }
        } else {
            if (providedPart != localPart && !descriptor.isAllowMultiple()) {
                return localPart;
            }
            if (this.isInContainer((MUIElement)providedPart)) {
                return providedPart;
            }
            this.adjustPlaceholder(providedPart);
            String category = descriptor.getCategory();
            if (category == null) {
                this.addToLastContainer(null, providedPart);
            } else if ("org.eclipse.e4.primaryDataStack".equals(category)) {
                MElementContainer<MUIElement> container = this.getContainer();
                MUIElement area = this.modelService.find("org.eclipse.ui.editorss", (MUIElement)container);
                List<MPartStack> sharedStacks = this.modelService.findElements(area, null, MPartStack.class, null);
                if (sharedStacks.size() > 0) {
                    for (MPartStack stack : sharedStacks) {
                        if (!stack.isToBeRendered()) continue;
                        stack.getChildren().add(providedPart);
                        break;
                    }
                } else {
                    this.addToLastContainer(null, providedPart);
                }
            } else {
                List<MElementContainer> containers = this.modelService.findElements((MUIElement)this.getContainer(), null, MElementContainer.class, Collections.singletonList(category));
                if (containers.isEmpty()) {
                    this.addToLastContainer(category, providedPart);
                } else {
                    MElementContainer container = containers.get(0);
                    MPlaceholder placeholder = providedPart.getCurSharedRef();
                    if (placeholder == null) {
                        container.getChildren().add(providedPart);
                    } else {
                        container.getChildren().add(placeholder);
                    }
                }
            }
        }
        return providedPart;
    }

    private void adjustPlaceholder(MPart part) {
        MPlaceholder placeholder;
        if (this.isShared(part) && ((placeholder = part.getCurSharedRef()) == null || placeholder.getParent() != null && !this.isInContainer((MUIElement)placeholder))) {
            placeholder = this.createSharedPart(part);
            part.setCurSharedRef(placeholder);
        }
    }

    private boolean isShared(MPart part) {
        return this.getWindow().getSharedElements().contains(part);
    }

    private void addToLastContainer(String category, MPart part) {
        MElementContainer<?> lastContainer = this.getLastContainer();
        MPlaceholder placeholder = part.getCurSharedRef();
        if (placeholder == null) {
            lastContainer.getChildren().add(part);
        } else {
            lastContainer.getChildren().add(placeholder);
        }
        if (category != null) {
            lastContainer.getTags().add(category);
        }
    }

    private MElementContainer<?> getLastContainer() {
        MElementContainer<MUIElement> searchRoot = this.getContainer();
        List children = searchRoot.getChildren();
        if (children.size() == 0) {
            MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
            searchRoot.getChildren().add(stack);
            return stack;
        }
        MElementContainer<?> lastContainer = this.getLastContainer(searchRoot, children);
        if (lastContainer == null) {
            MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
            searchRoot.getChildren().add(stack);
            return stack;
        }
        if (!(lastContainer instanceof MPartStack)) {
            MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
            lastContainer.getChildren().add(stack);
            return stack;
        }
        return lastContainer;
    }

    private MElementContainer<?> getLastContainer(MElementContainer<?> container, List<?> children) {
        if (children.isEmpty()) {
            return null;
        }
        int i = children.size() - 1;
        while (i > -1) {
            MElementContainer childContainer;
            MElementContainer<?> lastContainer;
            Object muiElement = children.get(i);
            if (muiElement instanceof MElementContainer && (lastContainer = this.getLastContainer(childContainer = (MElementContainer)muiElement, childContainer.getChildren())) != null) {
                return lastContainer;
            }
            --i;
        }
        return container;
    }

    private MElementContainer<MUIElement> getParent(MUIElement element) {
        MElementContainer parent = element.getParent();
        if (parent == null) {
            MPlaceholder placeholder = element.getCurSharedRef();
            if (placeholder == null) {
                MElementContainer<MUIElement> container = this.getContainer();
                return this.findContainer(container, element);
            }
            return placeholder.getParent();
        }
        return parent;
    }

    private MElementContainer<MUIElement> findContainer(MElementContainer<?> container, MUIElement element) {
        for (Object child : container.getChildren()) {
            MElementContainer<MUIElement> match;
            if (child == element) {
                return container;
            }
            if (child instanceof MPlaceholder) {
                MElementContainer<MUIElement> match2;
                MPlaceholder placeholder = (MPlaceholder)child;
                MUIElement ref = placeholder.getRef();
                if (ref == element) {
                    return container;
                }
                if (!(ref instanceof MElementContainer) || (match2 = this.findContainer((MElementContainer)ref, element)) == null) continue;
                return match2;
            }
            if (!(child instanceof MElementContainer) || (match = this.findContainer((MElementContainer)child, element)) == null) continue;
            return match;
        }
        return null;
    }

    private MUIElement getRemoveTarget(MPart part) {
        MPlaceholder placeholder = this.getLocalPlaceholder((MUIElement)part);
        return placeholder == null ? part : placeholder;
    }

    public MPart addPart(MPart part) {
        Assert.isNotNull((Object)part);
        MPart localPart = this.findPart(part.getElementId());
        return this.addPart(part, localPart == null ? part : localPart);
    }

    @Override
    public MPart showPart(String id, EPartService.PartState partState) {
        MPartDescriptor descriptor;
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)((Object)partState));
        MPart part = this.findPart(id);
        if (part == null && (part = this.createPart(descriptor = this.findDescriptor(id))) == null) {
            return null;
        }
        return this.showPart(this.addPart(part), partState);
    }

    @Override
    public MPart showPart(MPart part, EPartService.PartState partState) {
        Assert.isNotNull((Object)part);
        Assert.isNotNull((Object)((Object)partState));
        MPart addedPart = this.addPart(part);
        MPlaceholder localPlaceholder = this.getLocalPlaceholder((MUIElement)addedPart);
        if (localPlaceholder != null && addedPart.getCurSharedRef() != localPlaceholder) {
            addedPart.setCurSharedRef(localPlaceholder);
        }
        switch (partState) {
            case ACTIVATE: {
                this.activate(addedPart);
                return addedPart;
            }
            case VISIBLE: {
                MPart activePart = this.getActivePart();
                if (activePart == null || this.getParent((MUIElement)activePart) == this.getParent((MUIElement)addedPart)) {
                    this.activate(addedPart);
                } else {
                    this.bringToTop(addedPart);
                }
                return addedPart;
            }
            case CREATE: {
                MPlaceholder placeholder = addedPart.getCurSharedRef();
                if (placeholder != null) {
                    addedPart.setToBeRendered(true);
                    this.createElement((MUIElement)placeholder);
                } else {
                    this.createElement((MUIElement)addedPart);
                }
                return addedPart;
            }
        }
        return addedPart;
    }

    private void createElement(MUIElement element) {
        element.setToBeRendered(true);
        MElementContainer parent = element.getParent();
        while (parent != null) {
            parent.setToBeRendered(true);
            parent = parent.getParent();
        }
        this.engine.createGui(element);
        parent = element.getParent();
        if (parent.getChildren().size() == 1) {
            parent.setSelectedElement(element);
        }
    }

    @Override
    public void requestActivation() {
        MPart candidate;
        if (this.activePart == null) {
            MPart candidate2 = this.partActivationHistory.getActivationCandidate(this.getParts());
            if (candidate2 != null) {
                this.activate(candidate2);
            }
        } else if (!this.getParts().contains(this.activePart) && (candidate = this.partActivationHistory.getNextActivationCandidate(this.getParts(), this.activePart)) != null) {
            this.activate(candidate);
        }
    }

    @Override
    public void hidePart(MPart part) {
        this.hidePart(part, false);
    }

    @Override
    public void hidePart(MPart part, boolean force) {
        if (this.isInContainer((MUIElement)part)) {
            MPlaceholder sharedRef = part.getCurSharedRef();
            MUIElement toBeRemoved = this.getRemoveTarget(part);
            MElementContainer<MUIElement> parent = this.getParent(toBeRemoved);
            List children = parent.getChildren();
            if (toBeRemoved != part && toBeRemoved instanceof MPlaceholder && sharedRef != toBeRemoved) {
                toBeRemoved.setToBeRendered(false);
                if (force || part.getTags().contains("removeOnHide")) {
                    parent.getChildren().remove(toBeRemoved);
                }
                return;
            }
            boolean isActiveChild = this.isActiveChild(part);
            MPart activationCandidate = null;
            if (isActiveChild) {
                activationCandidate = this.partActivationHistory.getNextActivationCandidate(this.getParts(), part);
            }
            if (parent.getSelectedElement() == toBeRemoved) {
                MUIElement candidate = this.partActivationHistory.getSiblingSelectionCandidate(part);
                Object object = candidate == null ? null : (candidate = candidate.getCurSharedRef() == null ? candidate : candidate.getCurSharedRef());
                if (candidate != null && children.contains(candidate)) {
                    parent.setSelectedElement(candidate);
                } else {
                    for (MUIElement child : children) {
                        if (child == toBeRemoved || !child.isToBeRendered()) continue;
                        parent.setSelectedElement(child);
                        break;
                    }
                }
            }
            if (activationCandidate == null) {
                if (isActiveChild) {
                    part.getContext().deactivate();
                }
            } else {
                this.activate(activationCandidate);
            }
            if (toBeRemoved != null) {
                toBeRemoved.setToBeRendered(false);
            } else {
                part.setToBeRendered(false);
            }
            if (parent.getSelectedElement() == toBeRemoved) {
                parent.setSelectedElement(null);
            }
            if (force || part.getTags().contains("removeOnHide")) {
                children.remove(toBeRemoved);
            }
            this.partActivationHistory.forget(this.getWindow(), part, toBeRemoved == part);
        }
    }

    private boolean isActiveChild(MPart part) {
        IEclipseContext context = part.getContext();
        return context != null && context.getParent().getActiveChild() == context;
    }

    @Override
    public Collection<MPart> getDirtyParts() {
        ArrayList<MPart> dirtyParts = new ArrayList<MPart>();
        for (MPart part : this.getParts()) {
            if (!part.isDirty()) continue;
            dirtyParts.add(part);
        }
        return dirtyParts;
    }

    @Override
    public boolean savePart(MPart part, boolean confirm) {
        if (!part.isDirty()) {
            return true;
        }
        if (confirm && this.saveHandler != null) {
            switch (this.saveHandler.promptToSave(part)) {
                case NO: {
                    return true;
                }
                case CANCEL: {
                    return false;
                }
            }
        }
        Object client = part.getObject();
        try {
            ContextInjectionFactory.invoke((Object)client, Persist.class, (IEclipseContext)part.getContext());
        }
        catch (InjectionException e) {
            this.log("Failed to persist contents of part", "Failed to persist contents of part ({0})", part.getElementId(), (Exception)((Object)e));
            return false;
        }
        catch (RuntimeException e) {
            this.log("Failed to persist contents of part via DI", "Failed to persist contents of part ({0}) via DI", part.getElementId(), e);
            return false;
        }
        return true;
    }

    @Override
    public boolean saveAll(boolean confirm) {
        Collection<MPart> dirtyParts = this.getDirtyParts();
        if (dirtyParts.isEmpty()) {
            return true;
        }
        if (confirm && this.saveHandler != null) {
            ISaveHandler.Save[] decisions;
            List<MPart> dirtyPartsList = Collections.unmodifiableList(new ArrayList<MPart>(dirtyParts));
            ISaveHandler.Save[] saveArray = decisions = this.saveHandler.promptToSave(dirtyPartsList);
            int n = decisions.length;
            int n2 = 0;
            while (n2 < n) {
                ISaveHandler.Save decision = saveArray[n2];
                if (decision == ISaveHandler.Save.CANCEL) {
                    return false;
                }
                ++n2;
            }
            int i = 0;
            while (i < decisions.length) {
                if (decisions[i] == ISaveHandler.Save.YES && !this.savePart(dirtyPartsList.get(i), false)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        for (MPart dirtyPart : dirtyParts) {
            if (this.savePart(dirtyPart, false)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<MInputPart> getInputParts(String inputUri) {
        Assert.isNotNull((Object)inputUri, (String)"Input uri must not be null");
        ArrayList<MInputPart> rv = new ArrayList<MInputPart>();
        for (MInputPart p : this.getParts(MInputPart.class, null)) {
            if (!inputUri.equals(p.getInputURI())) continue;
            rv.add(p);
        }
        return rv;
    }

    private MElementContainer<MUIElement> getContainer() {
        MWindow outerContainer;
        MWindow container = outerContainer = this.workbenchWindow != null ? this.workbenchWindow : this.application;
        while (container != null) {
            if (container instanceof MPerspective) {
                return container;
            }
            MUIElement child = container.getSelectedElement();
            if (child == null || !(child instanceof MElementContainer)) break;
            container = (MElementContainer)child;
        }
        return outerContainer;
    }
}

