/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional.scanner;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.pde.api.tools.internal.CompilationUnit;
import org.eclipse.pde.api.tools.internal.JavadocTagManager;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.internal.util.Util;

public class TagScanner {
    private static boolean DEBUG = Util.DEBUG;
    private static TagScanner fSingleton = null;

    public static void setDebug(boolean debugValue) {
        DEBUG = debugValue || Util.DEBUG;
    }

    public static final TagScanner newScanner() {
        if (fSingleton == null) {
            fSingleton = new TagScanner();
        }
        return fSingleton;
    }

    private TagScanner() {
    }

    public void scan(ICompilationUnit unit, IApiDescription description, IApiTypeContainer container, IProgressMonitor monitor) throws CoreException {
        this.scan(new CompilationUnit(unit), description, container, unit.getJavaProject().getOptions(true), monitor);
    }

    public void scan(CompilationUnit source, IApiDescription description, IApiTypeContainer container, Map options, IProgressMonitor monitor) throws CoreException {
        SubMonitor localmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        ASTParser parser = ASTParser.newParser((int)4);
        InputStream inputStream = null;
        try {
            try {
                inputStream = source.getInputStream();
                parser.setSource(Util.getInputStreamAsCharArray(inputStream, -1, System.getProperty("file.encoding")));
            }
            catch (FileNotFoundException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", MessageFormat.format("Compilation unit source not found: {0}", source.getName()), (Throwable)e));
            }
            catch (IOException e) {
                if (DEBUG) {
                    System.err.println(source.getName());
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", MessageFormat.format("Error reading compilation unit: {0}", source.getName()), (Throwable)e));
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    ApiPlugin.log(e);
                }
            }
        }
        Util.updateMonitor((IProgressMonitor)localmonitor);
        Map loptions = options;
        if (loptions == null) {
            loptions = JavaCore.getOptions();
        }
        loptions.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
        parser.setCompilerOptions(loptions);
        org.eclipse.jdt.core.dom.CompilationUnit cunit = (org.eclipse.jdt.core.dom.CompilationUnit)parser.createAST((IProgressMonitor)localmonitor.newChild(1));
        Visitor visitor = new Visitor(description, container);
        cunit.accept((ASTVisitor)visitor);
        if (visitor.getException() != null) {
            throw visitor.getException();
        }
    }

    static class Visitor
    extends ASTVisitor {
        private IApiDescription fDescription = null;
        private IPackageDescriptor fPackage = Factory.packageDescriptor("");
        private IReferenceTypeDescriptor fType = null;
        private IApiTypeContainer fContainer = null;
        private CoreException fException;

        public Visitor(IApiDescription description, IApiTypeContainer container) {
            this.fDescription = description;
            this.fContainer = container;
        }

        public boolean visit(Javadoc node) {
            List tags = node.tags();
            ASTNode parent = node.getParent();
            if (parent != null) {
                switch (parent.getNodeType()) {
                    case 55: {
                        TypeDeclaration type = (TypeDeclaration)parent;
                        if (type.isInterface()) {
                            this.processTags(this.fType, this.pruneTags(tags, (ASTNode)type), 2, 16);
                            break;
                        }
                        this.processTags(this.fType, this.pruneTags(tags, (ASTNode)type), 1, 16);
                        break;
                    }
                    case 31: {
                        MethodDeclaration method = (MethodDeclaration)parent;
                        String signature = Signatures.getMethodSignatureFromNode(method);
                        if (signature == null) break;
                        String methodname = method.getName().getFullyQualifiedName();
                        int member = 4;
                        if (method.isConstructor()) {
                            member = 32;
                            methodname = "<init>";
                        }
                        IMethodDescriptor descriptor = this.fType.getMethod(methodname, signature);
                        this.processTags(descriptor, this.pruneTags(tags, (ASTNode)method), this.getEnclosingType((ASTNode)method), member);
                        break;
                    }
                    case 23: {
                        FieldDeclaration field = (FieldDeclaration)parent;
                        List fields = field.fragments();
                        VariableDeclarationFragment fragment = null;
                        Iterator iter = fields.iterator();
                        while (iter.hasNext()) {
                            fragment = (VariableDeclarationFragment)iter.next();
                            this.processTags(this.fType.getField(fragment.getName().getFullyQualifiedName()), this.pruneTags(tags, (ASTNode)field), this.getEnclosingType((ASTNode)field), 8);
                        }
                        break;
                    }
                }
            }
            return false;
        }

        private int getEnclosingType(ASTNode node) {
            ASTNode lnode = node;
            while (!(lnode instanceof AbstractTypeDeclaration)) {
                lnode = lnode.getParent();
            }
            if (lnode instanceof TypeDeclaration && ((TypeDeclaration)lnode).isInterface()) {
                return 2;
            }
            return 1;
        }

        private void enterType(SimpleName name) {
            this.fType = this.fType == null ? this.fPackage.getType(name.getFullyQualifiedName()) : this.fType.getType(name.getFullyQualifiedName());
        }

        private void exitType() {
            this.fType = this.fType.getEnclosingType();
        }

        protected void processTags(IElementDescriptor descriptor, List tags, int type, int member) {
            JavadocTagManager jtm = ApiPlugin.getJavadocTagManager();
            TagElement tag = null;
            String tagname = null;
            int restrictions = 0;
            Iterator iter = tags.iterator();
            while (iter.hasNext()) {
                tag = (TagElement)iter.next();
                tagname = tag.getTagName();
                restrictions |= jtm.getRestrictionsForTag(tagname, type, member);
            }
            if (restrictions != 0) {
                IElementDescriptor ldesc = descriptor;
                if (ldesc.getElementType() == 6) {
                    try {
                        ldesc = this.resolveMethod((IMethodDescriptor)ldesc);
                    }
                    catch (CoreException e) {
                        this.fException = e;
                    }
                }
                this.fDescription.setRestrictions(ldesc, restrictions);
            }
        }

        private List pruneTags(List tags, ASTNode node) {
            ArrayList<TagElement> pruned = new ArrayList<TagElement>(tags.size());
            TagElement tag = null;
            block0 : switch (node.getNodeType()) {
                case 55: {
                    TypeDeclaration type = (TypeDeclaration)node;
                    int flags = type.getModifiers();
                    Iterator iterator = tags.iterator();
                    while (iterator.hasNext()) {
                        tag = (TagElement)iterator.next();
                        String tagname = tag.getTagName();
                        if (type.isInterface() && ("@noextend".equals(tagname) || "@noimplement".equals(tagname))) {
                            pruned.add(tag);
                            continue;
                        }
                        if ("@noextend".equals(tagname) && !Flags.isFinal((int)flags)) {
                            pruned.add(tag);
                            continue;
                        }
                        if (!"@noinstantiate".equals(tagname) || Flags.isAbstract((int)flags)) continue;
                        pruned.add(tag);
                    }
                    break;
                }
                case 31: {
                    MethodDeclaration method = (MethodDeclaration)node;
                    int flags = method.getModifiers();
                    Iterator iterator = tags.iterator();
                    while (iterator.hasNext()) {
                        tag = (TagElement)iterator.next();
                        if ("@noreference".equals(tag.getTagName())) {
                            pruned.add(tag);
                            continue;
                        }
                        if (!"@nooverride".equals(tag.getTagName())) continue;
                        ASTNode parent = method.getParent();
                        int pflags = 0;
                        if (parent instanceof BodyDeclaration) {
                            pflags = ((BodyDeclaration)parent).getModifiers();
                        }
                        if (Flags.isFinal((int)flags) || Flags.isStatic((int)flags) || Flags.isFinal((int)pflags)) continue;
                        pruned.add(tag);
                    }
                    break;
                }
                case 23: {
                    FieldDeclaration field = (FieldDeclaration)node;
                    Iterator iterator = tags.iterator();
                    while (iterator.hasNext()) {
                        tag = (TagElement)iterator.next();
                        boolean isfinal = Flags.isFinal((int)field.getModifiers());
                        if (isfinal || isfinal && Flags.isStatic((int)field.getModifiers())) break block0;
                        if (!"@noreference".equals(tag.getTagName())) continue;
                        pruned.add(tag);
                        break block0;
                    }
                    break;
                }
            }
            return pruned;
        }

        private boolean isContinue() {
            return this.fException == null;
        }

        CoreException getException() {
            return this.fException;
        }

        public boolean visit(TypeDeclaration node) {
            if (this.isPrivate(node.getModifiers())) {
                return false;
            }
            this.enterType(node.getName());
            return this.isContinue();
        }

        public void endVisit(TypeDeclaration node) {
            if (!this.isPrivate(node.getModifiers())) {
                this.exitType();
            }
        }

        public void endVisit(AnnotationTypeDeclaration node) {
            if (!this.isPrivate(node.getModifiers())) {
                this.exitType();
            }
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            if (this.isPrivate(node.getModifiers())) {
                return false;
            }
            this.enterType(node.getName());
            return this.isContinue();
        }

        public boolean visit(EnumDeclaration node) {
            if (this.isPrivate(node.getModifiers())) {
                return false;
            }
            this.enterType(node.getName());
            return this.isContinue();
        }

        public void endVisit(EnumDeclaration node) {
            if (!this.isPrivate(node.getModifiers())) {
                this.exitType();
            }
        }

        public boolean visit(PackageDeclaration node) {
            Name name = node.getName();
            this.fPackage = Factory.packageDescriptor(name.getFullyQualifiedName());
            return false;
        }

        public boolean visit(MethodDeclaration node) {
            if (this.isPrivate(node.getModifiers())) {
                return false;
            }
            return this.isContinue();
        }

        public boolean visit(FieldDeclaration node) {
            if (this.isPrivate(node.getModifiers())) {
                return false;
            }
            return this.isContinue();
        }

        private boolean isPrivate(int flags) {
            return Flags.isPrivate((int)flags);
        }

        private IMethodDescriptor resolveMethod(IMethodDescriptor descriptor) throws CoreException {
            if (this.fContainer != null) {
                IApiType structure;
                IReferenceTypeDescriptor type = descriptor.getEnclosingType();
                IApiTypeRoot classFile = this.fContainer.findTypeRoot(type.getQualifiedName());
                if (classFile != null && (structure = classFile.getStructure()) != null) {
                    IApiMethod[] methods = structure.getMethods();
                    int i = 0;
                    while (i < methods.length) {
                        IApiMethod method = methods[i];
                        if (descriptor.getName().equals(method.getName())) {
                            String signature = method.getSignature();
                            String descriptorSignature = descriptor.getSignature().replace('/', '.');
                            if (Signatures.matchesSignatures(descriptorSignature, signature.replace('/', '.'))) {
                                return descriptor.getEnclosingType().getMethod(method.getName(), signature);
                            }
                            String genericSignature = method.getGenericSignature();
                            if (genericSignature != null && Signatures.matchesSignatures(descriptorSignature, genericSignature.replace('/', '.'))) {
                                return descriptor.getEnclosingType().getMethod(method.getName(), signature);
                            }
                        }
                        ++i;
                    }
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.api.tools", MessageFormat.format("Unable to resolve method signature: {0}", descriptor.toString()), null));
            }
            return descriptor;
        }
    }
}

