/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptService;

public final class ModuleHelper {
    @Deprecated
    private ModuleHelper() {
    }

    public static List<Method> getMethods(Class<?> clazz) {
        if (clazz == null || clazz.getMethods().length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        boolean wrapping = ModuleHelper.hasWrapToScript(clazz);
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Modifier.isPublic(method.getModifiers()) && (!wrapping || method.isAnnotationPresent(WrapToScript.class))) {
                methods.add(method);
            }
            ++n2;
        }
        return methods;
    }

    public static List<Field> getFields(Class<?> clazz) {
        if (clazz == null || clazz.getDeclaredFields().length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        boolean wrapping = ModuleHelper.hasWrapToScript(clazz);
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (Modifier.isFinal(field.getModifiers()) && Modifier.isPublic(field.getModifiers()) && (!wrapping || field.isAnnotationPresent(WrapToScript.class))) {
                fields.add(field);
            }
            ++n2;
        }
        return fields;
    }

    private static boolean hasWrapToScript(Class<?> clazz) {
        AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = accessibleObjectArray[n2];
            if (field.isAnnotationPresent(WrapToScript.class)) {
                return true;
            }
            ++n2;
        }
        accessibleObjectArray = clazz.getMethods();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject method = accessibleObjectArray[n2];
            if (method.isAnnotationPresent(WrapToScript.class)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String resolveName(String identifier) {
        IScriptService scriptService = ScriptService.getService();
        Map<String, ModuleDefinition> availableModules = scriptService.getAvailableModules();
        if (identifier.startsWith("/")) {
            if (availableModules.containsKey(identifier)) {
                return identifier;
            }
            return null;
        }
        Path searchPath = new Path(identifier);
        if (searchPath.segmentCount() == 1 && !searchPath.isAbsolute()) {
            for (String pathName : availableModules.keySet()) {
                if (!new Path(pathName).lastSegment().equals(identifier)) continue;
                if (searchPath.isAbsolute()) {
                    throw new RuntimeException("Module identifier \"" + identifier + "\" is ambiguous. Use full path name to load.");
                }
                searchPath = availableModules.get(pathName).getPath();
            }
        }
        return searchPath.toString();
    }
}

