/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.ease.modules.unittest.Bundle;
import org.eclipse.ease.modules.unittest.modules.IAssertion;

public class MergedAssertion
implements IAssertion {
    private final Collection<IAssertion> fAssertions = new ArrayList<IAssertion>();
    private final String fErrorMessage;
    private final String fValidMessage;

    public MergedAssertion() {
        this.fValidMessage = IAssertion.VALID.toString();
        this.fErrorMessage = null;
    }

    public MergedAssertion(String validMessage, String errorMessage) {
        this.fValidMessage = validMessage;
        this.fErrorMessage = errorMessage;
    }

    public MergedAssertion(String errorMessage) {
        this.fValidMessage = IAssertion.VALID.toString();
        this.fErrorMessage = errorMessage;
    }

    public final void add(IAssertion assertion) {
        this.fAssertions.add(assertion);
    }

    @Override
    public final boolean isValid() {
        for (IAssertion assertion : this.fAssertions) {
            if (assertion.isValid()) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        if (this.isValid()) {
            return this.fValidMessage;
        }
        if (this.fErrorMessage != null) {
            return this.fErrorMessage;
        }
        StringBuilder message = new StringBuilder();
        for (IAssertion assertion : this.fAssertions) {
            if (assertion.isValid()) continue;
            if (message.length() > 0) {
                message.append(Bundle.LINE_DELIMITER);
            }
            message.append(assertion.toString());
        }
        if (message.length() > 0) {
            return message.toString();
        }
        return IAssertion.INVALID.toString();
    }

    public Collection<IAssertion> getAssertions() {
        return Collections.unmodifiableCollection(this.fAssertions);
    }
}

