/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.sign;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.ease.ICodeParser;
import org.eclipse.ease.Logger;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.sign.ScriptSignatureException;
import org.eclipse.ease.sign.SignatureHelper;
import org.eclipse.ease.sign.SignatureInfo;
import org.eclipse.ease.tools.ResourceTools;

public class VerifySignature {
    private final SignatureInfo fSignatureInfo;

    public static VerifySignature getInstance(ScriptType scriptType, InputStream inputStream) throws ScriptSignatureException {
        return VerifySignature.getInstance(scriptType, inputStream, null);
    }

    public static VerifySignature getInstance(ScriptType scriptType, InputStream inputStream, InputStream signatureInputStream) throws ScriptSignatureException {
        if (scriptType == null || inputStream == null) {
            throw new ScriptSignatureException("One or more parameters are not provided");
        }
        ICodeParser iCodeParser = scriptType.getCodeParser();
        if (signatureInputStream == null) {
            SignatureInfo signatureInfo = iCodeParser.getSignatureInfo(inputStream);
            if (signatureInfo != null) {
                if (signatureInfo.getSignature() == null || signatureInfo.getProvider() == null || signatureInfo.getMessageDigestAlgo() == null || signatureInfo.getCertificateChain() == null || signatureInfo.getContentOnly() == null) {
                    throw new ScriptSignatureException("Error while parsing script. Try again.");
                }
                return new VerifySignature(signatureInfo);
            }
            return null;
        }
        SignatureInfo signatureInfo = iCodeParser.getSignatureInfo(signatureInputStream);
        if (signatureInfo != null) {
            if (signatureInfo.getSignature() == null || signatureInfo.getProvider() == null || signatureInfo.getMessageDigestAlgo() == null || signatureInfo.getCertificateChain() == null) {
                throw new ScriptSignatureException("Error while parsing script. Try again.");
            }
            BufferedInputStream bInput = new BufferedInputStream(inputStream);
            StringBuffer sBuf = new StringBuffer();
            try {
                int cur;
                while ((cur = bInput.read()) >= 0) {
                    sBuf.append((char)cur);
                }
                signatureInfo.setContentOnly(sBuf.toString());
                VerifySignature verifySignature = new VerifySignature(signatureInfo);
                return verifySignature;
            }
            catch (IOException e) {
                Logger.error("org.eclipse.ease", e.getMessage(), e);
                throw new ScriptSignatureException("An IO error occurred while reading file.", e);
            }
            finally {
                try {
                    if (bInput != null) {
                        bInput.close();
                    }
                }
                catch (IOException e) {
                    Logger.error("org.eclipse.ease", e.getMessage(), e);
                }
            }
        }
        return null;
    }

    private VerifySignature(SignatureInfo signatureInfo) {
        this.fSignatureInfo = signatureInfo;
    }

    private Certificate getCertificate(byte[] bytesCert) throws ScriptSignatureException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return certificateFactory.generateCertificate(new ByteArrayInputStream(bytesCert));
        }
        catch (CertificateException e) {
            throw new ScriptSignatureException("Error while retrieving certificate.", e);
        }
    }

    private List<Certificate> getCertificateChain() throws ScriptSignatureException {
        String[] certChainString = this.fSignatureInfo.getCertificateChain();
        int noOfCert = certChainString.length;
        byte[][] certChainByte = new byte[noOfCert][];
        int i = 0;
        while (i < noOfCert) {
            certChainByte[i] = SignatureHelper.convertBase64ToBytes(certChainString[i]);
            ++i;
        }
        ArrayList<Certificate> certificateList = new ArrayList<Certificate>();
        byte[][] byArrayArray = certChainByte;
        int n = certChainByte.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] cert = byArrayArray[n2];
            certificateList.add(this.getCertificate(cert));
            ++n2;
        }
        return certificateList;
    }

    public boolean isSelfSignedCertificate() throws ScriptSignatureException {
        if (this.fSignatureInfo != null) {
            ArrayList certificateList = (ArrayList)this.getCertificateChain();
            Certificate certificate = (Certificate)certificateList.get(0);
            return SignatureHelper.isSelfSignedCertificate(certificate);
        }
        throw new ScriptSignatureException("Script does not contain signature.");
    }

    public boolean isCertChainValid(InputStream trustStoreLocation, char[] trustStorePassword) throws ScriptSignatureException {
        if (trustStoreLocation == null && trustStorePassword != null || trustStoreLocation != null && trustStorePassword == null) {
            throw new ScriptSignatureException("Either both or none of the parameters should be null");
        }
        if (this.fSignatureInfo != null) {
            InputStream iStream = null;
            try {
                if (trustStoreLocation == null && trustStorePassword == null) {
                    iStream = new FileInputStream(String.valueOf(System.getProperty("java.home")) + "/lib/security/" + "cacerts");
                    trustStorePassword = "changeit".toCharArray();
                } else {
                    iStream = ResourceTools.getInputStream(trustStoreLocation);
                }
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ArrayList certificateList = (ArrayList)this.getCertificateChain();
                int certLength = certificateList.size();
                if (SignatureHelper.isSelfSignedCertificate((Certificate)certificateList.get(certLength - 1))) {
                    certificateList.remove(certLength - 1);
                }
                CertPath certPath = certificateFactory.generateCertPath(certificateList);
                CertPathValidator validator = CertPathValidator.getInstance("PKIX");
                KeyStore keystore = KeyStore.getInstance("JKS");
                keystore.load(iStream, trustStorePassword);
                PKIXParameters params = new PKIXParameters(keystore);
                params.setRevocationEnabled(true);
                Security.setProperty("ocsp.enable", "true");
                System.setProperty("com.sun.net.ssl.checkRevocation", "true");
                System.setProperty("com.sun.security.enableCRLDP", "true");
                validator.validate(certPath, params);
                return true;
            }
            catch (CertificateException e) {
                throw new ScriptSignatureException("One or more certificates can't be loaded.", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ScriptSignatureException("Algorithm used for securing truststore can't be found. Chose another Truststore.", e);
            }
            catch (KeyStoreException keyStoreException) {
                throw new ScriptSignatureException("Truststore can't be loaded.");
            }
            catch (IOException e) {
                if (e.getCause() instanceof UnrecoverableKeyException) {
                    throw new ScriptSignatureException("Invalid Truststore Password.", e);
                }
                if (e.getCause() instanceof FileNotFoundException || e.getCause() instanceof SecurityException) {
                    throw new ScriptSignatureException("File can't be read. Chose another Truststore or try again.", e);
                }
                Logger.error("org.eclipse.ease", Arrays.toString(e.getStackTrace()), e);
                throw new ScriptSignatureException("Error loading Truststore. Try again.", e);
            }
            catch (InvalidAlgorithmParameterException e) {
                Logger.error("org.eclipse.ease", Arrays.toString(e.getStackTrace()), e);
                throw new ScriptSignatureException("Can't perform validation.", e);
            }
            catch (CertPathValidatorException e) {
                throw new ScriptSignatureException(e.getMessage());
            }
            finally {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                }
                catch (IOException e) {
                    Logger.error("org.eclipse.ease", Arrays.toString(e.getStackTrace()), e);
                }
            }
        }
        throw new ScriptSignatureException("Script does not contain signature.");
    }

    public boolean isCertChainValid() throws ScriptSignatureException {
        return this.isCertChainValid(null, null);
    }

    public boolean verify() throws ScriptSignatureException {
        if (this.fSignatureInfo != null) {
            byte[] signByte = SignatureHelper.convertBase64ToBytes(this.fSignatureInfo.getSignature());
            byte[] certByte = SignatureHelper.convertBase64ToBytes(this.fSignatureInfo.getCertificateChain()[0]);
            Certificate userCert = this.getCertificate(certByte);
            try {
                PublicKey publicKey = userCert.getPublicKey();
                String encryptionAlgo = publicKey.getAlgorithm();
                Signature signature = Signature.getInstance(String.valueOf(this.fSignatureInfo.getMessageDigestAlgo()) + "with" + encryptionAlgo, this.fSignatureInfo.getProvider());
                signature.initVerify(publicKey);
                signature.update(this.fSignatureInfo.getContentOnly().getBytes());
                return signature.verify(signByte);
            }
            catch (SignatureException e) {
                Logger.error("org.eclipse.ease", "Signature object not initialized properly or signature is not readable.", e);
                throw new ScriptSignatureException("Signature is not readable.", e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ScriptSignatureException("Algorithm used by signature is not recognized by provider.", e);
            }
            catch (InvalidKeyException e) {
                throw new ScriptSignatureException("Public key is invalid.", e);
            }
            catch (NoSuchProviderException e) {
                throw new ScriptSignatureException("No such provider is registered in Security Providers' list.", e);
            }
        }
        throw new ScriptSignatureException("Script does not contain signature.");
    }
}

