/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui.editor;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ease.modules.platform.UIModule;
import org.eclipse.ease.modules.unittest.components.TestSuiteModel;
import org.eclipse.ease.modules.unittest.ui.editor.AbstractEditorPage;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class Components
extends AbstractEditorPage {
    private static final String VISUALIZATION_GUI = "Unit Test View";
    private static final String VISUALIZATION_SYSOUT = "System.out";
    private static final String VISUALIZATION_NONE = "None";
    protected String fVisualizationIdentifier = "Unit Test View";
    private ContainerCheckedTreeViewer fTestTree;
    private Spinner spinner;
    private Combo combo;
    private Button btnPromoteErrorsToFailures;
    private Button btnStopSuiteOnFailure;
    private Button fbutton;

    public Components(String id, String title) {
        super(id, title);
    }

    public Components(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        GridLayout gridLayout = new GridLayout(5, false);
        managedForm.getForm().getBody().setLayout((Layout)gridLayout);
        Label lblNewLabel = new Label(managedForm.getForm().getBody(), 0);
        GridData gd_lblNewLabel = new GridData(16384, 0x1000000, false, false, 4, 1);
        gd_lblNewLabel.verticalIndent = 10;
        lblNewLabel.setLayoutData((Object)gd_lblNewLabel);
        managedForm.getToolkit().adapt((Control)lblNewLabel, true, true);
        lblNewLabel.setText("Select all test files that should be included in this suite.");
        new Label(managedForm.getForm().getBody(), 0);
        Section sctnIncludedTests = managedForm.getToolkit().createSection(managedForm.getForm().getBody(), 256);
        sctnIncludedTests.setDescription("");
        sctnIncludedTests.setLayoutData((Object)new GridData(4, 4, true, true, 1, 7));
        managedForm.getToolkit().paintBordersFor((Composite)sctnIncludedTests);
        sctnIncludedTests.setText("Included Tests");
        Composite composite = managedForm.getToolkit().createComposite((Composite)sctnIncludedTests, 0);
        managedForm.getToolkit().paintBordersFor(composite);
        sctnIncludedTests.setClient((Control)composite);
        composite.setLayout((Layout)new FillLayout(256));
        Tree tree = managedForm.getToolkit().createTree(composite, 32);
        managedForm.getToolkit().paintBordersFor((Composite)tree);
        new Label(managedForm.getForm().getBody(), 0);
        new Label(managedForm.getForm().getBody(), 0);
        new Label(managedForm.getForm().getBody(), 0);
        new Label(managedForm.getForm().getBody(), 0);
        new Label(managedForm.getForm().getBody(), 0);
        managedForm.getToolkit().createLabel(managedForm.getForm().getBody(), "Use at max.", 0);
        this.fTestTree = new ContainerCheckedTreeViewer(tree);
        this.fTestTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty() && (element = selection.getFirstElement()) instanceof IFile) {
                    try {
                        UIModule.showEditor((IFile)((IFile)element));
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        this.fTestTree.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.fTestTree.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.fTestTree.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IResource) {
                    if (((IResource)element).getName().startsWith(".")) {
                        return false;
                    }
                    if (element instanceof IContainer) {
                        return this.containsScript((IContainer)element);
                    }
                    return this.isScript((IResource)element);
                }
                return true;
            }

            private boolean isScript(IResource resource) {
                return resource instanceof IFile && resource.toString().toLowerCase().endsWith(".js");
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private boolean containsScript(IContainer container) {
                try {
                    IResource[] iResourceArray = container.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return false;
                        }
                        IResource resource = iResourceArray[n2];
                        if (resource instanceof IContainer ? this.containsScript((IContainer)resource) : this.isScript(resource)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                catch (CoreException coreException) {}
                return false;
            }
        });
        this.fTestTree.setComparator(new ViewerComparator(){

            public int category(Object element) {
                return element instanceof IContainer ? 0 : 1;
            }
        });
        this.spinner = new Spinner(managedForm.getForm().getBody(), 2048);
        this.spinner.setPageIncrement(5);
        this.spinner.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.spinner.setMinimum(1);
        this.spinner.setSelection(1);
        managedForm.getToolkit().adapt((Composite)this.spinner);
        managedForm.getToolkit().paintBordersFor((Composite)this.spinner);
        this.spinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int maxThreads = Components.this.getModel().getFlag("max threads", 1);
                if (Components.this.spinner.getSelection() != maxThreads) {
                    Components.this.getModel().setFlag("max threads", Components.this.spinner.getSelection());
                    Components.this.setDirty();
                }
            }
        });
        managedForm.getToolkit().createLabel(managedForm.getForm().getBody(), "instances in parallel", 0);
        new Label(managedForm.getForm().getBody(), 0);
        Label lblTestVisualization = new Label(managedForm.getForm().getBody(), 0);
        lblTestVisualization.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        managedForm.getToolkit().adapt((Control)lblTestVisualization, true, true);
        lblTestVisualization.setText("Test Visualization");
        new Label(managedForm.getForm().getBody(), 0);
        this.combo = new Combo(managedForm.getForm().getBody(), 8);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Components.this.fVisualizationIdentifier = Components.this.combo.getText();
            }
        });
        GridData gd_combo = new GridData(4, 128, false, false, 3, 1);
        gd_combo.horizontalIndent = 20;
        this.combo.setLayoutData((Object)gd_combo);
        managedForm.getToolkit().adapt((Composite)this.combo);
        managedForm.getToolkit().paintBordersFor((Composite)this.combo);
        this.combo.setItems(new String[]{VISUALIZATION_GUI, VISUALIZATION_SYSOUT, VISUALIZATION_NONE});
        this.combo.setText(this.combo.getItem(0));
        new Label(managedForm.getForm().getBody(), 0);
        this.btnPromoteErrorsToFailures = managedForm.getToolkit().createButton(managedForm.getForm().getBody(), "Promote errors to failures (stops test file)", 32);
        this.btnPromoteErrorsToFailures.setToolTipText("Raised a failure instead of an error. If set, test file execution will stop on the first error.");
        this.btnPromoteErrorsToFailures.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Components.this.getModel().setFlag("promote errors to failures", Components.this.btnPromoteErrorsToFailures.getSelection());
                Components.this.setDirty();
            }
        });
        this.btnPromoteErrorsToFailures.setLayoutData((Object)new GridData(16384, 128, false, false, 3, 1));
        new Label(managedForm.getForm().getBody(), 0);
        this.btnStopSuiteOnFailure = managedForm.getToolkit().createButton(managedForm.getForm().getBody(), "Stop suite on failure", 32);
        this.btnStopSuiteOnFailure.setToolTipText("Stops test suite execution upon a failure. If not set, the next test file will be executed.");
        this.btnStopSuiteOnFailure.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Components.this.getModel().setFlag("stop suite on failure", Components.this.btnStopSuiteOnFailure.getSelection());
                Components.this.setDirty();
            }
        });
        this.btnStopSuiteOnFailure.setLayoutData((Object)new GridData(16384, 128, false, false, 3, 1));
        new Label(managedForm.getForm().getBody(), 0);
        this.fbutton = managedForm.getToolkit().createButton(managedForm.getForm().getBody(), "Execute teardown on failure", 32);
        this.fbutton.setSelection(true);
        this.fbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Components.this.getModel().setFlag("execute teardown on failure", Components.this.fbutton.getSelection());
                Components.this.setDirty();
            }
        });
        this.fbutton.setLayoutData((Object)new GridData(16384, 128, false, false, 3, 1));
        this.fTestTree.setInput((Object)this.getModel().getFile().getProject());
        this.fTestTree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                TestSuiteModel model = Components.this.getModel();
                model.getTestFiles().clear();
                Object[] objectArray = Components.this.fTestTree.getCheckedElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof IFile) {
                        model.addTestFile(ResourceTools.toProjectRelativeLocation((Object)object, null));
                    }
                    ++n2;
                }
                Components.this.setDirty();
            }
        });
    }

    @Override
    public void setFocus() {
        super.setFocus();
        this.update();
    }

    @Override
    protected void update() {
        TestSuiteModel model = this.getModel();
        this.fTestTree.setCheckedElements(new Object[0]);
        for (String fileLocation : model.getTestFiles()) {
            Object file = ResourceTools.resolveFile((Object)fileLocation, (Object)model.getFile(), (boolean)true);
            if (file == null) continue;
            this.fTestTree.setChecked(file, true);
        }
        int maxThreads = model.getFlag("max threads", 1);
        this.spinner.setSelection(maxThreads);
        this.btnPromoteErrorsToFailures.setSelection(model.getFlag("promote errors to failures", false));
        this.btnStopSuiteOnFailure.setSelection(model.getFlag("stop suite on failure", false));
    }

    @Override
    protected String getPageTitle() {
        return "Test Components";
    }
}

