/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.groovy.interpreter;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;

public class MultiClassLoader
extends ClassLoader {
    private final ClassLoader[] fParents;

    public MultiClassLoader(ClassLoader ... parents) {
        super(parents[0]);
        this.fParents = parents;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        ClassNotFoundException exception = null;
        ClassLoader[] classLoaderArray = this.fParents;
        int n = this.fParents.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader classloader = classLoaderArray[n2];
            try {
                return classloader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                exception = e;
                ++n2;
            }
        }
        throw exception;
    }

    @Override
    public URL getResource(String name) {
        ClassLoader[] classLoaderArray = this.fParents;
        int n = this.fParents.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader classloader = classLoaderArray[n2];
            URL candidate = classloader.getResource(name);
            if (candidate != null) {
                return candidate;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        IOException exception = null;
        ClassLoader[] classLoaderArray = this.fParents;
        int n = this.fParents.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader classloader = classLoaderArray[n2];
            try {
                Enumeration<URL> candidate = classloader.getResources(name);
                if (candidate != null) {
                    return candidate;
                }
            }
            catch (IOException e) {
                exception = e;
            }
            ++n2;
        }
        if (exception != null) {
            throw exception;
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        ClassLoader[] classLoaderArray = this.fParents;
        int n = this.fParents.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader classloader = classLoaderArray[n2];
            InputStream candidate = classloader.getResourceAsStream(name);
            if (candidate != null) {
                return candidate;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void setDefaultAssertionStatus(boolean enabled) {
        ClassLoader[] classLoaderArray = this.fParents;
        int n = this.fParents.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader classloader = classLoaderArray[n2];
            classloader.setDefaultAssertionStatus(enabled);
            ++n2;
        }
    }

    @Override
    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        ClassLoader[] classLoaderArray = this.fParents;
        int n = this.fParents.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader classloader = classLoaderArray[n2];
            classloader.setPackageAssertionStatus(packageName, enabled);
            ++n2;
        }
    }

    @Override
    public void setClassAssertionStatus(String className, boolean enabled) {
        ClassLoader[] classLoaderArray = this.fParents;
        int n = this.fParents.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader classloader = classLoaderArray[n2];
            classloader.setPackageAssertionStatus(className, enabled);
            ++n2;
        }
    }

    @Override
    public void clearAssertionStatus() {
        ClassLoader[] classLoaderArray = this.fParents;
        int n = this.fParents.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader classloader = classLoaderArray[n2];
            classloader.clearAssertionStatus();
            ++n2;
        }
    }
}

