/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.view;

import java.util.ArrayList;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.modules.IEnvironment;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.Messages;
import org.eclipse.ease.ui.modules.ui.ModulesDragListener;
import org.eclipse.ease.ui.view.IShellDropin;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public class ModuleStackDropin
implements IShellDropin,
IExecutionListener {
    private TableViewer fModulesTable;
    private IScriptEngine fEngine;

    @Override
    public void setScriptEngine(IScriptEngine engine) {
        if (this.fEngine != null) {
            this.fEngine.removeExecutionListener((IExecutionListener)this);
        }
        this.fEngine = engine;
        if (this.fEngine != null) {
            this.fEngine.addExecutionListener((IExecutionListener)this);
        }
        if (this.fModulesTable != null) {
            this.fModulesTable.setInput((Object)this.fEngine);
            Display.getDefault().asyncExec(() -> this.fModulesTable.refresh());
        }
    }

    @Override
    public Composite createPartControl(IWorkbenchPartSite site, Composite parent) {
        Composite composite = new Composite(parent, 0);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        composite.setLayout((Layout)tableColumnLayout);
        this.fModulesTable = new TableViewer(composite, 2048);
        Table table = this.fModulesTable.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fModulesTable.setContentProvider((IContentProvider)((IStructuredContentProvider)inputElement -> {
            IEnvironment environment;
            if (inputElement instanceof IScriptEngine && (environment = IEnvironment.getEnvironment((IScriptEngine)((IScriptEngine)inputElement))) != null) {
                ArrayList<ModuleDefinition> loadedModules = new ArrayList<ModuleDefinition>();
                for (Object instance : new ArrayList(environment.getModules())) {
                    ModuleDefinition definition = this.getDefinition(instance);
                    loadedModules.add((ModuleDefinition)(definition != null ? definition : instance));
                }
                return loadedModules.toArray();
            }
            return new Object[0];
        }));
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.fModulesTable, 0);
        TableColumn column = tableViewerColumn.getColumn();
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(1));
        column.setText(Messages.ModuleStackDropin_module);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ModuleDefinition) {
                    return ((ModuleDefinition)element).getName();
                }
                if (element != null) {
                    return element.getClass().getCanonicalName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof ModuleDefinition) {
                    ImageDescriptor icon = ((ModuleDefinition)element).getImageDescriptor();
                    if (icon != null) {
                        return icon.createImage();
                    }
                    return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/module.png", true);
                }
                if (element != null) {
                    return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/debug_java_class.png", true);
                }
                return super.getImage(element);
            }
        });
        this.fModulesTable.setInput((Object)this.fEngine);
        this.fModulesTable.addDragSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer(), TextTransfer.getInstance()}, (DragSourceListener)new ModulesDragListener(this.fModulesTable){

            @Override
            public void dragStart(DragSourceEvent event) {
                super.dragStart(event);
                Object firstElement = this.getSelection().getFirstElement();
                event.doit = firstElement instanceof ModuleDefinition;
            }
        });
        return composite;
    }

    private ModuleDefinition getDefinition(Object element) {
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        ArrayList modules = new ArrayList(scriptService.getAvailableModules());
        for (ModuleDefinition definition : modules) {
            if (!definition.getModuleClass().equals(element.getClass())) continue;
            return definition;
        }
        return null;
    }

    @Override
    public String getTitle() {
        return Messages.ModuleStackDropin_moduleStack;
    }

    public void notify(IScriptEngine engine, Script script, int status) {
        switch (status) {
            case 4: 
            case 6: {
                Display.getDefault().asyncExec(() -> this.fModulesTable.refresh());
                break;
            }
            case 2: {
                engine.removeExecutionListener((IExecutionListener)this);
            }
        }
    }
}

