/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.runtime.impl;

import org.eclipse.ease.debugging.ScriptStackTrace;
import org.eclipse.ease.lang.unittest.definition.Flag;
import org.eclipse.ease.lang.unittest.definition.ITestSuiteDefinition;
import org.eclipse.ease.lang.unittest.runtime.IRuntimeFactory;
import org.eclipse.ease.lang.unittest.runtime.IRuntimePackage;
import org.eclipse.ease.lang.unittest.runtime.IStackTraceContainer;
import org.eclipse.ease.lang.unittest.runtime.ITest;
import org.eclipse.ease.lang.unittest.runtime.ITestResult;
import org.eclipse.ease.lang.unittest.runtime.TestStatus;
import org.eclipse.ease.lang.unittest.runtime.impl.TestEntity;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class Test
extends TestEntity
implements ITest {
    protected static final ScriptStackTrace STACK_TRACE_EDEFAULT = null;
    protected ScriptStackTrace stackTrace = STACK_TRACE_EDEFAULT;
    protected static final long DURATION_LIMIT_EDEFAULT = -1L;
    protected long durationLimit = -1L;

    protected Test() {
    }

    @Override
    protected EClass eStaticClass() {
        return IRuntimePackage.Literals.TEST;
    }

    @Override
    public long getDurationLimit() {
        return this.durationLimit;
    }

    @Override
    public void setDurationLimit(long newDurationLimit) {
        long oldDurationLimit = this.durationLimit;
        this.durationLimit = newDurationLimit;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, oldDurationLimit, this.durationLimit));
        }
    }

    @Override
    public ScriptStackTrace getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTraceGen(ScriptStackTrace newStackTrace) {
        ScriptStackTrace oldStackTrace = this.stackTrace;
        this.stackTrace = newStackTrace;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldStackTrace, (Object)this.stackTrace));
        }
    }

    @Override
    public void setStackTrace(ScriptStackTrace newStackTrace) {
        this.setStackTraceGen(newStackTrace != null ? newStackTrace.clone() : newStackTrace);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 11: {
                return this.getStackTrace();
            }
            case 12: {
                return this.getDurationLimit();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 11: {
                this.setStackTrace((ScriptStackTrace)newValue);
                return;
            }
            case 12: {
                this.setDurationLimit((Long)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 11: {
                this.setStackTrace(STACK_TRACE_EDEFAULT);
                return;
            }
            case 12: {
                this.setDurationLimit(-1L);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 11: {
                return STACK_TRACE_EDEFAULT == null ? this.stackTrace != null : !STACK_TRACE_EDEFAULT.equals((Object)this.stackTrace);
            }
            case 12: {
                return this.durationLimit != -1L;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IStackTraceContainer.class) {
            switch (derivedFeatureID) {
                case 11: {
                    return 0;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IStackTraceContainer.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 11;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (stackTrace: ");
        result.append(this.stackTrace);
        result.append(", durationLimit: ");
        result.append(this.durationLimit);
        result.append(')');
        return result.toString();
    }

    @Override
    public void setEndTimestamp(long newEndTimestamp) {
        super.setEndTimestamp(newEndTimestamp);
        if (this.getDurationLimit() > 0L && this.getDurationLimit() < this.getDuration()) {
            ITestSuiteDefinition definition;
            ITestResult result = IRuntimeFactory.eINSTANCE.createTestResult();
            result.setMessage("Test timeout: lasted " + this.getDuration() + " ms, limit was set to " + this.getDurationLimit() + " ms");
            result.setStackTrace(this.getStackTrace());
            ITestSuiteDefinition iTestSuiteDefinition = definition = this.getTestSuite() != null ? this.getTestSuite().getDefinition() : null;
            if (definition != null && definition.getFlag(Flag.PROMOTE_FAILURE_TO_ERROR, false).booleanValue()) {
                result.setStatus(TestStatus.ERROR);
            } else {
                result.setStatus(TestStatus.FAILURE);
            }
            this.getResults().add((Object)result);
        }
    }
}

