/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.filters.internal.actions;

import org.eclipse.emf.ecoretools.filters.internal.FilterPlugin;
import org.eclipse.emf.ecoretools.filters.internal.Messages;
import org.eclipse.emf.ecoretools.filters.internal.actions.HideInheritanceTypeAction;
import org.eclipse.emf.ecoretools.filters.internal.actions.HideReferenceTypeAction;
import org.eclipse.emf.ecoretools.filters.internal.actions.HideSelectionAction;
import org.eclipse.emf.ecoretools.filters.internal.actions.HideSemanticAction;
import org.eclipse.emf.ecoretools.filters.internal.actions.HideTypeAction;
import org.eclipse.emf.ecoretools.filters.internal.actions.ShowHiddenPartAction;
import org.eclipse.emf.ecoretools.filters.internal.extension.FilteredDiagramTypeExtensionManager;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class DiagramFilterActionMenu
extends Action
implements ISelectionChangedListener {
    public static String ID = "diagramFilterActionMenu";
    private Menu menu;
    protected IGraphicalEditPart host;

    public DiagramFilterActionMenu() {
        super("", 4);
        this.setId(ID);
        this.setText(Messages.DiagramFilterActionMenu_FilterElements);
        this.setToolTipText(Messages.DiagramFilterActionMenu_FilterElements_tooltip);
        this.setImageDescriptor(FilterPlugin.getImageDescriptor("icons/etool16/filter_edit.gif"));
        this.setMenuCreator(new MenuCreator());
    }

    private Diagram getCurrentDiagram() {
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (!(editorPart instanceof DiagramEditor)) {
            return null;
        }
        this.host = ((DiagramEditor)editorPart).getDiagramEditPart();
        if (!(this.host instanceof IGraphicalEditPart)) {
            return null;
        }
        View view = (View)this.host.getModel();
        Diagram diagram = view.getDiagram();
        return diagram;
    }

    public boolean isHandled() {
        Diagram diagram = this.getCurrentDiagram();
        if (diagram == null) {
            return false;
        }
        return FilteredDiagramTypeExtensionManager.getInstance().getFilteredDiagramTypeExtension(diagram.getType()) != null;
    }

    public void run() {
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    private class MenuCreator
    implements IMenuCreator {
        private MenuCreator() {
        }

        public void dispose() {
            if (DiagramFilterActionMenu.this.menu != null) {
                DiagramFilterActionMenu.this.menu.dispose();
                DiagramFilterActionMenu.this.menu = null;
            }
        }

        public Menu getMenu(Control parent) {
            if (DiagramFilterActionMenu.this.menu != null) {
                DiagramFilterActionMenu.this.menu.dispose();
            }
            DiagramFilterActionMenu.this.menu = new Menu(parent);
            this.initialize();
            return DiagramFilterActionMenu.this.menu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        private void initialize() {
            ActionContributionItem hideSelectionAction = new ActionContributionItem((IAction)new HideSelectionAction());
            hideSelectionAction.fill(DiagramFilterActionMenu.this.menu, -1);
            ActionContributionItem hideTypeAction = new ActionContributionItem((IAction)new HideTypeAction());
            hideTypeAction.fill(DiagramFilterActionMenu.this.menu, 1);
            ActionContributionItem hideSemanticAction = new ActionContributionItem((IAction)new HideSemanticAction());
            hideSemanticAction.fill(DiagramFilterActionMenu.this.menu, 2);
            ActionContributionItem showHiddenPartAction = new ActionContributionItem((IAction)new ShowHiddenPartAction());
            showHiddenPartAction.fill(DiagramFilterActionMenu.this.menu, 3);
            new MenuItem(DiagramFilterActionMenu.this.menu, 2, 4);
            ActionContributionItem hideInheritanceTypeAction = new ActionContributionItem((IAction)new HideInheritanceTypeAction());
            hideInheritanceTypeAction.fill(DiagramFilterActionMenu.this.menu, 5);
            ActionContributionItem hideReferenceTypeAction = new ActionContributionItem((IAction)new HideReferenceTypeAction());
            hideReferenceTypeAction.fill(DiagramFilterActionMenu.this.menu, 6);
        }
    }
}

