/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.tabbedproperties.sections;

import java.util.regex.Pattern;
import org.eclipse.emf.ecoretools.tabbedproperties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.internal.utils.ColorRegistry;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTextPropertySection;
import org.eclipse.swt.widgets.Event;

public abstract class AbstractIntegerPropertySection
extends AbstractTextPropertySection {
    public static final String ABS_NUMERICS_PATTERN = "^[-\\d][\\d]*";
    public static final Pattern INTEGER_PATTERN = Pattern.compile("^[-\\d][\\d]*");

    @Override
    protected void verifyField(Event e) {
        String value = this.getText().getText();
        if (value == null || value.equals("") || this.isTextValid()) {
            this.setErrorMessage(null);
            this.getText().setBackground(null);
            e.doit = true;
        } else {
            this.setErrorMessage(Messages.AbstractIntegerPropertySection_UnvalidCharacter);
            this.getText().setBackground(ColorRegistry.COLOR_ERROR);
            e.doit = false;
        }
    }

    @Override
    protected String getFeatureAsString() {
        return this.getFeatureInteger().toString();
    }

    @Override
    protected Object getOldFeatureValue() {
        return this.getFeatureInteger();
    }

    @Override
    protected Object getNewFeatureValue(String newText) {
        return new Integer(Integer.parseInt(newText));
    }

    @Override
    protected boolean isTextValid() {
        return INTEGER_PATTERN.matcher(this.getText().getText()).matches();
    }

    protected abstract Integer getFeatureInteger();
}

