/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.tabbedproperties.sections.widgets;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecoretools.tabbedproperties.internal.utils.ColorRegistry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class FileChooser
extends Composite {
    private Text field;
    private Button chooseBt;
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private String selectedFile;
    private String[] filterExtensions;

    public FileChooser(Composite parent, TabbedPropertySheetWidgetFactory factory, int style) {
        super(parent, style);
        this.widgetFactory = factory;
        this.setFilterExtensions(new String[]{"*.*"});
        this.createContents(this);
        this.widgetFactory.adapt((Composite)this);
        this.hookListeners();
    }

    protected void createContents(Composite parent) {
        this.setLayout(parent);
        this.field = this.widgetFactory.createText(parent, "", 0x800808);
        this.field.setLayoutData((Object)new GridData(768));
        this.chooseBt = this.widgetFactory.createButton(parent, "...", 8);
    }

    private void setLayout(Composite parent) {
        int numColumns = this.getNumberOfColumns();
        if (numColumns < 2) {
            numColumns = 2;
        }
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
    }

    protected int getNumberOfColumns() {
        return 2;
    }

    protected void hookListeners() {
        this.field.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String oldPath = FileChooser.this.getSelection();
                String newPath = FileChooser.this.field.getText();
                if (newPath != null) {
                    newPath = newPath.trim();
                }
                FileChooser.this.setSelection(newPath, false);
                FileChooser.this.handleFilePathChange(oldPath, newPath);
            }
        });
        this.chooseBt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileChooser.this.handleChoose();
            }
        });
    }

    public void setEditable(boolean isEditable) {
        if (this.field != null) {
            this.field.setEditable(isEditable);
        }
    }

    private void handleChoose() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setFilterExtensions(this.getFilterExtensions());
        String filePath = dialog.open();
        if (filePath != null) {
            String oldPath = this.getSelection();
            this.setSelection(filePath);
            this.handleFilePathChange(filePath, oldPath);
        }
    }

    private void handleFilePathChange(String filePath, String oldPath) {
        if (this.fileHasChanged(oldPath, filePath)) {
            Event e = new Event();
            this.notifyListeners(24, e);
        }
    }

    public void setChangeable(boolean isChangeable) {
        this.chooseBt.setEnabled(isChangeable);
    }

    public String getSelection() {
        return this.selectedFile;
    }

    public void setSelection(String selection) {
        this.setSelection(selection, true);
    }

    public void setSelection(String selection, boolean updateField) {
        String name = "";
        if (selection != null) {
            name = selection;
        }
        this.selectedFile = name;
        if (updateField) {
            this.field.setText(name);
            if (this.field.isFocusControl()) {
                this.field.setSelection(this.selectedFile.length());
            }
        }
    }

    public void addModifyListener(ModifyListener listener) {
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(24, (Listener)typedListener);
    }

    public void removeModifyListener(SelectionListener listener) {
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(24, (SWTEventListener)listener);
    }

    protected TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.widgetFactory;
    }

    protected String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    protected void setFilterExtensions(String[] filterExtensions) {
        this.filterExtensions = filterExtensions;
    }

    private boolean fileHasChanged(String oldFilePath, String newFilePath) {
        boolean change = true;
        if (oldFilePath == null && newFilePath == null || oldFilePath != null && oldFilePath.equals(newFilePath)) {
            change = false;
        }
        return change;
    }

    public void setStatus(List<IStatus> statusList) {
        if (statusList != null && !statusList.isEmpty()) {
            int severity = -1;
            String toolTip = "";
            for (IStatus status : statusList) {
                toolTip = "* " + status.getMessage() + "\n";
                if (severity == 4) continue;
                severity = status.getSeverity();
            }
            this.field.setToolTipText(toolTip.substring(0, toolTip.length() - 2));
            if (severity == 4) {
                this.field.setBackground(ColorRegistry.COLOR_ERROR);
            } else if (severity == 2) {
                this.field.setBackground(ColorRegistry.COLOR_WARNING);
            }
        } else {
            this.field.setToolTipText("");
            this.field.setBackground(ColorRegistry.COLOR_WHITE);
        }
    }
}

